/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.fight;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.fight.FightConfig;
import fr.neatmonster.nocheatplus.checks.fight.FightData;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.utilities.collision.Axis;
import fr.neatmonster.nocheatplus.utilities.collision.AxisAlignedBBUtils;
import fr.neatmonster.nocheatplus.utilities.collision.CollisionUtil;
import fr.neatmonster.nocheatplus.utilities.collision.tracing.axis.InteractAxisTracing;
import fr.neatmonster.nocheatplus.utilities.ds.map.BlockCoord;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.MapUtil;
import fr.neatmonster.nocheatplus.utilities.map.WrapBlockCache;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.moving.MovingUtil;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Visible
extends Check {
    private final InteractAxisTracing rayTracing = new InteractAxisTracing();
    private final WrapBlockCache wrapBlockCache = new WrapBlockCache();

    public Visible() {
        super(CheckType.FIGHT_VISIBLE);
        this.rayTracing.setMaxSteps(30);
    }

    public boolean check(Player player, Location loc, Entity damaged, boolean damagedIsFake, Location dLoc, FightData data, FightConfig cc) {
        boolean cancel = false;
        MCAccess mcAccess = (MCAccess)this.mcAccess.getHandle();
        if (!damagedIsFake && mcAccess.isComplexPart(damaged)) {
            return cancel;
        }
        double[] AABB = AxisAlignedBBUtils.createBoundingBoxAtWidthResolutionFor(damaged, dLoc);
        double eyeX = loc.getX();
        double eyeY = loc.getY() + MovingUtil.getEyeHeight(player);
        double eyeZ = loc.getZ();
        int damagedToBlockX = Location.locToBlock((double)dLoc.getX());
        int damagedToBlockY = Location.locToBlock((double)dLoc.getY());
        int damagedToBlockZ = Location.locToBlock((double)dLoc.getZ());
        BlockCoord sCollidingBox = new BlockCoord(AABB[0], AABB[1], AABB[2]);
        BlockCoord eCollidingBox = new BlockCoord(AABB[3], AABB[4], AABB[5]);
        if (AxisAlignedBBUtils.isInsideAABBIncludeEdges(eyeX, eyeY, eyeZ, AABB)) {
            return cancel;
        }
        BlockCache blockCache = this.wrapBlockCache.getBlockCache();
        blockCache.setAccess(loc.getWorld());
        this.rayTracing.setBlockCache(blockCache);
        this.rayTracing.set(dLoc.getX(), dLoc.getY(), dLoc.getZ(), eyeX, eyeY, eyeZ);
        this.rayTracing.loop();
        if (this.rayTracing.collides()) {
            boolean alternativePathExists;
            cancel = true;
            BlockCoord sourceBlock = new BlockCoord(damagedToBlockX, damagedToBlockY, damagedToBlockZ);
            Vector direction = new Vector(eyeX - (double)damagedToBlockX, eyeY - (double)damagedToBlockY, eyeZ - (double)damagedToBlockZ).normalize();
            HashSet<BlockCoord> visited = new HashSet<BlockCoord>();
            Axis.RichAxisData axisData = new Axis.RichAxisData(Axis.NONE, BlockChangeTracker.Direction.NONE);
            block0: do {
                alternativePathExists = false;
                for (BlockCoord neighbor : MapUtil.getNeighborsInDirection(sourceBlock, direction, eyeX, eyeY, eyeZ, axisData)) {
                    if (!CollisionUtil.canPassThrough(this.rayTracing, blockCache, sourceBlock, neighbor.getX(), neighbor.getY(), neighbor.getZ(), direction, eyeX, eyeY, eyeZ, MovingUtil.getEyeHeight(player), sCollidingBox, eCollidingBox, false, axisData) || !CollisionUtil.correctDir(neighbor.getY(), damagedToBlockY, Location.locToBlock((double)eyeY), sCollidingBox.getY(), eCollidingBox.getY()) || visited.contains(neighbor)) continue;
                    if (TrigUtil.isSameBlock(neighbor.getX(), neighbor.getY(), neighbor.getZ(), eyeX, eyeY, eyeZ)) {
                        cancel = false;
                        continue block0;
                    }
                    visited.add(neighbor);
                    this.rayTracing.set(neighbor.getX(), neighbor.getY(), neighbor.getZ(), eyeX, eyeY, eyeZ);
                    this.rayTracing.loop();
                    alternativePathExists = true;
                    cancel = this.rayTracing.collides();
                    sourceBlock = new BlockCoord(neighbor.getX(), neighbor.getY(), neighbor.getZ());
                    direction = new Vector(eyeX - (double)neighbor.getX(), eyeY - (double)neighbor.getY(), eyeZ - (double)neighbor.getZ()).normalize();
                    continue block0;
                }
            } while (cancel && alternativePathExists);
        }
        if (this.rayTracing.getStepsDone() > this.rayTracing.getMaxSteps()) {
            cancel = true;
        }
        if (cancel) {
            data.visibleVL += 1.0;
            ViolationData vd = new ViolationData(this, player, data.visibleVL, 1.0, cc.visibleActions);
            cancel = this.executeActions(vd).willCancel();
        }
        this.rayTracing.cleanup();
        blockCache.cleanup();
        return cancel;
    }
}

