/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.fight;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.combined.Improbable;
import fr.neatmonster.nocheatplus.checks.fight.FightConfig;
import fr.neatmonster.nocheatplus.checks.fight.FightData;
import fr.neatmonster.nocheatplus.checks.fight.ReachContext;
import fr.neatmonster.nocheatplus.checks.moving.location.tracking.LocationTrace;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Giant;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Reach
extends Check {
    public static final double CREATIVE_DISTANCE = 6.0;

    private static double getDistMod(Entity damaged) {
        if (damaged instanceof EnderDragon) {
            return 6.5;
        }
        if (damaged instanceof Giant) {
            return 1.5;
        }
        return 0.0;
    }

    public Reach() {
        super(CheckType.FIGHT_REACH);
    }

    public boolean check(Player player, Location pLoc, Entity damaged, boolean damagedIsFake, Location dRef, FightData data, FightConfig cc, IPlayerData pData) {
        double dY;
        double pY;
        boolean cancel = false;
        double SURVIVAL_DISTANCE = cc.reachSurvivalDistance;
        double DYNAMIC_RANGE = cc.reachReduceDistance;
        double DYNAMIC_STEP = cc.reachReduceStep / SURVIVAL_DISTANCE;
        double distanceLimit = player.getGameMode() == GameMode.CREATIVE ? 6.0 : SURVIVAL_DISTANCE + Reach.getDistMod(damaged);
        double distanceMin = (distanceLimit - DYNAMIC_RANGE) / distanceLimit;
        double height = damagedIsFake ? (damaged instanceof LivingEntity ? ((LivingEntity)damaged).getEyeHeight() : 1.75) : ((MCAccess)this.mcAccess.getHandle()).getHeight(damaged);
        double width = damagedIsFake ? 0.6 : ((MCAccess)this.mcAccess.getHandle()).getWidth(damaged);
        double centertoedge = 0.0;
        if (cc.reachPrecision) {
            centertoedge = this.getinset(pLoc, dRef, width / 2.0, 0.0);
        }
        if (!((pY = pLoc.getY() + player.getEyeHeight()) <= (dY = dRef.getY()))) {
            if (pY >= dY + height) {
                dRef.setY(dY + height);
            } else {
                dRef.setY(pY);
            }
        }
        Vector pRel = dRef.toVector().subtract(pLoc.toVector().setY(pY));
        double lenpRel = pRel.length() - centertoedge;
        double violation = lenpRel - distanceLimit;
        double reachMod = data.reachMod;
        if (violation > 0.0) {
            if (TickTask.getLag(1000L, true) < 1.5f) {
                data.reachVL += violation;
                ViolationData vd = new ViolationData(this, player, data.reachVL, violation, cc.reachActions);
                vd.setParameter(ParameterName.REACH_DISTANCE, StringUtil.fdec3.format(lenpRel));
                cancel = this.executeActions(vd).willCancel();
            }
            if (Improbable.check(player, (float)violation / 2.0f, System.currentTimeMillis(), "fight.reach", pData)) {
                cancel = true;
            }
            if (cancel && cc.reachPenalty > 0L) {
                data.attackPenalty.applyPenalty(cc.reachPenalty);
            }
        } else if (lenpRel - distanceLimit * reachMod > 0.0) {
            if (cc.reachPenalty > 0L) {
                data.attackPenalty.applyPenalty(cc.reachPenalty / 2L);
            }
            cancel = true;
            Improbable.feed(player, (float)(lenpRel - distanceLimit * reachMod) / 4.0f, System.currentTimeMillis());
        } else {
            data.reachVL *= 0.8;
        }
        data.reachMod = !cc.reachReduce ? 1.0 : (lenpRel > distanceLimit - DYNAMIC_RANGE ? Math.max(distanceMin, data.reachMod - DYNAMIC_STEP) : Math.min(1.0, data.reachMod + DYNAMIC_STEP));
        if (pData.isDebugActive(this.type) && pData.hasPermission(Permissions.ADMINISTRATION_DEBUG, player)) {
            player.sendMessage("NC+: Attack/reach " + damaged.getType() + " height=" + StringUtil.fdec3.format(height) + " dist=" + StringUtil.fdec3.format(lenpRel) + " @" + StringUtil.fdec3.format(reachMod));
        }
        return cancel;
    }

    public ReachContext getContext(Player player, Location pLoc, Entity damaged, Location damagedLoc, FightData data, FightConfig cc) {
        ReachContext context = new ReachContext();
        context.distanceLimit = player.getGameMode() == GameMode.CREATIVE ? 6.0 : cc.reachSurvivalDistance + Reach.getDistMod(damaged);
        context.distanceMin = (context.distanceLimit - cc.reachReduceDistance) / context.distanceLimit;
        context.pY = pLoc.getY() + player.getEyeHeight();
        return context;
    }

    public boolean loopCheck(Player player, Location pLoc, Entity damaged, LocationTrace.ITraceEntry dRef, ReachContext context, FightData data, FightConfig cc) {
        double lenpRel;
        double violation;
        boolean cancel = false;
        double dY = dRef.getY();
        double y = dRef.getY();
        if (!(context.pY <= dY)) {
            y = context.pY >= dY + dRef.getBoxMarginVertical() ? dY + dRef.getBoxMarginVertical() : context.pY;
        }
        double centertoedge = 0.0;
        if (cc.reachPrecision) {
            centertoedge = this.getinset(pLoc, new Location(null, dRef.getX(), dRef.getY(), dRef.getZ()), dRef.getBoxMarginHorizontal(), y - context.pY);
        }
        if ((violation = (lenpRel = TrigUtil.distance(dRef.getX(), y, dRef.getZ(), pLoc.getX(), context.pY, pLoc.getZ()) - centertoedge) - context.distanceLimit) > 0.0 || lenpRel - context.distanceLimit * data.reachMod > 0.0) {
            context.minViolation = Math.min(context.minViolation, lenpRel);
            cancel = true;
        }
        context.minResult = Math.min(context.minResult, lenpRel);
        return cancel;
    }

    public boolean loopFinish(Player player, Location pLoc, Entity damaged, ReachContext context, LocationTrace.ITraceEntry traceEntry, boolean forceViolation, FightData data, FightConfig cc, IPlayerData pData) {
        double lenpRel;
        double d = lenpRel = forceViolation && context.minViolation != Double.MAX_VALUE ? context.minViolation : context.minResult;
        if (lenpRel == Double.MAX_VALUE) {
            return false;
        }
        double violation = lenpRel - context.distanceLimit;
        boolean cancel = false;
        if (violation > 0.0) {
            if (TickTask.getLag(1000L, true) < 1.5f) {
                data.reachVL += violation;
                ViolationData vd = new ViolationData(this, player, data.reachVL, violation, cc.reachActions);
                vd.setParameter(ParameterName.REACH_DISTANCE, StringUtil.fdec3.format(lenpRel));
                cancel = this.executeActions(vd).willCancel();
            }
            if (cc.reachImprobableWeight > 0.0f && !cc.reachImprobableFeedOnly && Improbable.check(player, (float)violation / cc.reachImprobableWeight, System.currentTimeMillis(), "fight.reach", pData)) {
                cancel = true;
            }
            if (cancel && cc.reachPenalty > 0L) {
                data.attackPenalty.applyPenalty(cc.reachPenalty);
            }
        } else if (lenpRel - context.distanceLimit * data.reachMod > 0.0) {
            if (cc.reachPenalty > 0L) {
                data.attackPenalty.applyPenalty(cc.reachPenalty / 2L);
            }
            cancel = true;
            if (cc.reachImprobableWeight > 0.0f) {
                Improbable.feed(player, (float)(lenpRel - context.distanceLimit * data.reachMod) / cc.reachImprobableWeight, System.currentTimeMillis());
            }
        } else {
            data.reachVL *= 0.8;
        }
        double DYNAMIC_STEP = cc.reachReduceStep / cc.reachSurvivalDistance;
        data.reachMod = !cc.reachReduce ? 1.0 : (lenpRel > context.distanceLimit - cc.reachReduceDistance ? Math.max(context.distanceMin, data.reachMod - DYNAMIC_STEP) : Math.min(1.0, data.reachMod + DYNAMIC_STEP));
        if (pData.isDebugActive(this.type) && pData.hasPermission(Permissions.ADMINISTRATION_DEBUG, player)) {
            player.sendMessage("NC+: Attack/reach " + damaged.getType() + (traceEntry == null ? "" : " height=" + traceEntry.getBoxMarginVertical()) + " dist=" + StringUtil.fdec3.format(lenpRel) + " @" + StringUtil.fdec3.format(data.reachMod));
        }
        return cancel;
    }

    private boolean isSameXZ(Location loc1, Location loc2) {
        return loc1.getX() == loc2.getX() && loc1.getZ() == loc2.getZ();
    }

    private double getinset(Location pLoc, Location dRef, double damagedBoxMarginHorizontal, double diffY) {
        if (!this.isSameXZ(pLoc, dRef)) {
            Location dRefc = dRef.clone();
            Vector vec1 = new Vector(pLoc.getX() - dRef.getX(), diffY, pLoc.getZ() - dRef.getZ());
            if (vec1.length() < damagedBoxMarginHorizontal * Math.sqrt(2.0)) {
                return 0.0;
            }
            if (vec1.getZ() > 0.0) {
                dRefc.setZ(dRefc.getZ() + damagedBoxMarginHorizontal);
            } else if (vec1.getZ() < 0.0) {
                dRefc.setZ(dRefc.getZ() - damagedBoxMarginHorizontal);
            } else if (vec1.getX() > 0.0) {
                dRefc.setX(dRefc.getX() + damagedBoxMarginHorizontal);
            } else {
                dRefc.setX(dRefc.getX() - damagedBoxMarginHorizontal);
            }
            Vector vec2 = new Vector(dRefc.getX() - dRef.getX(), 0.0, dRefc.getZ() - dRef.getZ());
            double angle = TrigUtil.angle(vec1, vec2);
            if (angle > 0.7853981633974483) {
                angle = 1.5707963267948966 - angle;
            }
            if (angle >= 0.0 && angle <= 0.7853981633974483) {
                return damagedBoxMarginHorizontal / Math.cos(angle);
            }
        }
        return 0.0;
    }
}

