/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.fight;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.ACheckConfig;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.versions.Bugs;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.config.value.OverrideType;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.worlds.IWorldData;

public class FightConfig
extends ACheckConfig {
    public final double angleMove;
    public final double angleYaw;
    public final double angleSwitch;
    public final double angleTime;
    public final ActionList angleActions;
    public final long toolChangeAttackPenalty;
    public final ActionList criticalActions;
    public final boolean directionStrict;
    public final boolean directionFailAll;
    public final double directionloopprecision;
    public final double directionangleprecision;
    public final long directionPenalty;
    public final ActionList directionActions;
    public final long fastHealInterval;
    public final long fastHealBuffer;
    public final ActionList fastHealActions;
    public final long godModeLagMinAge;
    public final long godModeLagMaxAge;
    public final ActionList godModeActions;
    public final ActionList noSwingActions;
    public final long reachPenalty;
    public final boolean reachPrecision;
    public final boolean reachReduce;
    public final double reachSurvivalDistance;
    public final double reachReduceDistance;
    public final double reachReduceStep;
    public final boolean reachImprobableFeedOnly;
    public final float reachImprobableWeight;
    public final ActionList reachActions;
    public final ActionList selfHitActions;
    public final ActionList visibleActions;
    public final boolean cancelDead;
    public boolean enforceItemRelease;
    public boolean enforceClosedInventory;
    public final boolean knockBackVelocityPvP;
    public final long loopMaxLatencyTicks;

    public FightConfig(IWorldData worldData) {
        super(worldData);
        ConfigFile config = worldData.getRawConfiguration();
        this.angleMove = config.getDouble("checks.fight.angle.threshold.avg-move");
        this.angleSwitch = config.getDouble("checks.fight.angle.threshold.avg-switch");
        this.angleYaw = config.getDouble("checks.fight.angle.threshold.avg-yaw");
        this.angleTime = config.getDouble("checks.fight.angle.threshold.avg-time");
        this.angleActions = (ActionList)config.getOptimizedActionList("checks.fight.angle.actions", Permissions.FIGHT_ANGLE);
        this.toolChangeAttackPenalty = config.getLong("checks.fight.tool-change-penalty");
        this.criticalActions = (ActionList)config.getOptimizedActionList("checks.fight.critical.actions", Permissions.FIGHT_CRITICAL);
        this.directionStrict = config.getBoolean("checks.fight.direction.strict");
        this.directionFailAll = config.getBoolean("checks.fight.direction.failall");
        this.directionangleprecision = config.getDouble("checks.fight.direction.strict-angle-precision", 50.0, 100.0, 80.0);
        this.directionloopprecision = config.getDouble("checks.fight.direction.loop-precision", 0.0, 2.0, 0.5);
        this.directionPenalty = config.getLong("checks.fight.direction.penalty");
        this.directionActions = (ActionList)config.getOptimizedActionList("checks.fight.direction.actions", Permissions.FIGHT_DIRECTION);
        if (ServerVersion.compareMinecraftVersion("1.9") >= 0) {
            NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager().overrideCheckActivation(CheckType.FIGHT_FASTHEAL, AlmostBoolean.NO, OverrideType.PERMANENT, true);
        }
        if (ServerVersion.compareMinecraftVersion("1.8") >= 0) {
            NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager().overrideCheckActivation(CheckType.FIGHT_SELFHIT, AlmostBoolean.NO, OverrideType.PERMANENT, true);
        }
        this.fastHealInterval = config.getLong("checks.fight.fastheal.interval");
        this.fastHealBuffer = config.getLong("checks.fight.fastheal.buffer");
        this.fastHealActions = (ActionList)config.getOptimizedActionList("checks.fight.fastheal.actions", Permissions.FIGHT_FASTHEAL);
        this.godModeLagMinAge = config.getLong("checks.fight.godmode.min-age");
        this.godModeLagMaxAge = config.getLong("checks.fight.godmode.max-age");
        this.godModeActions = (ActionList)config.getOptimizedActionList("checks.fight.godmode.actions", Permissions.FIGHT_GODMODE);
        this.noSwingActions = (ActionList)config.getOptimizedActionList("checks.fight.noswing.actions", Permissions.FIGHT_NOSWING);
        this.reachSurvivalDistance = config.getDouble("checks.fight.reach.survival-distance", 3.5, 6.0, 4.1);
        this.reachPenalty = config.getLong("checks.fight.reach.penalty");
        this.reachPrecision = config.getBoolean("checks.fight.reach.precision");
        this.reachReduce = config.getBoolean("checks.fight.reach.reduce");
        this.reachReduceDistance = config.getDouble("checks.fight.reach.reduce-distance", 0.0, this.reachSurvivalDistance, 0.9);
        this.reachReduceStep = config.getDouble("checks.fight.reach.reduce-step", 0.0, this.reachReduceDistance, 0.15);
        this.reachImprobableFeedOnly = config.getBoolean("checks.fight.reach.improbable.feed-only");
        this.reachImprobableWeight = (float)config.getDouble("checks.fight.reach.improbable.weight");
        this.reachActions = (ActionList)config.getOptimizedActionList("checks.fight.reach.actions", Permissions.FIGHT_REACH);
        this.selfHitActions = (ActionList)config.getOptimizedActionList("checks.fight.selfhit.actions", Permissions.FIGHT_SELFHIT);
        this.visibleActions = (ActionList)config.getOptimizedActionList("checks.fight.visible.actions", Permissions.FIGHT_VISIBLE);
        this.cancelDead = config.getBoolean("checks.fight.cancel-dead");
        this.enforceItemRelease = config.getBoolean("checks.fight.enforce-item-release");
        this.enforceClosedInventory = config.getBoolean("checks.fight.enforce-closed-inventory");
        this.loopMaxLatencyTicks = config.getInt("checks.fight.max-loop-latency-ticks", 1, 15, 8);
        AlmostBoolean ref = config.getAlmostBoolean("checks.fight.knockback-velocity", AlmostBoolean.MAYBE);
        this.knockBackVelocityPvP = ref == AlmostBoolean.MAYBE ? Bugs.shouldPvpKnockBackVelocity() : ref.decide();
    }
}

