/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.fight;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.fight.DirectionContext;
import fr.neatmonster.nocheatplus.checks.fight.FightConfig;
import fr.neatmonster.nocheatplus.checks.fight.FightData;
import fr.neatmonster.nocheatplus.checks.moving.location.tracking.LocationTrace;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.utilities.collision.CollisionUtil;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Direction
extends Check {
    public Direction() {
        super(CheckType.FIGHT_DIRECTION);
    }

    public boolean check(Player player, Location loc, Entity damaged, boolean damagedIsFake, Location dLoc, FightData data, FightConfig cc) {
        double width;
        boolean cancel = false;
        MCAccess mcAccess = (MCAccess)this.mcAccess.getHandle();
        if (!damagedIsFake && mcAccess.isComplexPart(damaged)) {
            return false;
        }
        double d = width = damagedIsFake ? 0.6 : mcAccess.getWidth(damaged);
        double height = damagedIsFake ? (damaged instanceof LivingEntity ? ((LivingEntity)damaged).getEyeHeight() : 1.75) : mcAccess.getHeight(damaged);
        Vector direction = loc.getDirection();
        double off = CollisionUtil.directionCheck(loc, player.getEyeHeight(), direction, dLoc.getX(), dLoc.getY() + height / 2.0, dLoc.getZ(), width, height, 2.6);
        if (off > 0.1) {
            Vector blockEyes = new Vector(dLoc.getX() - loc.getX(), dLoc.getY() + height / 2.0 - loc.getY() - player.getEyeHeight(), dLoc.getZ() - loc.getZ());
            double distance = blockEyes.crossProduct(direction).length() / direction.length();
            data.directionVL += distance;
            cancel = this.executeActions(player, data.directionVL, distance, cc.directionActions).willCancel();
            if (cancel) {
                data.attackPenalty.applyPenalty(cc.directionPenalty);
            }
        } else {
            data.directionVL *= 0.8;
        }
        return cancel;
    }

    public DirectionContext getContext(Player player, Location loc, Entity damaged, boolean damagedIsFake, Location damagedLoc, FightData data, FightConfig cc) {
        DirectionContext context = new DirectionContext();
        if (damagedIsFake) {
            context.damagedComplex = false;
        } else {
            MCAccess mcAccess = (MCAccess)this.mcAccess.getHandle();
            context.damagedComplex = mcAccess.isComplexPart(damaged);
        }
        context.direction = loc.getDirection();
        context.lengthDirection = context.direction.length();
        return context;
    }

    public boolean loopCheck(Player player, Location loc, Entity damaged, LocationTrace.ITraceEntry dLoc, DirectionContext context, FightData data, FightConfig cc) {
        if (context.damagedComplex) {
            return false;
        }
        boolean cancel = false;
        boolean isPlayer = damaged instanceof Player;
        double damagedBoxMarginHorizontal = dLoc.getBoxMarginHorizontal();
        double damagedBoxMarginVertical = dLoc.getBoxMarginVertical();
        double off = cc.directionStrict ? CollisionUtil.combinedDirectionCheck(loc, player.getEyeHeight(), context.direction, dLoc.getX(), dLoc.getY() + damagedBoxMarginVertical / 2.0, dLoc.getZ(), damagedBoxMarginHorizontal * 2.0, damagedBoxMarginVertical, cc.directionloopprecision, cc.directionangleprecision, isPlayer) : CollisionUtil.directionCheck(loc, player.getEyeHeight(), context.direction, dLoc.getX(), dLoc.getY() + damagedBoxMarginVertical / 2.0, dLoc.getZ(), damagedBoxMarginHorizontal * 2.0, damagedBoxMarginVertical, cc.directionloopprecision);
        if (off > 0.0) {
            if (dLoc.isInside(loc.getX(), loc.getY() + player.getEyeHeight(), loc.getZ())) {
                context.minResult = 0.0;
            } else {
                if (off > 0.11) {
                    Vector blockEyes = new Vector(dLoc.getX() - loc.getX(), dLoc.getY() + damagedBoxMarginVertical / 2.0 - loc.getY() - player.getEyeHeight(), dLoc.getZ() - loc.getZ());
                    double distance = blockEyes.crossProduct(context.direction).length() / context.lengthDirection;
                    context.minViolation = Math.min(context.minViolation, distance);
                    cancel = true;
                }
                context.minResult = Math.min(context.minResult, off);
            }
        } else if (cc.directionFailAll) {
            context.minResult = 0.0;
        }
        return cancel;
    }

    public boolean loopFinish(Player player, Location loc, Entity damaged, DirectionContext context, boolean forceViolation, FightData data, FightConfig cc) {
        double off;
        boolean cancel = false;
        double d = off = forceViolation && context.minViolation != Double.MAX_VALUE ? context.minViolation : context.minResult;
        if (off == Double.MAX_VALUE) {
            return false;
        }
        if (off > 0.1) {
            data.directionVL += off;
            cancel = this.executeActions(player, data.directionVL, off, cc.directionActions).willCancel();
            if (cancel) {
                data.attackPenalty.applyPenalty(cc.directionPenalty);
            }
        } else {
            data.directionVL *= 0.8;
        }
        return cancel;
    }
}

