/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.fight;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.fight.FightConfig;
import fr.neatmonster.nocheatplus.checks.fight.FightData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveInfo;
import fr.neatmonster.nocheatplus.checks.moving.velocity.VelocityFlags;
import fr.neatmonster.nocheatplus.compat.Bridge1_13;
import fr.neatmonster.nocheatplus.penalties.IPenaltyList;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockFlags;
import fr.neatmonster.nocheatplus.utilities.moving.AuxMoving;
import fr.neatmonster.nocheatplus.utilities.moving.MovingUtil;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class Critical
extends Check {
    private final AuxMoving auxMoving = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(AuxMoving.class);

    public Critical() {
        super(CheckType.FIGHT_CRITICAL);
    }

    public boolean check(Player player, Location loc, FightData data, FightConfig cc, IPlayerData pData, IPenaltyList penaltyList) {
        boolean cancel = false;
        ArrayList tags = new ArrayList();
        MovingData mData = pData.getGenericInstance(MovingData.class);
        MovingConfig mCC = pData.getGenericInstance(MovingConfig.class);
        PlayerMoveData thisMove = mData.playerMoves.getCurrentMove();
        PlayerMoveData lastMove = mData.playerMoves.getFirstPastMove();
        double mcFallDistance = player.getFallDistance();
        double ncpFallDistance = mData.noFallFallDistance;
        double realisticFallDistance = MovingUtil.getRealisticFallDistance(player, thisMove.from.getY(), thisMove.to.getY(), mData, pData);
        PlayerMoveInfo moveInfo = this.auxMoving.usePlayerMoveInfo();
        moveInfo.set(player, loc, null, mCC.yOnGround);
        if (mcFallDistance > 0.0 && !player.isInsideVehicle() && !player.hasPotionEffect(PotionEffectType.BLINDNESS)) {
            boolean isIllegal;
            if (pData.isDebugActive(this.type)) {
                this.debug(player, "Fall distances: MC(" + StringUtil.fdec3.format(mcFallDistance) + ") | NCP(" + StringUtil.fdec3.format(ncpFallDistance) + ") | R(" + StringUtil.fdec3.format(realisticFallDistance) + ")\nfD diff: " + StringUtil.fdec3.format(Math.abs(ncpFallDistance - mcFallDistance)) + "\nJumpPhase: " + mData.sfJumpPhase + " | NCP onGround: " + (thisMove.from.onGround ? "ground -> " : "--- -> ") + (thisMove.to.onGround ? "ground" : "---") + " | MC onGround: " + player.isOnGround());
            }
            ((PlayerLocation)moveInfo.from).collectBlockFlags(0.4);
            if (((PlayerLocation)moveInfo.from).isOnGroundDueToStandingOnAnEntity() || (((PlayerLocation)moveInfo.from).getBlockFlags() & BlockFlags.F_BOUNCE25) != 0L && !((PlayerLocation)moveInfo.from).isOnGround() && !((PlayerLocation)moveInfo.to).isOnGround()) {
                this.auxMoving.returnPlayerMoveInfo(moveInfo);
                return false;
            }
            boolean bl = isIllegal = ((PlayerLocation)moveInfo.from).isResetCond() || !Double.isInfinite(Bridge1_13.getSlowfallingAmplifier((LivingEntity)player)) || mData.sfJumpPhase > 0 && mData.sfJumpPhase <= mData.liftOffEnvelope.getMaxJumpPhase(mData.jumpAmplifier) && !((PlayerLocation)moveInfo.from).seekCollisionAbove(0.2) && (lastMove.verVelUsed.isEmpty() || !lastMove.verVelUsed.get(0).hasFlag(VelocityFlags.ORIGIN_BLOCK_BOUNCE)) || Math.abs(ncpFallDistance - mcFallDistance) > 1.0E-5 && (((PlayerLocation)moveInfo.from).isOnGround() || lastMove.touchedGroundWorkaround);
            if (isIllegal) {
                data.criticalVL += 1.0;
                ViolationData vd = new ViolationData(this, player, data.criticalVL, 1.0, cc.criticalActions);
                if (vd.needsParameters()) {
                    vd.setParameter(ParameterName.TAGS, StringUtil.join(tags, "+"));
                }
                cancel = this.executeActions(vd).willCancel();
            } else {
                data.criticalVL *= 0.96;
            }
        }
        this.auxMoving.returnPlayerMoveInfo(moveInfo);
        return cancel;
    }
}

