/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.fight;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.fight.FightConfig;
import fr.neatmonster.nocheatplus.checks.fight.FightData;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class Angle
extends Check {
    private final List<String> tags = new LinkedList<String>();
    public static long maxTimeDiff = 1000L;

    public Angle() {
        super(CheckType.FIGHT_ANGLE);
    }

    public boolean check(Player player, Location loc, Entity damagedEntity, boolean worldChanged, FightData data, FightConfig cc, IPlayerData pData) {
        AttackLocation lastLoc;
        if (worldChanged) {
            data.angleHits.clear();
        }
        boolean cancel = false;
        this.tags.clear();
        long time = System.currentTimeMillis();
        AttackLocation attackLocation = lastLoc = data.angleHits.isEmpty() ? null : data.angleHits.getLast();
        if (lastLoc != null && time - lastLoc.time > maxTimeDiff) {
            data.angleHits.clear();
            lastLoc = null;
        }
        data.angleHits.add(new AttackLocation(loc, damagedEntity.getUniqueId(), System.currentTimeMillis(), lastLoc));
        double deltaMove = 0.0;
        long deltaTime = 0L;
        float deltaYaw = 0.0f;
        int deltaSwitchTarget = 0;
        Iterator it = data.angleHits.iterator();
        while (it.hasNext()) {
            AttackLocation refLoc = (AttackLocation)it.next();
            if (time - refLoc.time > maxTimeDiff) {
                it.remove();
                continue;
            }
            deltaMove += refLoc.distSqLast;
            double yawDiff = Math.abs(refLoc.yawDiffLast);
            deltaYaw = (float)((double)deltaYaw + yawDiff);
            deltaTime += refLoc.timeDiff;
            if (!refLoc.idDiffLast || !(yawDiff > 30.0)) continue;
            ++deltaSwitchTarget;
        }
        if (data.angleHits.size() < 2) {
            return false;
        }
        double n = data.angleHits.size() - 1;
        double averageMove = deltaMove / n;
        averageMove *= (double)TickTask.getLag(maxTimeDiff, true);
        double averageTime = (double)deltaTime / n;
        averageTime *= (double)TickTask.getLag(maxTimeDiff, true);
        double averageYaw = (double)deltaYaw / n;
        averageYaw /= (double)TickTask.getLag(maxTimeDiff, true);
        double averageSwitching = (double)deltaSwitchTarget / n;
        averageSwitching /= (double)TickTask.getLag(maxTimeDiff, true);
        double violation = 0.0;
        double violationMove = 0.0;
        double violationTime = 0.0;
        double violationYaw = 0.0;
        double violationSwitchSpeed = 0.0;
        if (averageMove >= 0.0 && averageMove < 0.2) {
            violationMove += 20.0 * (0.2 - averageMove) / 0.2;
            this.tags.add("avgmove");
            if (pData.isDebugActive(this.type) && pData.hasPermission(Permissions.ADMINISTRATION_DEBUG, player)) {
                player.sendMessage(ChatColor.RED + "NC+ Debug: " + ChatColor.RESET + "avgMove: " + averageMove + " avgMove VL: " + violationMove + "/" + cc.angleMove);
            }
        }
        if (averageTime >= 0.0 && averageTime < 150.0) {
            violationTime += 30.0 * (150.0 - averageTime) / 150.0;
            this.tags.add("avgtime");
            if (pData.isDebugActive(this.type) && pData.hasPermission(Permissions.ADMINISTRATION_DEBUG, player)) {
                player.sendMessage(ChatColor.RED + "NC+ Debug: " + ChatColor.RESET + "avgTime: " + averageTime + " avgTime VL: " + violationTime + "/" + cc.angleTime);
            }
        }
        if (averageYaw > 50.0) {
            violationYaw += 30.0 * averageYaw / 180.0;
            this.tags.add("avgyaw");
            if (pData.isDebugActive(this.type) && pData.hasPermission(Permissions.ADMINISTRATION_DEBUG, player)) {
                player.sendMessage(ChatColor.RED + "NC+ Debug: " + ChatColor.RESET + "avgYaw: " + averageYaw + " avgYaw VL: " + violationYaw + "/" + cc.angleYaw);
            }
        }
        if (averageSwitching > 0.0) {
            violationSwitchSpeed += 20.0 * averageSwitching;
            this.tags.add("switchspeed");
            if (pData.isDebugActive(this.type) && pData.hasPermission(Permissions.ADMINISTRATION_DEBUG, player)) {
                player.sendMessage(ChatColor.RED + "NC+ Debug: " + ChatColor.RESET + "avgSwitch: " + averageSwitching + " avgSwitch VL: " + violationSwitchSpeed + "/" + cc.angleSwitch);
            }
        }
        if (violationMove > cc.angleMove) {
            violation = violationMove;
            data.angleVL += violation;
            ViolationData vd = new ViolationData(this, player, data.angleVL, violation, cc.angleActions);
            if (vd.needsParameters()) {
                vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
            }
            cancel = this.executeActions(vd).willCancel();
        } else if (violationTime > cc.angleTime) {
            violation = violationTime;
            data.angleVL += violation;
            ViolationData vd = new ViolationData(this, player, data.angleVL, violation, cc.angleActions);
            if (vd.needsParameters()) {
                vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
            }
            cancel = this.executeActions(vd).willCancel();
        } else if (violationYaw > cc.angleYaw) {
            violation = violationYaw;
            data.angleVL += violation;
            ViolationData vd = new ViolationData(this, player, data.angleVL, violation, cc.angleActions);
            if (vd.needsParameters()) {
                vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
            }
            cancel = this.executeActions(vd).willCancel();
        } else if (violationSwitchSpeed > cc.angleSwitch) {
            violation = violationSwitchSpeed;
            data.angleVL += violation;
            ViolationData vd = new ViolationData(this, player, data.angleVL, violation, cc.angleActions);
            if (vd.needsParameters()) {
                vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
            }
            cancel = this.executeActions(vd).willCancel();
        } else {
            data.angleVL *= 0.98;
        }
        return cancel;
    }

    public static class AttackLocation {
        public final double x;
        public final double y;
        public final double z;
        public final float yaw;
        public long time;
        public final UUID damagedId;
        public final double distSqLast;
        public final double yawDiffLast;
        public final long timeDiff;
        public final boolean idDiffLast;

        public AttackLocation(Location loc, UUID damagedId, long time, AttackLocation lastLoc) {
            this.x = loc.getX();
            this.y = loc.getY();
            this.z = loc.getZ();
            this.yaw = loc.getYaw();
            this.time = time;
            this.damagedId = damagedId;
            if (lastLoc != null) {
                this.distSqLast = TrigUtil.distanceSquared(this.x, this.y, this.z, lastLoc.x, lastLoc.y, lastLoc.z);
                this.yawDiffLast = TrigUtil.yawDiff(this.yaw, lastLoc.yaw);
                this.timeDiff = Math.max(0L, time - lastLoc.time);
                this.idDiffLast = !damagedId.equals(lastLoc.damagedId);
            } else {
                this.distSqLast = 0.0;
                this.yawDiffLast = 0.0;
                this.timeDiff = 0L;
                this.idDiffLast = true;
            }
        }
    }
}

