/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.combined;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.combined.CombinedConfig;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.checks.combined.Improbable;
import fr.neatmonster.nocheatplus.checks.combined.MunchHausen;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveInfo;
import fr.neatmonster.nocheatplus.checks.moving.velocity.VelocityFlags;
import fr.neatmonster.nocheatplus.compat.Bridge1_13;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.versions.ClientVersion;
import fr.neatmonster.nocheatplus.components.NoCheatPlusAPI;
import fr.neatmonster.nocheatplus.components.data.ICheckData;
import fr.neatmonster.nocheatplus.components.data.IData;
import fr.neatmonster.nocheatplus.components.registry.factory.IFactoryOne;
import fr.neatmonster.nocheatplus.components.registry.feature.JoinLeaveListener;
import fr.neatmonster.nocheatplus.components.registry.setup.config.RegisterConfigWorld;
import fr.neatmonster.nocheatplus.components.registry.setup.data.RegisterDataPlayer;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.players.PlayerFactoryArgument;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.moving.AuxMoving;
import fr.neatmonster.nocheatplus.utilities.moving.MovingUtil;
import fr.neatmonster.nocheatplus.worlds.WorldFactoryArgument;
import org.bukkit.Input;
import org.bukkit.Location;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInputEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class CombinedListener
extends CheckListener
implements JoinLeaveListener {
    protected final Improbable improbable = this.addCheck(new Improbable());
    protected final MunchHausen munchHausen = this.addCheck(new MunchHausen());
    private final Counters counters = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class);
    private final int idFakeInvulnerable = this.counters.registerKey("fakeinvulnerable");
    final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final AuxMoving aux = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(AuxMoving.class);

    public CombinedListener() {
        super(CheckType.COMBINED);
        NoCheatPlusAPI api = NCPAPIProvider.getNoCheatPlusAPI();
        if (Bridge1_9.hasEntityToggleGlideEvent()) {
            this.queuedComponents.add(new Listener(){

                @EventHandler(priority=EventPriority.LOWEST)
                public void onToggleGlide(EntityToggleGlideEvent event) {
                    IPlayerData pData = DataManager.getPlayerData((Player)event.getEntity());
                    MovingData data = pData.getGenericInstance(MovingData.class);
                    PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
                    data.addVelocity((Player)event.getEntity(), pData.getGenericInstance(MovingConfig.class), lastMove.xAllowedDistance, lastMove.yAllowedDistance, lastMove.zAllowedDistance, VelocityFlags.FAKED);
                    if (CombinedListener.this.shouldDenyGlidingStart((Player)event.getEntity(), event.isGliding(), true)) {
                        event.setCancelled(true);
                    }
                }
            });
        } else {
            this.queuedComponents.add(new Listener(){

                @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
                public void onEventlessToggleGlide(PlayerMoveEvent event) {
                    PlayerMoveData lastMove = DataManager.getPlayerData((Player)event.getPlayer()).getGenericInstance(MovingData.class).playerMoves.getFirstPastMove();
                    PlayerMoveData thisMove = DataManager.getPlayerData((Player)event.getPlayer()).getGenericInstance(MovingData.class).playerMoves.getCurrentMove();
                    if (CombinedListener.this.shouldDenyGlidingStart(event.getPlayer(), thisMove.isGliding && !lastMove.isGliding, false)) {
                        event.getPlayer().setGliding(false);
                    }
                }
            });
        }
        if (BridgeMisc.hasEntityChangePoseEvent()) {
            this.queuedComponents.add(new Listener(){

                @EventHandler(priority=EventPriority.LOWEST)
                public void onChangingPose(EntityPoseChangeEvent event) {
                    CombinedListener.this.handlePoseChangeEvent(event.getEntity(), event.getPose());
                }
            });
        }
        if (BridgeMisc.hasPlayerInputEvent()) {
            this.queuedComponents.add(new Listener(){

                @EventHandler(priority=EventPriority.LOWEST)
                public void onInputChange(PlayerInputEvent event) {
                    CombinedListener.this.handleInputs(event.getInput(), event.getPlayer());
                }
            });
        }
        api.register(((RegisterDataPlayer)((RegisterDataPlayer)((RegisterConfigWorld)api.newRegistrationContext().registerConfigWorld(CombinedConfig.class).factory((IFactoryOne)new IFactoryOne<WorldFactoryArgument, CombinedConfig>(){

            @Override
            public CombinedConfig getNewInstance(WorldFactoryArgument arg) {
                return new CombinedConfig(arg.worldData);
            }
        })).registerConfigTypesPlayer().context().registerDataPlayer(CombinedData.class).factory((IFactoryOne)new IFactoryOne<PlayerFactoryArgument, CombinedData>(){

            @Override
            public CombinedData getNewInstance(PlayerFactoryArgument arg) {
                return new CombinedData();
            }
        })).addToGroups(CheckType.MOVING, false, new Class[]{IData.class, ICheckData.class})).removeSubCheckData(CheckType.COMBINED, true).context());
    }

    public void handleInputs(Input bukkitInput, Player player) {
        IPlayerData pData = DataManager.getPlayerData(player);
        MovingData data = pData.getGenericInstance(MovingData.class);
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
    }

    private boolean shouldDenyGlidingStart(Player player, boolean toggledOn, boolean isToggleGlideEvent) {
        if (toggledOn) {
            PlayerMoveInfo info = this.aux.usePlayerMoveInfo();
            info.set(player, player.getLocation(info.useLoc), null, 1.0E-4);
            IPlayerData pData = DataManager.getPlayerData(player);
            MovingData data = pData.getGenericInstance(MovingData.class);
            boolean res = !MovingUtil.canLiftOffWithElytra(player, (PlayerLocation)info.from, data);
            PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
            info.cleanup();
            this.aux.returnPlayerMoveInfo(info);
            if (!isToggleGlideEvent && res) {
                data.addVelocity(player, pData.getGenericInstance(MovingConfig.class), lastMove.xAllowedDistance, lastMove.yAllowedDistance, lastMove.zAllowedDistance, VelocityFlags.FAKED);
            }
            if (res && pData.isDebugActive(CheckType.MOVING)) {
                this.debug(player, "Prevent toggle glide on (cheat prevention, " + (isToggleGlideEvent ? "ToggleGlideEvent)" : "PlayerMoveEvent)"));
            }
            return res;
        }
        return false;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onGlidingPhase(PlayerMoveEvent event) {
        IPlayerData pData = DataManager.getPlayerData(event.getPlayer());
        MovingData data = pData.getGenericInstance(MovingData.class);
        if (!Bridge1_9.isGliding((LivingEntity)event.getPlayer())) {
            return;
        }
        PlayerMoveInfo info = this.aux.usePlayerMoveInfo();
        info.set(event.getPlayer(), event.getPlayer().getLocation(info.useLoc), null, 1.0E-4);
        if (MovingUtil.canStillGlide(event.getPlayer(), (PlayerLocation)info.from, data)) {
            info.cleanup();
            this.aux.returnPlayerMoveInfo(info);
            return;
        }
        event.getPlayer().setGliding(false);
        info.cleanup();
        this.aux.returnPlayerMoveInfo(info);
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        if (!Bridge1_9.hasEntityToggleGlideEvent()) {
            data.addVelocity(event.getPlayer(), pData.getGenericInstance(MovingConfig.class), lastMove.xAllowedDistance, lastMove.yAllowedDistance, lastMove.zAllowedDistance, VelocityFlags.FAKED);
        }
        if (pData.isDebugActive(CheckType.MOVING)) {
            this.debug(event.getPlayer(), "Abort gliding phase.");
        }
    }

    private void handlePoseChangeEvent(Entity entity, Pose newPose) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        IPlayerData pData = DataManager.getPlayerData(player);
        if (pData.getClientVersion().isLowerThan(ClientVersion.V_1_14)) {
            return;
        }
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        if (newPose.equals((Object)Pose.SWIMMING) && !BlockProperties.isInWater(player, player.getLocation(), cc.yOnGround)) {
            pData.setIsInCrouchingPoseState(true);
            return;
        }
        if (newPose.equals((Object)Pose.SNEAKING)) {
            pData.setIsInCrouchingPoseState(true);
            return;
        }
        pData.setIsInCrouchingPoseState(false);
    }

    @Override
    public void playerJoins(Player player) {
        IPlayerData pData = DataManager.getPlayerData(player);
        CombinedData data = pData.getGenericInstance(CombinedData.class);
        CombinedConfig cc = pData.getGenericInstance(CombinedConfig.class);
        boolean debug = pData.isDebugActive(this.checkType);
        if (cc.invulnerableCheck && (cc.invulnerableTriggerAlways || cc.invulnerableTriggerFallDistance && player.getFallDistance() > 0.0f)) {
            int invulnerableTicks = ((MCAccess)this.mcAccess.getHandle()).getInvulnerableTicks(player);
            if (invulnerableTicks == Integer.MAX_VALUE) {
                if (debug) {
                    this.debug(player, "Invulnerable ticks could not be determined.");
                }
            } else {
                int ticks = cc.invulnerableInitialTicksJoin >= 0 ? cc.invulnerableInitialTicksJoin : invulnerableTicks;
                data.invulnerableTick = TickTask.getTick() + ticks;
                ((MCAccess)this.mcAccess.getHandle()).setInvulnerableTicks(player, 0);
            }
        }
        MovingConfig mCC = pData.getGenericInstance(MovingConfig.class);
        if (BridgeMisc.hasEntityChangePoseEvent()) {
            if (player.getPose().equals((Object)Pose.SWIMMING) && !BlockProperties.isInWater(player, player.getLocation(), mCC.yOnGround)) {
                pData.setIsInCrouchingPoseState(true);
            } else if (player.getPose().equals((Object)Pose.SNEAKING)) {
                pData.setIsInCrouchingPoseState(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(player);
        CombinedData data = pData.getGenericInstance(CombinedData.class);
        data.resetImprobableData();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        IPlayerData pData = DataManager.getPlayerData(player);
        CombinedData data = pData.getGenericInstance(CombinedData.class);
        data.resetImprobableData();
        pData.setSprintingState(false);
        pData.setIsInCrouchingPoseState(false);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onGameModeChange(PlayerGameModeChangeEvent event) {
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(player);
        CombinedData data = pData.getGenericInstance(CombinedData.class);
        data.resetImprobableData();
    }

    @Override
    public void playerLeaves(Player player) {
        IPlayerData pData = DataManager.getPlayerData(player);
        CombinedData data = pData.getGenericInstance(CombinedData.class);
        data.resetImprobableData();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onToggleShiftKey(PlayerToggleSneakEvent event) {
        IPlayerData pData = DataManager.getPlayerData(event.getPlayer());
        pData.setIsShiftKeyPressed(event.isSneaking());
        if (pData.getClientVersion().isAtLeast(ClientVersion.V_1_14) && BridgeMisc.hasEntityChangePoseEvent()) {
            return;
        }
        if (!event.isSneaking()) {
            pData.setIsInCrouchingPoseState(false);
            return;
        }
        if (Bridge1_13.isSwimming((LivingEntity)event.getPlayer()) || Bridge1_9.isGliding((LivingEntity)event.getPlayer()) || Bridge1_13.isRiptiding((LivingEntity)event.getPlayer())) {
            pData.setIsInCrouchingPoseState(false);
            return;
        }
        pData.setIsInCrouchingPoseState(true);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onToggleSprint(PlayerToggleSprintEvent event) {
        IPlayerData pData = DataManager.getPlayerData(event.getPlayer());
        if (!event.isSprinting()) {
            pData.setSprintingState(false);
            return;
        }
        if (pData.isInCrouchingPose()) {
            pData.setSprintingState(false);
            return;
        }
        if (BridgeMisc.isUsingItem(event.getPlayer())) {
            pData.setSprintingState(false);
            return;
        }
        if (event.getPlayer().getFoodLevel() <= 5) {
            pData.setSprintingState(false);
            return;
        }
        if (event.getPlayer().hasPotionEffect(PotionEffectType.BLINDNESS)) {
            pData.setSprintingState(false);
            return;
        }
        if (BridgeMisc.isVisuallyCrawling(event.getPlayer())) {
            pData.setSprintingState(false);
            return;
        }
        pData.setSprintingState(true);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onAttackingEntities(EntityDamageByEntityEvent event) {
        Entity attacker = event.getDamager();
        Entity damaged = event.getEntity();
        if (!(attacker instanceof Player)) {
            return;
        }
        if (!(damaged instanceof LivingEntity) || damaged.isDead() || !damaged.isValid()) {
            return;
        }
        Player player = (Player)attacker;
        IPlayerData pData = DataManager.getPlayerData(player);
        MovingData data = pData.getGenericInstance(MovingData.class);
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        ItemStack stack = Bridge1_9.getItemInMainHand(player);
        PlayerMoveInfo moveInfo = this.aux.usePlayerMoveInfo();
        Location loc = player.getLocation(this.useLoc);
        moveInfo.set(player, loc, null, cc.yOnGround);
        if (!MovingUtil.shouldCheckSurvivalFly(player, (PlayerLocation)moveInfo.from, null, data, cc, pData)) {
            this.useLoc.setWorld(null);
            this.aux.returnPlayerMoveInfo(moveInfo);
            return;
        }
        if (pData.isSprinting() || !BlockProperties.isAir(stack) && stack.getEnchantmentLevel(Enchantment.KNOCKBACK) > 0) {
            PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
            thisMove.hasAttackSlowDown = true;
            if (pData.isDebugActive(CheckType.MOVING)) {
                this.debug(player, "Set attack slow down flag in this move.");
            }
        }
        this.useLoc.setWorld(null);
        this.aux.returnPlayerMoveInfo(moveInfo);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        IPlayerData pData = DataManager.getPlayerData(player);
        CombinedConfig cc = pData.getGenericInstance(CombinedConfig.class);
        if (!cc.invulnerableCheck) {
            return;
        }
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (cc.invulnerableIgnore.contains(cause)) {
            return;
        }
        Integer modifier = cc.invulnerableModifiers.get(cause);
        if (modifier == null) {
            modifier = cc.invulnerableModifierDefault;
        }
        CombinedData data = pData.getGenericInstance(CombinedData.class);
        if (TickTask.getTick() >= data.invulnerableTick + modifier) {
            return;
        }
        event.setCancelled(true);
        this.counters.addPrimaryThread(this.idFakeInvulnerable, 1);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onFishing(PlayerFishEvent event) {
        Player player = event.getPlayer();
        if (this.munchHausen.isEnabled(player) && this.munchHausen.checkFish(player, event.getCaught(), event.getState())) {
            event.setCancelled(true);
        }
    }
}

