/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.chat;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.chat.ChatConfig;
import fr.neatmonster.nocheatplus.checks.chat.ChatData;
import fr.neatmonster.nocheatplus.checks.chat.ICaptcha;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.ColorUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import org.bukkit.entity.Player;

public class Commands
extends Check {
    public Commands() {
        super(CheckType.CHAT_COMMANDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(Player player, String message, ChatConfig cc, IPlayerData pData, ICaptcha captcha) {
        boolean captchaEnabled;
        long now = System.currentTimeMillis();
        int tick = TickTask.getTick();
        ChatData data = pData.getGenericInstance(ChatData.class);
        boolean bl = captchaEnabled = !cc.captchaSkipCommands && pData.isCheckActive(CheckType.CHAT_CAPTCHA, player);
        if (captchaEnabled) {
            ChatData chatData = data;
            synchronized (chatData) {
                if (captcha.shouldCheckCaptcha(player, cc, data, pData)) {
                    captcha.checkCaptcha(player, message, cc, data, true);
                    return true;
                }
            }
        }
        float weight = 1.0f;
        data.commandsWeights.add(now, 1.0f);
        if ((long)tick < data.commandsShortTermTick) {
            data.commandsShortTermTick = tick;
            data.commandsShortTermWeight = 1.0;
        } else if ((long)tick - data.commandsShortTermTick < (long)cc.commandsShortTermTicks) {
            if (!pData.getCurrentWorldData().shouldAdjustToLag(this.type) || TickTask.getLag(50L * ((long)tick - data.commandsShortTermTick), true) < 1.3f) {
                data.commandsShortTermWeight += 1.0;
            } else {
                data.commandsShortTermTick = tick;
                data.commandsShortTermWeight = 1.0;
            }
        } else {
            data.commandsShortTermTick = tick;
            data.commandsShortTermWeight = 1.0;
        }
        float nw = data.commandsWeights.score(1.0f);
        double violation = Math.max((double)nw - cc.commandsLevel, data.commandsShortTermWeight - cc.commandsShortTermLevel);
        if (violation > 0.0) {
            data.commandsVL += violation;
            if (captchaEnabled) {
                ChatData chatData = data;
                synchronized (chatData) {
                    captcha.sendNewCaptcha(player, cc, data);
                }
                return true;
            }
            if (this.executeActions(player, data.commandsVL, violation, cc.commandsActions).willCancel()) {
                return true;
            }
        } else if (cc.chatWarningCheck && now - data.chatWarningTime > cc.chatWarningTimeout && ((double)(100.0f * nw) / cc.commandsLevel > (double)cc.chatWarningLevel || 100.0 * data.commandsShortTermWeight / cc.commandsShortTermLevel > (double)cc.chatWarningLevel)) {
            player.sendMessage(ColorUtil.replaceColors(cc.chatWarningMessage));
            data.chatWarningTime = now;
        } else {
            data.commandsVL *= 0.99;
        }
        return false;
    }
}

