/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.chat;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.chat.Captcha;
import fr.neatmonster.nocheatplus.checks.chat.ChatConfig;
import fr.neatmonster.nocheatplus.checks.chat.ChatData;
import fr.neatmonster.nocheatplus.checks.chat.Commands;
import fr.neatmonster.nocheatplus.checks.chat.Logins;
import fr.neatmonster.nocheatplus.checks.chat.Relog;
import fr.neatmonster.nocheatplus.checks.chat.Text;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.command.CommandUtil;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.SchedulerHelper;
import fr.neatmonster.nocheatplus.components.NoCheatPlusAPI;
import fr.neatmonster.nocheatplus.components.data.ICheckData;
import fr.neatmonster.nocheatplus.components.data.IData;
import fr.neatmonster.nocheatplus.components.registry.factory.IFactoryOne;
import fr.neatmonster.nocheatplus.components.registry.feature.INotifyReload;
import fr.neatmonster.nocheatplus.components.registry.feature.JoinLeaveListener;
import fr.neatmonster.nocheatplus.components.registry.setup.config.RegisterConfigWorld;
import fr.neatmonster.nocheatplus.components.registry.setup.data.RegisterDataPlayer;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.players.PlayerFactoryArgument;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.ds.prefixtree.SimpleCharPrefixTree;
import fr.neatmonster.nocheatplus.utilities.moving.MovingUtil;
import fr.neatmonster.nocheatplus.worlds.WorldFactoryArgument;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerLoginEvent;

public class ChatListener
extends CheckListener
implements INotifyReload,
JoinLeaveListener {
    private final Captcha captcha = this.addCheck(new Captcha());
    private final Commands commands = this.addCheck(new Commands());
    private final Logins logins = this.addCheck(new Logins());
    private final Text text = this.addCheck(new Text());
    private final Relog relog = this.addCheck(new Relog());
    private final SimpleCharPrefixTree commandExclusions = new SimpleCharPrefixTree();
    private final SimpleCharPrefixTree chatCommands = new SimpleCharPrefixTree();
    private final SimpleCharPrefixTree consoleOnlyCommands = new SimpleCharPrefixTree();
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);

    public ChatListener() {
        super(CheckType.CHAT);
        ConfigFile config = ConfigManager.getConfigFile();
        this.initFilters(config);
        NoCheatPlusAPI api = NCPAPIProvider.getNoCheatPlusAPI();
        api.register(((RegisterDataPlayer)((RegisterConfigWorld)api.newRegistrationContext().registerConfigWorld(ChatConfig.class).factory((IFactoryOne)new IFactoryOne<WorldFactoryArgument, ChatConfig>(){

            @Override
            public ChatConfig getNewInstance(WorldFactoryArgument arg) {
                return new ChatConfig(arg.worldData);
            }
        })).registerConfigTypesPlayer().context().registerDataPlayer(ChatData.class).factory((IFactoryOne)new IFactoryOne<PlayerFactoryArgument, ChatData>(){

            @Override
            public ChatData getNewInstance(PlayerFactoryArgument arg) {
                return new ChatData();
            }
        })).addToGroups(CheckType.CHAT, true, new Class[]{IData.class, ICheckData.class}).context());
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        boolean alreadyCancelled = event.isCancelled();
        if (!DataManager.getPlayerData(player).isCheckActive(CheckType.CHAT, player)) {
            return;
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        ChatConfig cc = pData.getGenericInstance(ChatConfig.class);
        if (this.textChecks(player, event.getMessage(), cc, pData, false, alreadyCancelled)) {
            event.setCancelled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerLogin(PlayerLoginEvent event) {
        ChatData data;
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            return;
        }
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(player);
        if (!pData.isCheckActive(CheckType.CHAT, player)) {
            return;
        }
        ChatConfig cc = pData.getGenericInstance(ChatConfig.class);
        ChatData chatData = data = pData.getGenericInstance(ChatData.class);
        synchronized (chatData) {
            this.captcha.resetCaptcha(player, cc, data, pData);
        }
        if (this.relog.isEnabled(player, pData) && this.relog.unsafeLoginCheck(player, cc, data, pData)) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, cc.relogKickMessage);
        } else if (this.logins.isEnabled(player, pData) && this.logins.check(player, cc, data)) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, cc.loginsKickMessage);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        int index;
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(player);
        ChatConfig cc = pData.getGenericInstance(ChatConfig.class);
        String message = event.getMessage();
        String lcMessage = StringUtil.leftTrim(message).toLowerCase();
        String[] split = lcMessage.split(" ", 2);
        String alias = split[0].substring(1);
        Command command = CommandUtil.getCommand(alias);
        ArrayList<String> messageVars = new ArrayList<String>();
        messageVars.add(lcMessage);
        String checkMessage = message;
        if (command != null) {
            messageVars.add("/" + command.getLabel().toLowerCase() + (split.length > 1 ? " " + split[1] : ""));
        }
        if (alias.indexOf(":") != -1 && (index = message.indexOf(":") + 1) < message.length()) {
            checkMessage = message.substring(index);
            messageVars.add(checkMessage.toLowerCase());
        }
        if (cc.consoleOnlyCheck && this.consoleOnlyCommands.hasAnyPrefixWords(messageVars)) {
            if (command == null || command.testPermission((CommandSender)player)) {
                player.sendMessage(cc.consoleOnlyMessage);
            }
            event.setCancelled(true);
            return;
        }
        if (this.chatCommands.hasAnyPrefixWords(messageVars)) {
            if (this.textChecks(player, checkMessage, cc, pData, true, false)) {
                event.setCancelled(true);
            }
        } else if (!this.commandExclusions.hasAnyPrefixWords(messageVars)) {
            if (this.commands.isEnabled(player, pData) && this.commands.check(player, checkMessage, cc, pData, this.captcha)) {
                event.setCancelled(true);
            } else {
                MovingConfig mcc = pData.getGenericInstance(MovingConfig.class);
                if (mcc.passableUntrackedCommandCheck && mcc.passableUntrackedCommandPrefixes.hasAnyPrefix(messageVars) && this.checkUntrackedLocation(player, message, mcc, pData)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    private boolean checkUntrackedLocation(Player player, String message, MovingConfig mcc, IPlayerData pData) {
        Location newTo;
        Location loc = player.getLocation(this.useLoc);
        boolean cancel = false;
        if (MovingUtil.shouldCheckUntrackedLocation(player, loc, pData) && (newTo = MovingUtil.checkUntrackedLocation(loc)) != null) {
            if (mcc.passableUntrackedCommandTryTeleport && SchedulerHelper.teleportEntity((Entity)player, newTo, BridgeMisc.TELEPORT_CAUSE_CORRECTION_OF_POSITION)) {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.TRACE_FILE, player.getName() + " runs the command '" + message + "' at an untracked location: " + loc + " , teleport to: " + newTo);
            } else {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.TRACE_FILE, player.getName() + " runs the command '" + message + "' at an untracked location: " + loc + " , cancel the command.");
                cancel = true;
            }
        }
        this.useLoc.setWorld(null);
        return cancel;
    }

    private void initFilters(ConfigFile config) {
        CommandUtil.feedCommands(this.consoleOnlyCommands, config, "protection.commands.console-only.commands", true);
        CommandUtil.feedCommands(this.chatCommands, config, "checks.chat.commands.handle-as-chat", true);
        CommandUtil.feedCommands(this.commandExclusions, config, "checks.chat.commands.exclusions", true);
    }

    private boolean textChecks(Player player, String message, ChatConfig cc, IPlayerData pData, boolean isMainThread, boolean alreadyCancelled) {
        return this.text.isEnabled(player, pData) && this.text.check(player, message, cc, pData, this.captcha, isMainThread, alreadyCancelled);
    }

    @Override
    public void onReload() {
        ConfigFile config = ConfigManager.getConfigFile();
        this.initFilters(config);
        this.text.onReload();
        this.logins.onReload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playerJoins(Player player) {
        ChatData data;
        IPlayerData pData = DataManager.getPlayerData(player);
        ChatConfig cc = pData.getGenericInstance(ChatConfig.class);
        ChatData chatData = data = pData.getGenericInstance(ChatData.class);
        synchronized (chatData) {
            if (this.captcha.isEnabled(player, pData) && this.captcha.shouldCheckCaptcha(player, cc, data, pData)) {
                this.captcha.sendNewCaptcha(player, cc, data);
            }
        }
    }

    @Override
    public void playerLeaves(Player player) {
    }
}

