/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.chat;

import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.access.ACheckConfig;
import fr.neatmonster.nocheatplus.checks.chat.analysis.engine.EnginePlayerConfig;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.permissions.RegisteredPermission;
import fr.neatmonster.nocheatplus.utilities.ColorUtil;
import fr.neatmonster.nocheatplus.worlds.IWorldData;

public class ChatConfig
extends ACheckConfig {
    private static final RegisteredPermission[] preferKeepUpdatedPermissions = new RegisteredPermission[]{Permissions.CHAT_TEXT, Permissions.CHAT_CAPTCHA};
    public final boolean captchaSkipCommands;
    public final String captchaCharacters;
    public final int captchaLength;
    public final String captchaQuestion;
    public final String captchaSuccess;
    public final int captchaTries;
    public final ActionList captchaActions;
    public final double commandsLevel;
    public final int commandsShortTermTicks;
    public final double commandsShortTermLevel;
    public final ActionList commandsActions;
    public final boolean textGlobalCheck;
    public final boolean textPlayerCheck;
    public final EnginePlayerConfig textEnginePlayerConfig;
    public final float textFreqNormFactor;
    public final float textFreqNormWeight;
    public final float textFreqNormMin;
    public final double textFreqNormLevel;
    public final ActionList textFreqNormActions;
    public final float textFreqShortTermFactor;
    public final float textFreqShortTermWeight;
    public final float textFreqShortTermLevel;
    public final float textFreqShortTermMin;
    public final ActionList textFreqShortTermActions;
    public final float textMessageLetterCount;
    public final float textMessageUpperCase;
    public final float textMessagePartition;
    public final float textMsgRepeatCancel;
    public final float textMsgAfterJoin;
    public final float textMsgRepeatSelf;
    public final float textMsgRepeatGlobal;
    public final float textMsgNoMoving;
    public final float textMessageLengthAv;
    public final float textMessageLengthMsg;
    public final float textMessageNoLetter;
    public final float textGlobalWeight;
    public final float textPlayerWeight;
    public final boolean textEngineMaximum;
    public final boolean textAllowVLReset;
    public final boolean textDebug;
    public final boolean chatWarningCheck;
    public final float chatWarningLevel;
    public final String chatWarningMessage;
    public final long chatWarningTimeout;
    public final boolean loginsPerWorldCount;
    public final int loginsSeconds;
    public final int loginsLimit;
    public final String loginsKickMessage;
    public final long loginsStartupDelay;
    public final boolean consoleOnlyCheck;
    public final String consoleOnlyMessage;
    public final String relogKickMessage;
    public final long relogTimeout;
    public final String relogWarningMessage;
    public final int relogWarningNumber;
    public final long relogWarningTimeout;
    public final ActionList relogActions;

    public static RegisteredPermission[] getPreferKeepUpdatedPermissions() {
        return preferKeepUpdatedPermissions;
    }

    public ChatConfig(IWorldData worldData) {
        super(worldData);
        ConfigFile config = worldData.getRawConfiguration();
        this.captchaSkipCommands = config.getBoolean("checks.chat.captcha.skip.commands");
        this.captchaCharacters = config.getString("checks.chat.captcha.characters");
        this.captchaLength = config.getInt("checks.chat.captcha.length");
        this.captchaQuestion = config.getString("checks.chat.captcha.question");
        this.captchaSuccess = config.getString("checks.chat.captcha.success");
        this.captchaTries = config.getInt("checks.chat.captcha.tries");
        this.captchaActions = (ActionList)config.getOptimizedActionList("checks.chat.captcha.actions", Permissions.CHAT_CAPTCHA);
        this.commandsLevel = config.getDouble("checks.chat.commands.level");
        this.commandsShortTermTicks = config.getInt("checks.chat.commands.short-term.ticks");
        this.commandsShortTermLevel = config.getDouble("checks.chat.commands.short-term.level");
        this.commandsActions = (ActionList)config.getOptimizedActionList("checks.chat.commands.actions", Permissions.CHAT_COMMANDS);
        this.textGlobalCheck = config.getBoolean("checks.chat.text.global.active", true);
        this.textPlayerCheck = config.getBoolean("checks.chat.text.player.active", true);
        this.textEnginePlayerConfig = new EnginePlayerConfig(config);
        this.textFreqNormMin = (float)config.getDouble("checks.chat.text.frequency.normal.minimum");
        this.textFreqNormFactor = (float)config.getDouble("checks.chat.text.frequency.normal.factor");
        this.textFreqNormWeight = (float)config.getDouble("checks.chat.text.frequency.normal.weight");
        this.textFreqShortTermFactor = (float)config.getDouble("checks.chat.text.frequency.short-term.factor");
        this.textFreqShortTermWeight = (float)config.getDouble("checks.chat.text.frequency.short-term.weight");
        this.textFreqShortTermLevel = (float)config.getDouble("checks.chat.text.frequency.short-term.level");
        this.textFreqShortTermMin = (float)config.getDouble("checks.chat.text.frequency.short-term.minimum");
        this.textFreqShortTermActions = (ActionList)config.getOptimizedActionList("checks.chat.text.frequency.short-term.actions", Permissions.CHAT_TEXT);
        this.textMessageLetterCount = (float)config.getDouble("checks.chat.text.message.letter-count");
        this.textMessagePartition = (float)config.getDouble("checks.chat.text.message.partition");
        this.textMessageUpperCase = (float)config.getDouble("checks.chat.text.message.uppercase");
        this.textMsgRepeatCancel = (float)config.getDouble("checks.chat.text.message.repeat-violation");
        this.textMsgAfterJoin = (float)config.getDouble("checks.chat.text.message.after-join");
        this.textMsgRepeatSelf = (float)config.getDouble("checks.chat.text.message.repeat-self");
        this.textMsgRepeatGlobal = (float)config.getDouble("checks.chat.text.message.repeat-global");
        this.textMsgNoMoving = (float)config.getDouble("checks.chat.text.message.nomoving");
        this.textMessageLengthAv = (float)config.getDouble("checks.chat.text.message.words.length-av");
        this.textMessageLengthMsg = (float)config.getDouble("checks.chat.text.message.words.length-msg");
        this.textMessageNoLetter = (float)config.getDouble("checks.chat.text.message.words.no-letter");
        this.textGlobalWeight = (float)config.getDouble("checks.chat.text.global.weight", 1.0);
        this.textPlayerWeight = (float)config.getDouble("checks.chat.text.player.weight", 1.0);
        this.textFreqNormLevel = config.getDouble("checks.chat.text.frequency.normal.level");
        this.textEngineMaximum = config.getBoolean("checks.chat.text.maximum", true);
        this.textDebug = config.getBoolean("checks.chat.text.debug", false);
        this.textFreqNormActions = (ActionList)config.getOptimizedActionList("checks.chat.text.frequency.normal.actions", Permissions.CHAT_TEXT);
        this.textAllowVLReset = config.getBoolean("checks.chat.text.allow-VL-reset");
        this.chatWarningCheck = config.getBoolean("checks.chat.warning.active");
        this.chatWarningLevel = (float)config.getDouble("checks.chat.warning.level");
        this.chatWarningMessage = config.getString("checks.chat.warning.message");
        this.chatWarningTimeout = config.getLong("checks.chat.warning.timeout") * 1000L;
        this.loginsPerWorldCount = config.getBoolean("checks.chat.logins.per-world-count");
        this.loginsSeconds = config.getInt("checks.chat.logins.seconds");
        this.loginsLimit = config.getInt("checks.chat.logins.limit");
        this.loginsKickMessage = config.getString("checks.chat.logins.kick-message");
        this.loginsStartupDelay = config.getInt("checks.chat.logins.startup-delay") * 1000;
        this.relogKickMessage = config.getString("checks.chat.relog.kick-message");
        this.relogTimeout = config.getLong("checks.chat.relog.timeout");
        this.relogWarningMessage = config.getString("checks.chat.relog.warning.message");
        this.relogWarningNumber = config.getInt("checks.chat.relog.warning.number");
        this.relogWarningTimeout = config.getLong("checks.chat.relog.warning.timeout");
        this.relogActions = (ActionList)config.getOptimizedActionList("checks.chat.relog.actions", Permissions.CHAT_RELOG);
        this.consoleOnlyCheck = config.getBoolean("protection.commands.console-only.active");
        this.consoleOnlyMessage = ColorUtil.replaceColors(config.getString("protection.commands.console-only.message"));
    }
}

