/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockplace;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceConfig;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceData;
import fr.neatmonster.nocheatplus.components.registry.feature.TickListener;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class Scaffold
extends Check {
    static final double MAX_ANGLE = Math.toRadians(90.0);
    public List<String> tags = new LinkedList<String>();

    public Scaffold() {
        super(CheckType.BLOCKPLACE_SCAFFOLD);
    }

    public boolean check(final Player player, BlockFace placedFace, final IPlayerData pData, final BlockPlaceData data, final BlockPlaceConfig cc, boolean isCancelled, double yDistance, int jumpPhase) {
        boolean cancel = false;
        if (player.isSneaking()) {
            data.sneakTime = data.currentTick;
        }
        data.currentTick = TickTask.getTick();
        if (cc.scaffoldAngle) {
            Vector placedVector = new Vector(placedFace.getModX(), placedFace.getModY(), placedFace.getModZ());
            double placedAngle = TrigUtil.angle(player.getLocation().getDirection(), placedVector);
            if (placedAngle > MAX_ANGLE) {
                cancel = this.violation("Angle", Math.min(Math.max(1, (int)(placedAngle - MAX_ANGLE) * 10), 10), player, data, pData);
            }
        }
        if (cc.scaffoldTime && !isCancelled && Math.abs(player.getLocation().getPitch()) > 70.0f && data.currentTick - data.sneakTime > 3L && !player.hasPotionEffect(PotionEffectType.SPEED)) {
            data.placeTick.add(data.currentTick);
            if (data.placeTick.size() > 2) {
                long sum = 0L;
                long lastTick = 0L;
                for (int i = 0; i < data.placeTick.size(); ++i) {
                    long tick = data.placeTick.get(i);
                    if (lastTick != 0L) {
                        sum += tick - lastTick;
                    }
                    lastTick = tick;
                }
                double avg = sum / (long)data.placeTick.size();
                if (avg < (double)cc.scaffoldTimeAvg) {
                    cancel = this.violation("Time", Math.min(cc.scaffoldTimeAvg - (int)avg, 5), player, data, pData);
                    if (data.placeTick.size() > 20) {
                        data.placeTick.clear();
                    }
                } else {
                    data.placeTick.clear();
                }
            }
        }
        long diff = data.currentTick - data.sprintTime;
        if (cc.scaffoldSprint && Math.abs(player.getLocation().getPitch()) > 70.0f && diff < 8L && yDistance < 0.1 && jumpPhase < 4) {
            cancel = this.violation("Sprint", 1, player, data, pData);
        }
        if (cc.scaffoldRotate) {
            data.lastYaw = player.getLocation().getYaw();
            TickListener yawTick = new TickListener(){

                @Override
                public void onTick(int tick, long timeLast) {
                    if ((long)TickTask.getTick() != data.currentTick) {
                        float diff = Math.abs(data.lastYaw - player.getLocation().getYaw());
                        if (diff > (float)cc.scaffoldRotateDiff) {
                            data.cancelNextPlace = Scaffold.this.violation("Rotate", Math.min((int)(diff - (float)cc.scaffoldRotateDiff) / 10, 5), player, data, pData);
                            Scaffold.this.tags.clear();
                        }
                        TickTask.removeTickListener(this);
                    }
                }
            };
            TickTask.addTickListener(yawTick);
        }
        if (cc.scaffoldToolSwitch) {
            data.lastSlot = player.getInventory().getHeldItemSlot();
            TickListener toolSwitchTick = new TickListener(){

                @Override
                public void onTick(int tick, long timeLast) {
                    if (data.currentTick != (long)TickTask.getTick()) {
                        if (data.lastSlot != player.getInventory().getHeldItemSlot()) {
                            data.cancelNextPlace = Scaffold.this.violation("ToolSwitch", 1, player, data, pData);
                            Scaffold.this.tags.clear();
                        }
                        TickTask.removeTickListener(this);
                    }
                }
            };
            TickTask.addTickListener(toolSwitchTick);
        }
        this.tags.clear();
        return cancel;
    }

    private boolean violation(String addTags, int weight, Player player, BlockPlaceData data, IPlayerData pData) {
        ViolationData vd = new ViolationData(this, player, data.scaffoldVL, weight, pData.getGenericInstance(BlockPlaceConfig.class).scaffoldActions);
        this.tags.add(addTags);
        if (vd.needsParameters()) {
            vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
        }
        data.scaffoldVL += (double)weight;
        return this.executeActions(vd).willCancel();
    }
}

