/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockplace;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceConfig;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceData;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class Reach
extends Check {
    public static final double CREATIVE_DISTANCE = 5.6;
    public static final double SURVIVAL_DISTANCE = 5.2;
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);

    public Reach() {
        super(CheckType.BLOCKPLACE_REACH);
    }

    public boolean check(Player player, double eyeHeight, Block block, BlockPlaceData data, BlockPlaceConfig cc) {
        boolean cancel = false;
        double distanceLimit = player.getGameMode() == GameMode.CREATIVE ? 5.6 : 5.2;
        Location eyeLoc = player.getLocation(this.useLoc);
        eyeLoc.setY(eyeLoc.getY() + eyeHeight);
        double distance = TrigUtil.distance(eyeLoc, block) - distanceLimit;
        if (distance > distanceLimit) {
            data.reachVL += distance - distanceLimit;
            ViolationData vd = new ViolationData(this, player, data.reachVL, distance, cc.reachActions);
            vd.setParameter(ParameterName.REACH_DISTANCE, StringUtil.fdec3.format(distance));
            cancel = this.executeActions(vd).willCancel();
        } else {
            data.reachVL *= 0.9;
        }
        this.useLoc.setWorld(null);
        return cancel;
    }
}

