/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockplace;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractData;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractListener;
import fr.neatmonster.nocheatplus.checks.blockplace.Against;
import fr.neatmonster.nocheatplus.checks.blockplace.AutoSign;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceConfig;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceData;
import fr.neatmonster.nocheatplus.checks.blockplace.Direction;
import fr.neatmonster.nocheatplus.checks.blockplace.FastPlace;
import fr.neatmonster.nocheatplus.checks.blockplace.NoSwing;
import fr.neatmonster.nocheatplus.checks.blockplace.Reach;
import fr.neatmonster.nocheatplus.checks.blockplace.Scaffold;
import fr.neatmonster.nocheatplus.checks.blockplace.Speed;
import fr.neatmonster.nocheatplus.checks.combined.Combined;
import fr.neatmonster.nocheatplus.checks.combined.CombinedConfig;
import fr.neatmonster.nocheatplus.checks.combined.Improbable;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.net.FlyingQueueHandle;
import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeEntityType;
import fr.neatmonster.nocheatplus.components.NoCheatPlusAPI;
import fr.neatmonster.nocheatplus.components.data.ICheckData;
import fr.neatmonster.nocheatplus.components.data.IData;
import fr.neatmonster.nocheatplus.components.registry.factory.IFactoryOne;
import fr.neatmonster.nocheatplus.components.registry.setup.config.RegisterConfigWorld;
import fr.neatmonster.nocheatplus.components.registry.setup.data.RegisterDataPlayer;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.players.PlayerFactoryArgument;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.ds.map.CoordHash;
import fr.neatmonster.nocheatplus.utilities.map.BlockFlags;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.moving.MovingUtil;
import fr.neatmonster.nocheatplus.worlds.WorldFactoryArgument;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerSignOpenEvent;
import org.bukkit.inventory.ItemStack;

public class BlockPlaceListener
extends CheckListener {
    private final Against against = this.addCheck(new Against());
    private final AutoSign autoSign = this.addCheck(new AutoSign());
    private final Direction direction = this.addCheck(new Direction());
    private final FastPlace fastPlace = this.addCheck(new FastPlace());
    private final NoSwing noSwing = this.addCheck(new NoSwing());
    private final Reach reach = this.addCheck(new Reach());
    private final Scaffold scaffold = this.addCheck(new Scaffold());
    private final Speed speed = this.addCheck(new Speed());
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final Location useLoc2 = new Location(null, 0.0, 0.0, 0.0);
    private final Counters counters = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class);
    private final int idBoatsOnWaterOnly = this.counters.registerKey("boatsonwateronly");
    private final int idEnderPearl = this.counters.registerKey("throwenderpearl");
    private final Class<?> blockMultiPlaceEvent = ReflectionUtil.getClass("org.bukkit.event.block.BlockMultiPlaceEvent");
    private final boolean hasPlayerSignOpenEvent = ReflectionUtil.getClass("org.bukkit.event.player.PlayerSignOpenEvent") != null;
    private final boolean hasGetReplacedState = ReflectionUtil.getMethodNoArgs(BlockPlaceEvent.class, "getReplacedState", BlockState.class) != null;
    public final List<BlockFace> faces = Arrays.asList(BlockFace.SOUTH, BlockFace.WEST, BlockFace.EAST, BlockFace.NORTH);

    public BlockPlaceListener() {
        super(CheckType.BLOCKPLACE);
        NoCheatPlusAPI api = NCPAPIProvider.getNoCheatPlusAPI();
        if (this.hasPlayerSignOpenEvent) {
            this.queuedComponents.add(new Listener(){

                @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
                public void onOpeningSign1_20(PlayerSignOpenEvent event) {
                    BlockPlaceListener.this.handleSignOpenEvent(event.getPlayer(), event.getCause());
                }
            });
        }
        api.register(((RegisterDataPlayer)((RegisterConfigWorld)api.newRegistrationContext().registerConfigWorld(BlockPlaceConfig.class).factory((IFactoryOne)new IFactoryOne<WorldFactoryArgument, BlockPlaceConfig>(){

            @Override
            public BlockPlaceConfig getNewInstance(WorldFactoryArgument arg) {
                return new BlockPlaceConfig(arg.worldData);
            }
        })).registerConfigTypesPlayer().context().registerDataPlayer(BlockPlaceData.class).factory((IFactoryOne)new IFactoryOne<PlayerFactoryArgument, BlockPlaceData>(){

            @Override
            public BlockPlaceData getNewInstance(PlayerFactoryArgument arg) {
                return new BlockPlaceData();
            }
        })).addToGroups(CheckType.BLOCKPLACE, true, new Class[]{IData.class, ICheckData.class}).context());
    }

    public static int getBlockPlaceHash(Block block, Material mat) {
        int hash = CoordHash.hashCode3DPrimes(block.getX(), block.getY(), block.getZ());
        if (mat != null) {
            hash |= mat.name().hashCode();
        }
        return hash |= block.getWorld().getName().hashCode();
    }

    private void handleSignOpenEvent(Player player, PlayerSignOpenEvent.Cause cause) {
        if (cause != PlayerSignOpenEvent.Cause.INTERACT) {
            return;
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        BlockPlaceData data = pData.getGenericInstance(BlockPlaceData.class);
        data.autoSignPlacedHash = 0L;
        data.signOpenTime = System.currentTimeMillis();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onBlockPlace(BlockPlaceEvent event) {
        boolean shouldSkipSome;
        if (!DataManager.getPlayerData(event.getPlayer()).isCheckActive(CheckType.BLOCKPLACE, event.getPlayer())) {
            return;
        }
        Block block = event.getBlockPlaced();
        Block blockAgainst = event.getBlockAgainst();
        if (block == null || blockAgainst == null) {
            return;
        }
        Player player = event.getPlayer();
        Material placedMat = this.hasGetReplacedState ? event.getBlockPlaced().getType() : (Bridge1_9.hasGetItemInOffHand() ? (BlockProperties.isAir(event.getItemInHand()) ? Material.AIR : event.getItemInHand().getType()) : Bridge1_9.getItemInMainHand(player).getType());
        boolean cancelled = false;
        int skippedRedundantChecks = 0;
        IPlayerData pData = DataManager.getPlayerData(player);
        BlockPlaceData data = pData.getGenericInstance(BlockPlaceData.class);
        BlockPlaceConfig cc = pData.getGenericInstance(BlockPlaceConfig.class);
        BlockInteractData bdata = pData.getGenericInstance(BlockInteractData.class);
        boolean isInteractBlock = !bdata.getLastIsCancelled() && bdata.matchesLastBlock(TickTask.getTick(), blockAgainst);
        BlockFace placedFace = event.getBlock().getFace(blockAgainst);
        Block blockPlaced = event.getBlockPlaced();
        if (this.blockMultiPlaceEvent != null && event.getClass() == this.blockMultiPlaceEvent) {
            if (placedMat == Material.BEDROCK || Bridge1_9.hasEndCrystalItem() && placedMat == Bridge1_9.END_CRYSTAL_ITEM) {
                shouldSkipSome = true;
            } else {
                if (pData.isDebugActive(CheckType.BLOCKPLACE)) {
                    this.debug(player, "Block place " + event.getClass().getName() + " " + placedMat);
                }
                shouldSkipSome = false;
            }
        } else {
            shouldSkipSome = BlockProperties.isScaffolding(placedMat);
        }
        if (MaterialUtil.isAnySign(placedMat)) {
            data.signOpenTime = System.currentTimeMillis();
            data.autoSignPlacedHash = BlockPlaceListener.getBlockPlaceHash(block, placedMat);
            if (pData.isDebugActive(CheckType.BLOCKPLACE_AUTOSIGN)) {
                this.debug(player, "Register time and hash for this placed sign: h= " + data.autoSignPlacedHash + " / t= " + data.signOpenTime);
            }
        }
        if (pData.isPlayerSetBackScheduled()) {
            cancelled = true;
            if (pData.isDebugActive(CheckType.BLOCKPLACE)) {
                this.debug(player, "Prevent block place due to a scheduled set back.");
            }
        }
        if (!cancelled && this.against.isEnabled(player, pData) && !BlockProperties.isScaffolding(placedMat) && this.against.check(player, block, placedMat, blockAgainst, isInteractBlock, data, cc, pData)) {
            cancelled = true;
        }
        if (!cancelled && !cc.noSwingExceptions.contains(placedMat) && this.noSwing.isEnabled(player, pData) && this.noSwing.check(player, data, cc)) {
            cancelled = true;
        }
        if (!cancelled && this.fastPlace.isEnabled(player, pData)) {
            if (this.fastPlace.check(player, block, TickTask.getTick(), data, cc, pData)) {
                cancelled = true;
            }
            if (cc.fastPlaceImprobableWeight > 0.0f) {
                if (data.fastPlaceVL > 20.0) {
                    if (!cc.fastPlaceImprobableFeedOnly) {
                        if (Improbable.check(player, cc.fastPlaceImprobableWeight, System.currentTimeMillis(), "blockplace.fastplace", pData)) {
                            cancelled = true;
                        }
                    } else {
                        Improbable.feed(player, cc.fastPlaceImprobableWeight, System.currentTimeMillis());
                    }
                } else {
                    Improbable.feed(player, cc.fastPlaceImprobableWeight, System.currentTimeMillis());
                }
            }
        }
        if (this.scaffold.isEnabled(player, pData) && placedFace != null) {
            PlayerMoveData thisMove = pData.getGenericInstance(MovingData.class).playerMoves.getCurrentMove();
            if (this.faces.contains(placedFace) && thisMove.from.getY() - (double)blockPlaced.getY() < 2.0 && thisMove.from.getY() - (double)blockPlaced.getY() >= 1.0 && blockPlaced.getType().isSolid() && TrigUtil.distance(player.getLocation(), blockPlaced.getLocation()) < 2.0) {
                if (Combined.checkYawRate(player, thisMove.from.getYaw(), System.currentTimeMillis(), thisMove.from.getWorldName(), pData)) {
                    cancelled = true;
                }
                if (data.cancelNextPlace && Math.abs(data.currentTick - (long)TickTask.getTick()) < 10L || this.scaffold.check(player, placedFace, pData, data, cc, event.isCancelled(), thisMove.yDistance, pData.getGenericInstance(MovingData.class).sfJumpPhase)) {
                    cancelled = true;
                } else if (cc.scaffoldImprobableWeight > 0.0f) {
                    if (cc.scaffoldImprobableFeedOnly) {
                        Improbable.feed(player, cc.scaffoldImprobableWeight, System.currentTimeMillis());
                    } else if (Improbable.check(player, cc.scaffoldImprobableWeight, System.currentTimeMillis(), "blockplace.scaffold", pData)) {
                        cancelled = true;
                    }
                }
                if (!cancelled) {
                    data.scaffoldVL *= 0.98;
                }
            }
            data.cancelNextPlace = false;
        }
        FlyingQueueHandle flyingHandle = new FlyingQueueHandle(pData);
        boolean reachCheck = pData.isCheckActive(CheckType.BLOCKPLACE_REACH, player);
        boolean directionCheck = pData.isCheckActive(CheckType.BLOCKPLACE_DIRECTION, player);
        if (reachCheck || directionCheck) {
            Location loc = player.getLocation(this.useLoc);
            double eyeHeight = MovingUtil.getEyeHeight(player);
            if (!cancelled && !shouldSkipSome) {
                if (isInteractBlock && bdata.isPassedCheck(CheckType.BLOCKINTERACT_REACH)) {
                    ++skippedRedundantChecks;
                } else if (reachCheck && this.reach.check(player, eyeHeight, block, data, cc)) {
                    cancelled = true;
                }
            }
            if (!cancelled && !shouldSkipSome) {
                if (isInteractBlock && bdata.isPassedCheck(CheckType.BLOCKINTERACT_DIRECTION)) {
                    ++skippedRedundantChecks;
                } else if (directionCheck && blockAgainst.getType() != Material.LADDER && !BlockProperties.isCarpet(blockAgainst.getType()) && this.direction.check(player, loc, eyeHeight, block, null, flyingHandle, data, cc, pData)) {
                    cancelled = true;
                }
            }
            this.useLoc.setWorld(null);
        }
        if (cancelled) {
            event.setCancelled(true);
            pData.requestUpdateInventory();
        }
        if (pData.isDebugActive(CheckType.BLOCKPLACE)) {
            this.debugBlockPlace(player, placedMat, block, blockAgainst, skippedRedundantChecks, flyingHandle, pData);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        if (!DataManager.getPlayerData(event.getPlayer()).isCheckActive(CheckType.BLOCKPLACE, event.getPlayer())) {
            return;
        }
        if (event.getClass() != SignChangeEvent.class) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        String[] lines = event.getLines();
        if (block == null || lines == null || player == null) {
            return;
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        BlockPlaceData data = pData.getGenericInstance(BlockPlaceData.class);
        if (this.autoSign.isEnabled(player, pData) && this.autoSign.check(player, block, lines, pData)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerAnimation(PlayerAnimationEvent event) {
        BlockPlaceData data = DataManager.getGenericInstance(event.getPlayer(), BlockPlaceData.class);
        data.noSwingCount = Math.max(data.noSwingCount - 1, 0);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!DataManager.getPlayerData(event.getPlayer()).isCheckActive(CheckType.BLOCKPLACE, event.getPlayer())) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack stack = Bridge1_9.getUsedItem(player, event);
        if (stack == null) {
            return;
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        BlockPlaceConfig cc = pData.getGenericInstance(BlockPlaceConfig.class);
        Material type = stack.getType();
        if (MaterialUtil.isBoat(type)) {
            if (cc.boatsOnWaterOnly) {
                this.denyOrAllowBoatPlacement(player, event, pData);
            }
        } else if (MaterialUtil.isSpawnEgg(type) && this.speed.isEnabled(player, pData) && this.speed.check(player, cc, pData)) {
            event.setCancelled(true);
        }
    }

    private void denyOrAllowBoatPlacement(Player player, PlayerInteractEvent event, IPlayerData pData) {
        Block block = event.getClickedBlock();
        Material mat = block.getType();
        if (BlockProperties.isWater(mat)) {
            return;
        }
        BlockFace blockFace = event.getBlockFace();
        Block relBlock = block.getRelative(blockFace);
        Material relMat = relBlock.getType();
        if (BlockProperties.isWater(relMat)) {
            return;
        }
        if (!pData.hasPermission(Permissions.BLOCKPLACE_BOATSONWATERONLY, player)) {
            Event.Result previousUseBlock = event.useInteractedBlock();
            event.setCancelled(true);
            event.setUseItemInHand(Event.Result.DENY);
            event.setUseInteractedBlock(previousUseBlock == Event.Result.DEFAULT ? Event.Result.ALLOW : previousUseBlock);
            this.counters.addPrimaryThread(this.idBoatsOnWaterOnly, 1);
            pData.requestUpdateInventory();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        Projectile projectile = event.getEntity();
        Player player = BridgeMisc.getShooterPlayer(projectile);
        if (player == null) {
            return;
        }
        if (!DataManager.getPlayerData(player).isCheckActive(CheckType.BLOCKPLACE, player)) {
            return;
        }
        if (MovingUtil.hasScheduledPlayerSetBack(player)) {
            event.setCancelled(true);
            return;
        }
        EntityType type = event.getEntityType();
        if (!BridgeEntityType.PROJECTILE_CHECK_LIST.contains(type)) {
            return;
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        BlockPlaceConfig cc = pData.getGenericInstance(BlockPlaceConfig.class);
        boolean cancel = false;
        if (this.speed.isEnabled(player, pData)) {
            long now = System.currentTimeMillis();
            Location loc = player.getLocation(this.useLoc2);
            if (Combined.checkYawRate(player, loc.getYaw(), now, loc.getWorld().getName(), pData)) {
                cancel = true;
            }
            if (this.speed.check(player, cc, pData)) {
                cancel = true;
            } else if (cc.speedImprobableWeight > 0.0f) {
                if (cc.speedImprobableFeedOnly) {
                    Improbable.feed(player, cc.speedImprobableWeight, now);
                } else if (Improbable.check(player, cc.speedImprobableWeight, now, "blockplace.speed", pData)) {
                    cancel = true;
                }
            }
        }
        if (!cancel && type == EntityType.ENDER_PEARL && pData.getGenericInstance(CombinedConfig.class).enderPearlCheck) {
            if (!BlockProperties.isPassable(projectile.getLocation(this.useLoc2))) {
                cancel = true;
            } else if (!BlockProperties.isPassable(player.getEyeLocation(), projectile.getLocation(this.useLoc2))) {
                cancel = true;
            } else {
                Material mat = player.getLocation(this.useLoc2).getBlock().getType();
                long flags = BlockFlags.F_CLIMBABLE | BlockFlags.F_LIQUID | BlockFlags.F_IGN_PASSABLE;
                if (!(BlockProperties.isAir(mat) || (BlockFlags.getBlockFlags(mat) & flags) != 0L || ((MCAccess)this.mcAccess.getHandle()).hasGravity(mat) || BlockProperties.isPassable(player.getLocation(), projectile.getLocation()) || BlockProperties.isOnGroundOrResetCond(player, player.getLocation(), pData.getGenericInstance(MovingConfig.class).yOnGround))) {
                    cancel = true;
                }
            }
            if (cancel) {
                this.counters.addPrimaryThread(this.idEnderPearl, 1);
            }
        }
        if (cancel) {
            event.setCancelled(true);
        }
        this.useLoc2.setWorld(null);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(player);
        BlockPlaceData data = pData.getGenericInstance(BlockPlaceData.class);
        if (!pData.isCheckActive(CheckType.BLOCKPLACE, player)) {
            return;
        }
        if (player.isSprinting()) {
            data.sprintTime = TickTask.getTick();
        } else if (player.isSneaking()) {
            data.sneakTime = TickTask.getTick();
        }
    }

    private void debugBlockPlace(Player player, Material placedMat, Block block, Block blockAgainst, int skippedRedundantChecks, FlyingQueueHandle flyingHandle, IPlayerData pData) {
        int flyingIndex;
        DataPacketFlying packet;
        this.debug(player, "Block place(" + placedMat + "): " + block.getX() + ", " + block.getY() + ", " + block.getZ());
        BlockInteractListener.debugBlockVSBlockInteract(player, this.checkType, blockAgainst, "onBlockPlace(blockAgainst)", Action.RIGHT_CLICK_BLOCK, pData);
        if (skippedRedundantChecks > 0) {
            this.debug(player, "Skipped redundant checks: " + skippedRedundantChecks);
        }
        if (flyingHandle != null && flyingHandle.isFlyingQueueFetched() && (packet = flyingHandle.getIfFetched(flyingIndex = flyingHandle.getFirstIndexWithContentIfFetched())) != null) {
            this.debug(player, "Flying packet queue used at index " + flyingIndex + ": pitch=" + packet.getPitch() + ",yaw=" + packet.getYaw());
            return;
        }
    }
}

