/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockplace;

import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.access.ACheckConfig;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.worlds.IWorldData;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;

public class BlockPlaceConfig
extends ACheckConfig {
    public final ActionList againstActions;
    public final boolean autoSignSkipEmpty;
    public final ActionList autoSignActions;
    public final ActionList directionActions;
    public final int fastPlaceLimit;
    public final int fastPlaceShortTermTicks;
    public final int fastPlaceShortTermLimit;
    public final boolean fastPlaceImprobableFeedOnly;
    public final float fastPlaceImprobableWeight;
    public final ActionList fastPlaceActions;
    public final Set<Material> noSwingExceptions = new HashSet<Material>();
    public final ActionList noSwingActions;
    public final ActionList reachActions;
    public final ActionList scaffoldActions;
    public final boolean scaffoldAngle;
    public final boolean scaffoldTime;
    public final int scaffoldTimeAvg;
    public final boolean scaffoldSprint;
    public final boolean scaffoldRotate;
    public final int scaffoldRotateDiff;
    public final boolean scaffoldToolSwitch;
    public final boolean scaffoldImprobableFeedOnly;
    public final float scaffoldImprobableWeight;
    public final long speedInterval;
    public final boolean speedImprobableFeedOnly;
    public final float speedImprobableWeight;
    public final ActionList speedActions;
    public final boolean boatsOnWaterOnly;

    public BlockPlaceConfig(IWorldData worldData) {
        super(worldData);
        ConfigFile config = worldData.getRawConfiguration();
        this.againstActions = (ActionList)config.getOptimizedActionList("checks.blockplace.against.actions", Permissions.BLOCKPLACE_AGAINST);
        this.autoSignSkipEmpty = config.getBoolean("checks.blockplace.autosign.skip-empty");
        this.autoSignActions = (ActionList)config.getOptimizedActionList("checks.blockplace.autosign.actions", Permissions.BLOCKPLACE_AUTOSIGN);
        this.directionActions = (ActionList)config.getOptimizedActionList("checks.blockplace.direction.actions", Permissions.BLOCKPLACE_DIRECTION);
        this.fastPlaceLimit = config.getInt("checks.blockplace.fastplace.limit");
        this.fastPlaceShortTermTicks = config.getInt("checks.blockplace.fastplace.short-term.ticks");
        this.fastPlaceShortTermLimit = config.getInt("checks.blockplace.fastplace.short-term.limit");
        this.fastPlaceImprobableFeedOnly = config.getBoolean("checks.blockplace.fastplace.improbable.feed-only");
        this.fastPlaceImprobableWeight = (float)config.getDouble("checks.blockplace.fastplace.improbable.weight");
        this.fastPlaceActions = (ActionList)config.getOptimizedActionList("checks.blockplace.fastplace.actions", Permissions.BLOCKPLACE_FASTPLACE);
        config.readMaterialFromList("checks.blockplace.noswing.exceptions", this.noSwingExceptions);
        this.noSwingActions = (ActionList)config.getOptimizedActionList("checks.blockplace.noswing.actions", Permissions.BLOCKPLACE_NOSWING);
        this.reachActions = (ActionList)config.getOptimizedActionList("checks.blockplace.reach.actions", Permissions.BLOCKPLACE_REACH);
        this.scaffoldAngle = config.getBoolean("checks.blockplace.scaffold.angle");
        this.scaffoldTime = config.getBoolean("checks.blockplace.scaffold.time.active");
        this.scaffoldTimeAvg = config.getInt("checks.blockplace.scaffold.time.average");
        this.scaffoldSprint = config.getBoolean("checks.blockplace.scaffold.sprint");
        this.scaffoldRotate = config.getBoolean("checks.blockplace.scaffold.rotate.active");
        this.scaffoldRotateDiff = config.getInt("checks.blockplace.scaffold.rotate.difference");
        this.scaffoldToolSwitch = config.getBoolean("checks.blockplace.scaffold.tool-switch");
        this.scaffoldImprobableFeedOnly = config.getBoolean("checks.blockplace.scaffold.improbable.feed-only");
        this.scaffoldImprobableWeight = (float)config.getDouble("checks.blockplace.scaffold.improbable.weight");
        this.scaffoldActions = (ActionList)config.getOptimizedActionList("checks.blockplace.scaffold.actions", Permissions.BLOCKPLACE_SCAFFOLD);
        this.speedInterval = config.getLong("checks.blockplace.speed.interval");
        this.speedImprobableFeedOnly = config.getBoolean("checks.blockplace.speed.improbable.feed-only");
        this.speedImprobableWeight = (float)config.getDouble("checks.blockplace.speed.improbable.weight");
        this.speedActions = (ActionList)config.getOptimizedActionList("checks.blockplace.speed.actions", Permissions.BLOCKPLACE_SPEED);
        this.boatsOnWaterOnly = config.getBoolean("checks.blockplace.boats-on-water-only");
    }
}

