/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockplace;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractData;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceConfig;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceData;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeMaterial;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class Against
extends Check {
    public Against() {
        super(CheckType.BLOCKPLACE_AGAINST);
    }

    public boolean check(Player player, Block block, Material placedMat, Block blockAgainst, boolean isInteractBlock, BlockPlaceData data, BlockPlaceConfig cc, IPlayerData pData) {
        boolean violation = false;
        BlockInteractData bIData = pData.getGenericInstance(BlockInteractData.class);
        Material bukkitAgainst = blockAgainst.getType();
        Material ncpAgainst = bIData.getLastType();
        if (pData.isDebugActive(this.type)) {
            this.debug(player, "Placed " + placedMat.toString() + " against: " + bukkitAgainst + " (bukkit) / " + (ncpAgainst == null ? "null" : ncpAgainst.toString()) + " (nc+)");
        }
        if (bIData.isConsumedCheck(this.type) && !bIData.isPassedCheck(this.type)) {
            violation = true;
            if (pData.isDebugActive(this.type)) {
                this.debug(player, "Cancel due to block having been consumed by this check.");
            }
        } else if (isInteractBlock && !BlockProperties.isAir(ncpAgainst) && !BlockProperties.isLiquid(ncpAgainst)) {
            if (pData.isDebugActive(this.type)) {
                this.debug(player, "Block was placed against something, allow it.");
            }
        } else if (BlockProperties.isAir(ncpAgainst)) {
            if (MaterialUtil.isFarmable(placedMat) && MaterialUtil.isFarmable(bukkitAgainst)) {
                if (pData.isDebugActive(this.type)) {
                    this.debug(player, "Ignore player attempting to place a seed/plant on a crop/plant (assume desync due to fast-farming).");
                }
            } else if (!pData.hasPermission(Permissions.BLOCKPLACE_AGAINST_AIR, player) && placedMat != BridgeMaterial.LILY_PAD && placedMat != BridgeMaterial.FROGSPAWN) {
                violation = true;
            }
        } else if (!(!BlockProperties.isLiquid(ncpAgainst) || placedMat == BridgeMaterial.LILY_PAD && placedMat == BridgeMaterial.FROGSPAWN && BlockProperties.isLiquid(block.getRelative(BlockFace.DOWN).getType()) || BlockProperties.isWaterPlant(ncpAgainst) || pData.hasPermission(Permissions.BLOCKPLACE_AGAINST_LIQUIDS, player))) {
            violation = true;
        }
        bIData.addConsumedCheck(this.type);
        if (violation) {
            data.againstVL += 1.0;
            ViolationData vd = new ViolationData(this, player, data.againstVL, 1.0, cc.againstActions);
            vd.setParameter(ParameterName.BLOCK_TYPE, ncpAgainst == null ? "air" : ncpAgainst.toString());
            return this.executeActions(vd).willCancel();
        }
        data.againstVL *= 0.99;
        bIData.addPassedCheck(this.type);
        return false;
    }
}

