/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockinteract;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractConfig;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractData;
import fr.neatmonster.nocheatplus.checks.net.FlyingQueueHandle;
import fr.neatmonster.nocheatplus.checks.net.FlyingQueueLookBlockChecker;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.collision.Axis;
import fr.neatmonster.nocheatplus.utilities.collision.CollisionUtil;
import fr.neatmonster.nocheatplus.utilities.collision.tracing.axis.InteractAxisTracing;
import fr.neatmonster.nocheatplus.utilities.ds.map.BlockCoord;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.MapUtil;
import fr.neatmonster.nocheatplus.utilities.map.WrapBlockCache;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.util.Vector;

public class Visible
extends Check {
    private final WrapBlockCache wrapBlockCache;
    private final InteractAxisTracing rayTracing = new InteractAxisTracing();
    private final RayChecker checker = new RayChecker();
    private final List<String> tags = new ArrayList<String>();
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);

    public Visible() {
        super(CheckType.BLOCKINTERACT_VISIBLE);
        this.wrapBlockCache = new WrapBlockCache();
        this.rayTracing.setMaxSteps(30);
    }

    public boolean check(Player player, Location loc, double eyeHeight, Block block, BlockFace face, Action action, FlyingQueueHandle flyingHandle, BlockInteractData data, BlockInteractConfig cc, IPlayerData pData) {
        boolean collides;
        int blockX = block.getX();
        int blockY = block.getY();
        int blockZ = block.getZ();
        double eyeX = loc.getX();
        double eyeY = loc.getY() + eyeHeight;
        double eyeZ = loc.getZ();
        boolean debug = pData.isDebugActive(this.type);
        this.tags.clear();
        if (TrigUtil.isSameBlock(blockX, blockY, blockZ, eyeX, eyeY, eyeZ)) {
            collides = false;
        } else {
            BlockCache blockCache = this.wrapBlockCache.getBlockCache();
            blockCache.setAccess(loc.getWorld());
            this.rayTracing.setBlockCache(blockCache);
            this.rayTracing.set(blockX, blockY, blockZ, eyeX, eyeY, eyeZ);
            this.rayTracing.loop();
            if (this.rayTracing.collides()) {
                boolean canContinue;
                collides = true;
                BlockCoord bc = new BlockCoord(blockX, blockY, blockZ);
                Vector direction = new Vector(eyeX - (double)blockX, eyeY - (double)blockY, eyeZ - (double)blockZ).normalize();
                boolean mightEdgeInteraction = true;
                HashSet<BlockCoord> visited = new HashSet<BlockCoord>();
                Axis.RichAxisData axisData = new Axis.RichAxisData(Axis.NONE, BlockChangeTracker.Direction.NONE);
                if (Math.abs(face.getModX()) > 0) {
                    axisData.priority = Axis.X_AXIS;
                } else if (Math.abs(face.getModY()) > 0) {
                    axisData.priority = Axis.Y_AXIS;
                } else if (Math.abs(face.getModZ()) > 0) {
                    axisData.priority = Axis.Z_AXIS;
                }
                do {
                    canContinue = false;
                    for (BlockCoord neighbor : MapUtil.getNeighborsInDirection(bc, direction, eyeX, eyeY, eyeZ, axisData)) {
                        if (!CollisionUtil.canPassThrough(this.rayTracing, blockCache, bc, neighbor.getX(), neighbor.getY(), neighbor.getZ(), direction, eyeX, eyeY, eyeZ, eyeHeight, null, null, mightEdgeInteraction, axisData) || !CollisionUtil.correctDir(neighbor.getY(), blockY, Location.locToBlock((double)eyeY)) || visited.contains(neighbor)) continue;
                        if (TrigUtil.isSameBlock(neighbor.getX(), neighbor.getY(), neighbor.getZ(), eyeX, eyeY, eyeZ)) {
                            collides = false;
                            break;
                        }
                        visited.add(neighbor);
                        this.rayTracing.set(neighbor.getX(), neighbor.getY(), neighbor.getZ(), eyeX, eyeY, eyeZ);
                        this.rayTracing.loop();
                        canContinue = true;
                        collides = this.rayTracing.collides();
                        bc = new BlockCoord(neighbor.getX(), neighbor.getY(), neighbor.getZ());
                        direction = new Vector(eyeX - (double)neighbor.getX(), eyeY - (double)neighbor.getY(), eyeZ - (double)neighbor.getZ()).normalize();
                        break;
                    }
                    mightEdgeInteraction = false;
                } while (collides && canContinue);
                if (collides) {
                    this.tags.add("raytracing");
                }
            } else if (this.rayTracing.getStepsDone() > this.rayTracing.getMaxSteps()) {
                this.tags.add("raytracing_maxsteps");
                collides = true;
            } else {
                collides = false;
            }
            this.checker.cleanup();
            this.useLoc.setWorld(null);
            this.rayTracing.cleanup();
            blockCache.cleanup();
        }
        boolean cancel = false;
        if (collides) {
            data.visibleVL += 1.0;
            ViolationData vd = new ViolationData(this, player, data.visibleVL, 1.0, cc.visibleActions);
            if (this.executeActions(vd).willCancel()) {
                cancel = true;
            }
        } else {
            data.visibleVL *= 0.99;
            data.addPassedCheck(this.type);
            if (debug) {
                this.debug(player, "pitch=" + loc.getPitch() + ",yaw=" + loc.getYaw() + " tags=" + StringUtil.join(this.tags, "+"));
            }
        }
        return cancel;
    }

    private boolean checkRayTracing(double eyeX, double eyeY, double eyeZ, double dirX, double dirY, double dirZ, int blockX, int blockY, int blockZ, BlockFace face, List<String> tags, boolean debug) {
        boolean collides;
        double collideZ;
        double collideY;
        int eyeBlockX = Location.locToBlock((double)eyeX);
        int eyeBlockY = Location.locToBlock((double)eyeY);
        int eyeBlockZ = Location.locToBlock((double)eyeZ);
        int bdX = blockX - eyeBlockX;
        int bdY = blockY - eyeBlockY;
        int bdZ = blockZ - eyeBlockZ;
        double tMinX = CollisionUtil.getMinTime(eyeX, eyeBlockX, dirX, bdX);
        double tMinY = CollisionUtil.getMinTime(eyeY, eyeBlockY, dirY, bdY);
        double tMinZ = CollisionUtil.getMinTime(eyeZ, eyeBlockZ, dirZ, bdZ);
        double tMaxX = CollisionUtil.getMaxTime(eyeX, eyeBlockX, dirX, tMinX);
        double tMaxY = CollisionUtil.getMaxTime(eyeY, eyeBlockY, dirY, tMinY);
        double tMaxZ = CollisionUtil.getMaxTime(eyeZ, eyeBlockZ, dirZ, tMinZ);
        double tCollide = Math.max(0.0, Math.max(tMinX, Math.max(tMinY, tMinZ)));
        double collideX = CollisionUtil.toBlock(eyeX + dirX * tCollide, blockX);
        if (TrigUtil.distanceSquared(0.5 + (double)blockX, 0.5 + (double)blockY, 0.5 + (double)blockZ, collideX, collideY = CollisionUtil.toBlock(eyeY + dirY * tCollide, blockY), collideZ = CollisionUtil.toBlock(eyeZ + dirZ * tCollide, blockZ)) > 0.75) {
            tags.add("early_block_miss");
        }
        if (tMinX > tMaxY && tMinX > tMaxZ || tMinY > tMaxX && tMinY > tMaxZ || tMinZ > tMaxX && tMaxZ > tMaxY) {
            tags.add("time_miss");
            collideX = CollisionUtil.postCorrect(blockX, bdX, collideX);
            collideY = CollisionUtil.postCorrect(blockY, bdY, collideY);
            collideZ = CollisionUtil.postCorrect(blockZ, bdZ, collideZ);
        }
        if (tMinX == tCollide) {
            collideX = Math.round(collideX);
        }
        if (tMinY == tCollide) {
            collideY = Math.round(collideY);
        }
        if (tMinZ == tCollide) {
            collideZ = Math.round(collideZ);
        }
        if (TrigUtil.distanceSquared(0.5 + (double)blockX, 0.5 + (double)blockY, 0.5 + (double)blockZ, collideX, collideY, collideZ) > 0.75) {
            tags.add("late_block_miss");
        }
        this.rayTracing.loop();
        if (this.rayTracing.collides()) {
            tags.add("raytracing");
            collides = true;
        } else if (this.rayTracing.getStepsDone() > this.rayTracing.getMaxSteps()) {
            tags.add("raytracing_maxsteps");
            collides = true;
        } else {
            collides = false;
        }
        if (!collides || debug) {
            // empty if block
        }
        return collides;
    }

    private final class RayChecker
    extends FlyingQueueLookBlockChecker {
        private BlockFace face;
        private List<String> tags;
        private boolean debug;
        private Player player;

        private RayChecker() {
        }

        @Override
        protected boolean check(double x, double y, double z, float yaw, float pitch, int blockX, int blockY, int blockZ) {
            Visible.this.useLoc.setPitch(pitch);
            Visible.this.useLoc.setYaw(yaw);
            Vector direction = Visible.this.useLoc.getDirection();
            this.tags.clear();
            if (Visible.this.checkRayTracing(x, y, z, direction.getX(), direction.getY(), direction.getZ(), blockX, blockY, blockZ, this.face, this.tags, this.debug)) {
                if (this.debug) {
                    Visible.this.debug(this.player, "pitch=" + pitch + ",yaw=" + yaw + " tags=" + StringUtil.join(this.tags, "+"));
                }
                return false;
            }
            return true;
        }

        public boolean checkFlyingQueue(double x, double y, double z, float oldYaw, float oldPitch, int blockX, int blockY, int blockZ, FlyingQueueHandle flyingHandle, BlockFace face, List<String> tags, boolean debug, Player player) {
            this.face = face;
            this.tags = tags;
            this.debug = debug;
            this.player = player;
            return super.checkFlyingQueue(x, y, z, oldYaw, oldPitch, blockX, blockY, blockZ, flyingHandle);
        }

        @Override
        public boolean checkFlyingQueue(double x, double y, double z, float oldYaw, float oldPitch, int blockX, int blockY, int blockZ, FlyingQueueHandle flyingHandle) {
            throw new UnsupportedOperationException("Use the other method.");
        }

        public void cleanup() {
            this.player = null;
            this.face = null;
            this.debug = false;
            this.tags = null;
        }
    }
}

