/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockinteract;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractConfig;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractData;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class Reach
extends Check {
    public static final double CREATIVE_DISTANCE = 5.6;
    public static final double SURVIVAL_DISTANCE = 5.2;

    public Reach() {
        super(CheckType.BLOCKINTERACT_REACH);
    }

    public boolean check(Player player, Location loc, double eyeHeight, Block block, BlockInteractData data, BlockInteractConfig cc) {
        boolean cancel = false;
        double distanceLimit = player.getGameMode() == GameMode.CREATIVE ? 5.6 : 5.2;
        double distance = TrigUtil.distance(loc.getX(), loc.getY() + eyeHeight, loc.getZ(), 0.5 + (double)block.getX(), 0.5 + (double)block.getY(), 0.5 + (double)block.getZ());
        if (distance > distanceLimit) {
            data.reachVL += distance - distanceLimit;
            ViolationData vd = new ViolationData(this, player, data.reachVL, distance, cc.reachActions);
            vd.setParameter(ParameterName.REACH_DISTANCE, StringUtil.fdec3.format(distance));
            cancel = this.executeActions(vd).willCancel();
        } else {
            data.reachVL *= 0.9;
            data.addPassedCheck(this.type);
        }
        return cancel;
    }
}

