/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks;

import fr.neatmonster.nocheatplus.actions.Action;
import fr.neatmonster.nocheatplus.actions.ActionData;
import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.actions.types.GenericLogAction;
import fr.neatmonster.nocheatplus.actions.types.PenaltyAction;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.ViolationHistory;
import fr.neatmonster.nocheatplus.checks.access.IViolationInfo;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeHealth;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.StreamID;
import fr.neatmonster.nocheatplus.penalties.DefaultPenaltyList;
import fr.neatmonster.nocheatplus.penalties.IPenaltyList;
import fr.neatmonster.nocheatplus.permissions.RegisteredPermission;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ViolationData
implements IViolationInfo,
ActionData {
    public final ActionList actions;
    public final Action<ViolationData, ActionList>[] applicableActions;
    public final double addedVL;
    public final Check check;
    public final Player player;
    public final double vL;
    private Map<ParameterName, String> parameters = null;
    private boolean needsParameters = false;
    private boolean willCancel;
    private final IPenaltyList penaltyList;

    public ViolationData(Check check, Player player, double vL, double addedVL, ActionList actions) {
        this(check, player, vL, addedVL, actions, null);
    }

    public ViolationData(Check check, Player player, double vL, double addedVL, ActionList actions, IPenaltyList penaltyList) {
        this.check = check;
        this.player = player;
        this.vL = vL;
        this.addedVL = addedVL;
        this.actions = actions;
        this.applicableActions = actions.getActions(vL);
        this.penaltyList = penaltyList == null ? new DefaultPenaltyList() : penaltyList;
        boolean needsParameters = false;
        for (int i = 0; i < this.applicableActions.length; ++i) {
            Action<ViolationData, ActionList> action = this.applicableActions[i];
            if (!needsParameters && action.needsParameters()) {
                needsParameters = true;
            }
            if (!(action instanceof PenaltyAction)) continue;
            ((PenaltyAction)action).evaluate(this.penaltyList);
        }
        if (this.penaltyList.willCancel()) {
            this.willCancel = true;
        }
        this.needsParameters = needsParameters;
    }

    @Override
    public boolean willCancel() {
        return this.willCancel;
    }

    public void forceCancel() {
        this.willCancel = true;
    }

    public void preventCancel() {
        this.willCancel = false;
    }

    public Action<ViolationData, ActionList>[] getActions() {
        return this.applicableActions;
    }

    public void executeActions() {
        try {
            ViolationHistory.getHistory(this.player).log(this.check.getClass().getName(), this.addedVL);
            long time = System.currentTimeMillis() / 1000L;
            for (Action<ViolationData, ActionList> action : this.applicableActions) {
                if (!Check.getHistory(this.player).executeAction(this, action, time)) continue;
                action.execute(this);
            }
            if (!this.penaltyList.isEmpty()) {
                this.penaltyList.applyAllApplicablePenalties(this.player, true);
            }
            if (!this.penaltyList.isEmpty()) {
                this.penaltyList.applyPenaltiesPrecisely(ViolationData.class, this, true);
            }
        }
        catch (Exception e) {
            StaticLog.logSevere(e);
            this.willCancel = true;
        }
    }

    public void executeAction(Action<ViolationData, ActionList> action) {
        try {
            ViolationHistory.getHistory(this.player).log(this.check.getClass().getName(), this.addedVL);
            long time = System.currentTimeMillis() / 1000L;
            if (Check.getHistory(this.player).executeAction(this, action, time)) {
                action.execute(this);
            }
        }
        catch (Exception e) {
            StaticLog.logSevere(e);
            this.willCancel = true;
        }
    }

    @Override
    public String getParameter(ParameterName parameterName) {
        if (parameterName == null) {
            return "<???>";
        }
        String value = null;
        if (this.parameters != null) {
            value = this.parameters.get((Object)parameterName);
        }
        if (value == null) {
            value = this.getImplicitValue(parameterName);
        }
        return value == null ? "[" + parameterName.getText() + "]" : value;
    }

    private String getImplicitValue(ParameterName parameterName) {
        switch (parameterName) {
            case CHECK: {
                return this.check.getClass().getSimpleName();
            }
            case HEALTH: {
                String health = this.getParameterValue(ParameterName.HEALTH);
                return health == null ? BridgeHealth.getHealth((LivingEntity)this.player) + "/" + BridgeHealth.getMaxHealth((LivingEntity)this.player) : health;
            }
            case IP: {
                return this.player.getAddress().toString().substring(1).split(":")[0];
            }
            case PLAYER: 
            case PLAYER_NAME: {
                return this.player.getName();
            }
            case PLAYER_DISPLAY_NAME: {
                return this.player.getDisplayName();
            }
            case UUID: {
                return this.player.getUniqueId().toString();
            }
            case VIOLATIONS: {
                return String.valueOf(Math.round(this.vL));
            }
            case WORLD: {
                String world = this.getParameterValue(ParameterName.WORLD);
                return world == null ? this.player.getWorld().getName() : world;
            }
        }
        return null;
    }

    private String getParameterValue(ParameterName parameterName) {
        return this.parameters == null ? null : this.parameters.get((Object)parameterName);
    }

    @Override
    public void setParameter(ParameterName parameterName, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<ParameterName, String>();
        }
        this.parameters.put(parameterName, value);
    }

    public ViolationData chainParameter(ParameterName parameterName, String value) {
        this.setParameter(parameterName, value);
        return this;
    }

    @Override
    public boolean needsParameters() {
        return this.needsParameters;
    }

    @Override
    public boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    @Override
    public double getAddedVl() {
        return this.addedVL;
    }

    @Override
    public double getTotalVl() {
        return this.vL;
    }

    public RegisteredPermission getPermissionSilent() {
        return this.actions.permissionSilent;
    }

    public ActionList getActionList() {
        return this.actions;
    }

    public boolean logsToStream(StreamID streamID) {
        if (!this.needsParameters) {
            return false;
        }
        for (Action<ViolationData, ActionList> action : this.applicableActions) {
            if (!(action instanceof GenericLogAction) || !((GenericLogAction)action).logsToStream(streamID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasLogAction() {
        if (!this.needsParameters) {
            return false;
        }
        for (Action<ViolationData, ActionList> action : this.applicableActions) {
            if (!(action instanceof GenericLogAction)) continue;
            return true;
        }
        return false;
    }
}

