/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks;

import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.permissions.RegisteredPermission;

public enum CheckType {
    ALL(CheckTypeType.SPECIAL, null, Permissions.CHECKS, "checks.active"),
    BLOCKBREAK(CheckTypeType.GROUP, ALL, Permissions.BLOCKBREAK),
    BLOCKBREAK_BREAK(CheckTypeType.CHECK, BLOCKBREAK, Permissions.BLOCKBREAK_BREAK),
    BLOCKBREAK_DIRECTION(CheckTypeType.CHECK, BLOCKBREAK, Permissions.BLOCKBREAK_DIRECTION),
    BLOCKBREAK_FASTBREAK(CheckTypeType.CHECK, BLOCKBREAK, Permissions.BLOCKBREAK_FASTBREAK),
    BLOCKBREAK_FREQUENCY(CheckTypeType.CHECK, BLOCKBREAK, Permissions.BLOCKBREAK_FREQUENCY),
    BLOCKBREAK_NOSWING(CheckTypeType.CHECK, BLOCKBREAK, Permissions.BLOCKBREAK_NOSWING),
    BLOCKBREAK_REACH(CheckTypeType.CHECK, BLOCKBREAK, Permissions.BLOCKBREAK_REACH),
    BLOCKBREAK_WRONGBLOCK(CheckTypeType.CHECK, BLOCKBREAK, Permissions.BLOCKBREAK_WRONGBLOCK),
    BLOCKINTERACT(CheckTypeType.GROUP, ALL, Permissions.BLOCKINTERACT),
    BLOCKINTERACT_DIRECTION(CheckTypeType.CHECK, BLOCKINTERACT, Permissions.BLOCKINTERACT_DIRECTION),
    BLOCKINTERACT_REACH(CheckTypeType.CHECK, BLOCKINTERACT, Permissions.BLOCKINTERACT_REACH),
    BLOCKINTERACT_SPEED(CheckTypeType.CHECK, BLOCKINTERACT, Permissions.BLOCKINTERACT_SPEED),
    BLOCKINTERACT_VISIBLE(CheckTypeType.CHECK, BLOCKINTERACT, Permissions.BLOCKINTERACT_VISIBLE),
    BLOCKPLACE(CheckTypeType.GROUP, ALL, Permissions.BLOCKPLACE),
    BLOCKPLACE_AGAINST(CheckTypeType.CHECK, BLOCKPLACE, Permissions.BLOCKPLACE_AGAINST),
    BLOCKPLACE_AUTOSIGN(CheckTypeType.CHECK, BLOCKPLACE, Permissions.BLOCKPLACE_AUTOSIGN),
    BLOCKPLACE_DIRECTION(CheckTypeType.CHECK, BLOCKPLACE, Permissions.BLOCKPLACE_DIRECTION),
    BLOCKPLACE_FASTPLACE(CheckTypeType.CHECK, BLOCKPLACE, Permissions.BLOCKPLACE_FASTPLACE),
    BLOCKPLACE_NOSWING(CheckTypeType.CHECK, BLOCKPLACE, Permissions.BLOCKPLACE_NOSWING),
    BLOCKPLACE_REACH(CheckTypeType.CHECK, BLOCKPLACE, Permissions.BLOCKBREAK_REACH),
    BLOCKPLACE_SCAFFOLD(CheckTypeType.CHECK, BLOCKPLACE, Permissions.BLOCKBREAK_REACH),
    BLOCKPLACE_SPEED(CheckTypeType.CHECK, BLOCKPLACE, Permissions.BLOCKPLACE_SPEED),
    CHAT(CheckTypeType.GROUP, ALL, Permissions.CHAT),
    CHAT_CAPTCHA(CheckTypeType.CHECK, CHAT, Permissions.CHAT_CAPTCHA),
    CHAT_COMMANDS(CheckTypeType.CHECK, CHAT, Permissions.CHAT_COMMANDS),
    CHAT_TEXT(CheckTypeType.CHECK, CHAT, Permissions.CHAT_TEXT),
    CHAT_LOGINS(CheckTypeType.CHECK, CHAT, Permissions.CHAT_LOGINS),
    CHAT_RELOG(CheckTypeType.CHECK, CHAT, Permissions.CHAT_RELOG),
    COMBINED(CheckTypeType.GROUP, ALL, Permissions.COMBINED),
    COMBINED_IMPROBABLE(CheckTypeType.CHECK, COMBINED, Permissions.COMBINED_IMPROBABLE),
    COMBINED_MUNCHHAUSEN(CheckTypeType.CHECK, COMBINED, Permissions.COMBINED_MUNCHHAUSEN),
    COMBINED_YAWRATE(CheckTypeType.CHECK, COMBINED),
    FIGHT(CheckTypeType.CHECK, ALL, Permissions.FIGHT),
    FIGHT_ANGLE(CheckTypeType.CHECK, FIGHT, Permissions.FIGHT_ANGLE),
    FIGHT_CRITICAL(CheckTypeType.CHECK, FIGHT, Permissions.FIGHT_CRITICAL),
    FIGHT_DIRECTION(CheckTypeType.CHECK, FIGHT, Permissions.FIGHT_DIRECTION),
    FIGHT_FASTHEAL(CheckTypeType.CHECK, FIGHT, Permissions.FIGHT_FASTHEAL),
    FIGHT_GODMODE(CheckTypeType.CHECK, FIGHT, Permissions.FIGHT_GODMODE),
    FIGHT_NOSWING(CheckTypeType.CHECK, FIGHT, Permissions.FIGHT_NOSWING),
    FIGHT_REACH(CheckTypeType.CHECK, FIGHT, Permissions.FIGHT_REACH),
    FIGHT_SELFHIT(CheckTypeType.CHECK, FIGHT, Permissions.FIGHT_SELFHIT),
    FIGHT_VISIBLE(CheckTypeType.CHECK, FIGHT, Permissions.FIGHT_VISIBLE),
    INVENTORY(CheckTypeType.GROUP, ALL, Permissions.INVENTORY),
    INVENTORY_FASTCLICK(CheckTypeType.CHECK, INVENTORY, Permissions.INVENTORY_FASTCLICK),
    INVENTORY_FASTCONSUME(CheckTypeType.CHECK, INVENTORY, Permissions.INVENTORY_FASTCONSUME),
    INVENTORY_GUTENBERG(CheckTypeType.CHECK, INVENTORY, Permissions.INVENTORY_GUTENBERG),
    INVENTORY_INSTANTBOW(CheckTypeType.CHECK, INVENTORY, Permissions.INVENTORY_INSTANTBOW),
    INVENTORY_MOREINVENTORY(CheckTypeType.CHECK, INVENTORY, Permissions.INVENTORY_MOREINVENTORY),
    INVENTORY_OPEN(CheckTypeType.CHECK, INVENTORY, Permissions.INVENTORY_OPEN),
    MOVING(CheckTypeType.GROUP, ALL, Permissions.MOVING),
    MOVING_CREATIVEFLY(CheckTypeType.CHECK, MOVING, Permissions.MOVING_CREATIVEFLY),
    MOVING_MOREPACKETS(CheckTypeType.CHECK, MOVING, Permissions.MOVING_MOREPACKETS),
    MOVING_NOFALL(CheckTypeType.CHECK, MOVING, Permissions.MOVING_NOFALL),
    MOVING_PASSABLE(CheckTypeType.CHECK, MOVING, Permissions.MOVING_PASSABLE),
    MOVING_SURVIVALFLY(CheckTypeType.CHECK, MOVING, Permissions.MOVING_SURVIVALFLY),
    MOVING_VEHICLE(CheckTypeType.GROUP, MOVING, Permissions.MOVING_VEHICLE),
    MOVING_VEHICLE_MOREPACKETS(CheckTypeType.CHECK, MOVING_VEHICLE, Permissions.MOVING_VEHICLE_MOREPACKETS),
    MOVING_VEHICLE_ENVELOPE(CheckTypeType.CHECK, MOVING_VEHICLE, Permissions.MOVING_VEHICLE_ENVELOPE),
    NET(CheckTypeType.GROUP, ALL, Permissions.NET),
    NET_ATTACKFREQUENCY(CheckTypeType.CHECK, NET, Permissions.NET_ATTACKFREQUENCY),
    NET_FLYINGFREQUENCY(CheckTypeType.CHECK, NET, Permissions.NET_FLYINGFREQUENCY),
    NET_KEEPALIVEFREQUENCY(CheckTypeType.CHECK, NET, Permissions.NET_KEEPALIVEFREQUENCY),
    NET_MOVING(CheckTypeType.CHECK, NET, Permissions.NET_MOVING),
    NET_PACKETFREQUENCY(CheckTypeType.CHECK, NET, Permissions.NET_PACKETFREQUENCY),
    NET_SOUNDDISTANCE(CheckTypeType.CHECK, NET),
    NET_TOGGLEFREQUENCY(CheckTypeType.CHECK, NET),
    NET_WRONGTURN(CheckTypeType.CHECK, NET, Permissions.NET_WRONGTURN);

    private final CheckTypeType type;
    private final CheckType parent;
    private final RegisteredPermission permission;
    private final String configPathActive;
    private final String configPathDebug;
    private final String configPathLag;

    private CheckType(CheckTypeType type, CheckType parent) {
        this(type, parent, null);
    }

    private CheckType(CheckTypeType type, CheckType parent, RegisteredPermission permission) {
        this(type, parent, permission, null);
    }

    private CheckType(CheckTypeType type, CheckType parent, RegisteredPermission permission, String configPathActive) {
        this.type = type;
        this.parent = parent;
        this.permission = permission;
        this.configPathActive = configPathActive == null ? this.guessConfigPathActive() : configPathActive;
        this.configPathDebug = this.guessConfigPath(this.configPathActive, "debug");
        this.configPathLag = this.guessConfigPath(this.configPathActive, "lag");
    }

    private String guessConfigPathActive() {
        return this.guessConfigPathRoot() + "active";
    }

    private String guessConfigPath(String configPathActive, String suffix) {
        int index = configPathActive.lastIndexOf(".");
        return index == -1 ? suffix : configPathActive.substring(0, index + 1) + suffix;
    }

    private String guessConfigPathRoot() {
        return "checks." + this.name().toLowerCase().replace('_', '.') + ".";
    }

    public CheckTypeType getType() {
        return this.type;
    }

    public String getName() {
        return this.toString().toLowerCase().replace("_", ".");
    }

    public CheckType getParent() {
        return this.parent;
    }

    public RegisteredPermission getPermission() {
        return this.permission;
    }

    public String getConfigPathActive() {
        return this.configPathActive;
    }

    public String getConfigPathDebug() {
        return this.configPathDebug;
    }

    public String getConfigPathLag() {
        return this.configPathLag;
    }

    public static enum CheckTypeType {
        SPECIAL,
        GROUP,
        CHECK;

    }
}

