/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.ViolationHistory;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.components.debug.IDebugPlayer;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.hooks.NCPHookManager;
import fr.neatmonster.nocheatplus.penalties.IPenaltyList;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.ExecutionHistory;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.worlds.IWorldData;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public abstract class Check
implements IDebugPlayer {
    protected static Map<String, ExecutionHistory> histories = new HashMap<String, ExecutionHistory>();
    protected final CheckType type;
    protected final IGenericInstanceHandle<MCAccess> mcAccess;

    protected static ExecutionHistory getHistory(Player player) {
        if (!histories.containsKey(player.getName())) {
            histories.put(player.getName(), new ExecutionHistory());
        }
        return histories.get(player.getName());
    }

    public Check(CheckType type) {
        this.type = type;
        this.mcAccess = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(MCAccess.class);
        ViolationHistory.checkTypeMap.put(this.getClass().getName(), type);
        DataManager.registerExecutionHistory(type, histories);
    }

    public ViolationData executeActions(Player player, double vL, double addedVL, ActionList actions, IPenaltyList penaltyList) {
        return this.executeActions(new ViolationData(this, player, vL, addedVL, actions, penaltyList));
    }

    public ViolationData executeActions(Player player, double vL, double addedVL, ActionList actions) {
        return this.executeActions(new ViolationData(this, player, vL, addedVL, actions));
    }

    public ViolationData executeActions(ViolationData violationData) {
        if (NCPHookManager.shouldCancelVLProcessing(violationData)) {
            violationData.preventCancel();
        } else if (Bukkit.isPrimaryThread()) {
            violationData.executeActions();
        } else {
            TickTask.requestActionsExecution(violationData);
        }
        return violationData;
    }

    public CheckType getType() {
        return this.type;
    }

    public boolean isEnabled(Player player, IPlayerData pData, IWorldData worldData) {
        return pData.isCheckActive(this.type, player, worldData);
    }

    public boolean isEnabled(Player player, IPlayerData pData) {
        return pData.isCheckActive(this.type, player);
    }

    public boolean isEnabled(Player player) {
        return this.isEnabled(player, DataManager.getPlayerData(player));
    }

    @Override
    public void debug(Player player, String message) {
        CheckUtils.debug(player, this.type, message);
    }
}

