/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.actions;

import fr.neatmonster.nocheatplus.actions.AbstractActionFactory;
import fr.neatmonster.nocheatplus.actions.Action;
import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.actions.types.CancelAction;
import fr.neatmonster.nocheatplus.actions.types.LogAction;
import fr.neatmonster.nocheatplus.actions.types.PenaltyAction;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.penalties.CancelPenalty;
import fr.neatmonster.nocheatplus.penalties.PenaltyNode;
import java.util.Map;

public class ActionFactory
extends AbstractActionFactory<ViolationData, ActionList> {
    public ActionFactory(Map<String, Object> library) {
        super(library, ActionList.listFactory);
    }

    @Override
    public Action<ViolationData, ActionList> createAction(String actionDefinition) {
        if ((actionDefinition = actionDefinition.toLowerCase()).equals("cancel")) {
            return new CancelAction<ViolationData, ActionList>();
        }
        if (actionDefinition.endsWith("%cancel")) {
            try {
                Double probability = Double.parseDouble(actionDefinition.substring(0, actionDefinition.length() - 7));
                if (!Double.isInfinite(probability) && !Double.isNaN(probability) && probability > 0.0) {
                    return new PenaltyAction<ViolationData, ActionList>("imp_" + actionDefinition, new PenaltyNode(probability / 100.0, CancelPenalty.CANCEL));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            StaticLog.logWarning("Bad probability definition for cancel action: '" + actionDefinition + "', relay to always cancelling.");
            return new CancelAction<ViolationData, ActionList>();
        }
        if (actionDefinition.startsWith("cmd:")) {
            return this.parseCmdAction(actionDefinition.split(":", 2)[1]);
        }
        if (actionDefinition.startsWith("cmdc:")) {
            return this.parseCmdAction(actionDefinition.split(":", 2)[1], true);
        }
        if (actionDefinition.startsWith("log:")) {
            return this.parseLogAction(actionDefinition.split(":", 2)[1]);
        }
        throw new IllegalArgumentException("NoCheatPlus doesn't understand action '" + actionDefinition + "' at all.");
    }

    protected Action<ViolationData, ActionList> parseLogAction(String definition) {
        String[] parts = definition.split(":");
        String name = parts[0];
        Object message = lib.get(parts[0]);
        int delay = 0;
        int repeat = 1;
        boolean toConsole = true;
        boolean toFile = true;
        boolean toChat = true;
        if (message == null) {
            throw new IllegalArgumentException("Can't log, due to entry missing in strings: '" + name);
        }
        try {
            delay = Integer.parseInt(parts[1]);
            repeat = Integer.parseInt(parts[2]);
            toConsole = parts[3].contains("c");
            toChat = parts[3].contains("i");
            toFile = parts[3].contains("f");
        }
        catch (Exception e) {
            StaticLog.logWarning("Couldn't parse details of log action '" + definition + "', will use default values instead.");
            StaticLog.logWarning(e);
            delay = 0;
            repeat = 1;
            toConsole = true;
            toFile = true;
            toChat = true;
        }
        return new LogAction(name, delay, repeat, toChat, toConsole, toFile, message.toString());
    }
}

