/*
 * Decompiled with CFR 0.152.
 */
package dev.phoenix616.updater.sources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import de.themoep.minedown.adventure.Replacer;
import dev.phoenix616.updater.PluginConfig;
import dev.phoenix616.updater.Updater;
import dev.phoenix616.updater.sources.SourceType;
import dev.phoenix616.updater.sources.UpdateSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;

public class HangarSource
extends UpdateSource {
    private static final String API_HEADER = "application/json";
    private static final String VERSION_URL = "https://hangar.papermc.io/api/v1/projects/%project%/versions?limit=1&offset=0";

    public HangarSource(Updater updater) {
        super(updater, SourceType.HANGAR, Collections.emptyList());
    }

    private JsonObject getLatestRelease(PluginConfig config) {
        block8: {
            try {
                String s;
                Object versionUrl = VERSION_URL;
                ArrayList<String> properties = new ArrayList<String>(Arrays.asList("Accept", API_HEADER));
                if (config.getParameters().containsKey("channel")) {
                    versionUrl = (String)versionUrl + "&channel=%channel%";
                }
                if (config.getParameters().containsKey("platform")) {
                    versionUrl = (String)versionUrl + "&platform=%platform%";
                }
                if (config.getParameters().containsKey("platform-version")) {
                    versionUrl = (String)versionUrl + "&platformVersion=%platform-version%";
                }
                if ((s = this.updater.query(new URL(new Replacer().replace(config.getParameters("project")).replaceIn((String)versionUrl)), properties.toArray(new String[0]))) == null) break block8;
                try {
                    JsonElement release;
                    JsonArray result;
                    JsonElement json = new JsonParser().parse(s);
                    if (json.isJsonObject() && (result = json.getAsJsonObject().getAsJsonArray("result")) != null && result.size() > 0 && (release = result.getAsJsonArray().get(0)).isJsonObject()) {
                        return release.getAsJsonObject();
                    }
                }
                catch (JsonParseException e) {
                    this.updater.log(Level.SEVERE, "Invalid Json returned when getting latest version for " + config.getName() + " from source " + this.getName() + ": " + s + ". Error: " + e.getMessage(), new Throwable[0]);
                }
            }
            catch (MalformedURLException e) {
                this.updater.log(Level.SEVERE, "Invalid URL for getting latest version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
            }
        }
        return null;
    }

    private URL getDownloadUrl(JsonObject download) throws MalformedURLException {
        if (download.has("fileInfo") && download.get("fileInfo").isJsonObject() && download.has("downloadUrl") && download.get("downloadUrl").isJsonPrimitive()) {
            return new URL(download.get("downloadUrl").getAsString());
        }
        if (download.has("externalUrl") && download.get("externalUrl").isJsonPrimitive()) {
            return new URL(download.get("externalUrl").getAsString());
        }
        return null;
    }

    private String getMd5Hash(JsonObject download) {
        JsonObject fileInfo;
        if (download.has("fileInfo") && download.get("fileInfo").isJsonObject() && (fileInfo = download.getAsJsonObject("fileInfo")).has("md5Hash") && fileInfo.get("md5Hash").isJsonPrimitive()) {
            return download.get("md5Hash").getAsString();
        }
        return null;
    }

    private String getVersion(JsonObject release) {
        JsonElement versionElement;
        if (release != null && (versionElement = release.get("name")) != null && versionElement.isJsonPrimitive() && versionElement.getAsJsonPrimitive().isString()) {
            return versionElement.getAsString();
        }
        return null;
    }

    @Override
    public String getLatestVersion(PluginConfig config) {
        return this.getVersion(this.getLatestRelease(config));
    }

    @Override
    public URL getUpdateUrl(PluginConfig config) throws MalformedURLException, FileNotFoundException {
        JsonObject release = this.getLatestRelease(config);
        if (release != null && release.has("downloads") && release.get("downloads").isJsonObject()) {
            JsonElement platformEntry;
            JsonObject downloads = release.getAsJsonObject("downloads");
            if (config.getParameters().containsKey("platform")) {
                String platform = config.getParameters().get("platform").toUpperCase(Locale.ROOT);
                if (downloads.has(platform) && downloads.get(platform).isJsonObject()) {
                    return this.getDownloadUrl(downloads.getAsJsonObject(platform));
                }
            } else if (!downloads.entrySet().isEmpty() && (platformEntry = (JsonElement)((Map.Entry)downloads.entrySet().iterator().next()).getValue()).isJsonObject()) {
                return this.getDownloadUrl(platformEntry.getAsJsonObject());
            }
        }
        throw new FileNotFoundException("Not found");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File downloadUpdate(PluginConfig config) {
        JsonObject release = this.getLatestRelease(config);
        String version = this.getVersion(release);
        if (version == null) return null;
        if (!release.has("downloads")) return null;
        if (!release.get("downloads").isJsonObject()) return null;
        JsonObject downloads = release.getAsJsonObject("downloads");
        URL downloadUrl = null;
        String md5 = null;
        try {
            JsonElement platformEntry;
            if (config.getParameters().containsKey("platform")) {
                String platform = config.getParameters().get("platform").toUpperCase(Locale.ROOT);
                if (downloads.has(platform) && downloads.get(platform).isJsonObject()) {
                    downloadUrl = this.getDownloadUrl(downloads.getAsJsonObject(platform));
                    md5 = this.getMd5Hash(downloads.getAsJsonObject(platform));
                }
            } else if (!downloads.entrySet().isEmpty() && (platformEntry = (JsonElement)((Map.Entry)downloads.entrySet().iterator().next()).getValue()).isJsonObject()) {
                downloadUrl = this.getDownloadUrl(platformEntry.getAsJsonObject());
                md5 = this.getMd5Hash(platformEntry.getAsJsonObject());
            }
            if (downloadUrl == null) {
                this.updater.log(Level.SEVERE, "Unable to find download URL for latest version of " + config.getName() + " from source " + this.getName() + "!", new Throwable[0]);
                return null;
            }
            File target = new File(this.updater.getTempFolder(), config.getName() + "-" + version + ".jar");
            try {
                HttpURLConnection con = (HttpURLConnection)downloadUrl.openConnection();
                con.setRequestProperty("User-Agent", this.updater.getUserAgent());
                con.setUseCaches(false);
                con.connect();
                try (InputStream in = con.getInputStream();){
                    if (Files.copy(in, target.toPath(), StandardCopyOption.REPLACE_EXISTING) <= 0L) return null;
                    if (md5 != null) {
                        byte[] hash = MessageDigest.getInstance("MD5").digest(Files.readAllBytes(target.toPath()));
                        String stringHash = String.format("%x", new BigInteger(1, hash));
                        if (md5.equalsIgnoreCase(stringHash)) {
                            File file = target;
                            return file;
                        }
                        this.updater.log(Level.SEVERE, "Check sum of file (" + stringHash + ") does not match provided one (" + md5 + ")", new Throwable[0]);
                        return null;
                    }
                    File file = target;
                    return file;
                }
            }
            catch (IOException | NoSuchAlgorithmException e) {
                this.updater.log(Level.SEVERE, "Error while trying to download update " + version + " for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
                return null;
            }
        }
        catch (MalformedURLException e) {
            this.updater.log(Level.SEVERE, "Invalid URL for getting latest version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
        }
        return null;
    }
}

