/*
 * Decompiled with CFR 0.152.
 */
package dev.phoenix616.updater.sources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import de.themoep.minedown.adventure.Replacer;
import dev.phoenix616.updater.ContentType;
import dev.phoenix616.updater.PluginConfig;
import dev.phoenix616.updater.Updater;
import dev.phoenix616.updater.sources.SourceType;
import dev.phoenix616.updater.sources.UpdateSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class GitLabSource
extends UpdateSource {
    private static final List<String> REQUIRED_PARAMETERS = List.of("user");
    private static final String API_URL = "https://gitlab.com/api/v4/";
    private static final String RELEASES_URL = "%apiurl%projects/%user%%2F%repository%/releases";

    public GitLabSource(Updater updater) {
        super(updater, SourceType.GITLAB, REQUIRED_PARAMETERS);
    }

    @Override
    public String getLatestVersion(PluginConfig config) {
        try {
            Release release = this.getRelease(config);
            if (release != null) {
                return release.tagName();
            }
        }
        catch (MalformedURLException e) {
            this.updater.log(Level.SEVERE, "Invalid URL for getting latest version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
        }
        return null;
    }

    @Override
    public URL getUpdateUrl(PluginConfig config) throws MalformedURLException, FileNotFoundException {
        Release release = this.getRelease(config);
        if (release != null) {
            return new URL(release.downloadUrl());
        }
        throw new FileNotFoundException("Not found");
    }

    private Release getRelease(PluginConfig config) throws MalformedURLException {
        String s;
        Replacer replacer = new Replacer().replace(new String[]{"apiurl", API_URL}).replace(config.getParameters("repository"));
        String[] properties = new String[]{};
        if (config.getParameters().containsKey("token")) {
            properties = new String[]{"Private-Token", config.getParameters().get("token")};
        }
        if ((s = this.updater.query(new URL(replacer.replaceIn(RELEASES_URL)), properties)) != null) {
            try {
                JsonElement json = new JsonParser().parse(s);
                if (json.isJsonArray() && ((JsonArray)json).size() > 0) {
                    String author = config.getParameters().get("author");
                    for (JsonElement release : (JsonArray)json) {
                        String authorName;
                        JsonObject assets;
                        if (!release.isJsonObject() || !((JsonObject)release).has("tag_name") || !((JsonObject)release).has("assets") || !((JsonObject)release).get("assets").isJsonObject() || !(assets = ((JsonObject)release).getAsJsonObject("assets")).has("links") || !assets.get("links").isJsonArray() || author != null && !author.isEmpty() && ((JsonObject)release).has("author") && !author.equalsIgnoreCase(authorName = ((JsonObject)release).get("author").getAsJsonObject().get("username").getAsString())) continue;
                        for (JsonElement asset : assets.getAsJsonArray("links")) {
                            if (!this.matches(config, asset)) continue;
                            return new Release(((JsonObject)release).get("tag_name").getAsString(), ((JsonObject)asset).get("name").getAsString(), ((JsonObject)asset).get("url").getAsString());
                        }
                    }
                }
            }
            catch (JsonParseException e) {
                this.updater.log(Level.SEVERE, "Invalid Json returned when getting latest version for " + config.getName() + " from source " + this.getName() + ": " + s + ". Error: " + e.getMessage(), new Throwable[0]);
            }
        }
        return null;
    }

    private boolean matches(PluginConfig config, JsonElement asset) {
        String url;
        if (asset.isJsonObject() && ((JsonObject)asset).has("url") && ((JsonObject)asset).has("name") && (ContentType.JAR.urlMatches(url = ((JsonObject)asset).get("url").getAsString()) || ContentType.ZIP.urlMatches(url))) {
            String filePatternString = config.getParameters().get("file-pattern");
            if (filePatternString == null) {
                return true;
            }
            try {
                Pattern filePattern = Pattern.compile(filePatternString);
                String name = ((JsonObject)asset).get("name").getAsString();
                return filePattern.matcher(name).matches();
            }
            catch (PatternSyntaxException ex) {
                this.updater.log(Level.SEVERE, "Could not compile file-pattern regex " + filePatternString + " for " + config.getName(), new Throwable[0]);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File downloadUpdate(PluginConfig config) {
        try {
            Release release = this.getRelease(config);
            if (release == null) return null;
            String name = release.assetName();
            String version = release.tagName();
            this.updater.log(Level.FINE, "Downloading update file for " + config.getName() + " " + version + ": " + name, new Throwable[0]);
            File target = new File(this.updater.getTempFolder(), config.getName() + "-" + name);
            try {
                URL source = new URL(release.downloadUrl());
                HttpURLConnection con = (HttpURLConnection)source.openConnection();
                con.setRequestProperty("User-Agent", this.updater.getUserAgent());
                if (config.getParameters().containsKey("token")) {
                    con.setRequestProperty("Private-Token", config.getParameters().get("token"));
                }
                con.setUseCaches(false);
                con.connect();
                try (InputStream in = con.getInputStream();){
                    if (Files.copy(in, target.toPath(), StandardCopyOption.REPLACE_EXISTING) <= 0L) return null;
                    File file = target;
                    return file;
                }
            }
            catch (IOException e) {
                this.updater.log(Level.SEVERE, "Error while trying to download update " + version + " for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
                return null;
            }
        }
        catch (MalformedURLException e) {
            this.updater.log(Level.SEVERE, "Invalid URL for getting latest version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
        }
        return null;
    }

    record Release(String tagName, String assetName, String downloadUrl) {
    }
}

