/*
 * Decompiled with CFR 0.152.
 */
package dev.phoenix616.updater.sources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import de.themoep.minedown.adventure.Replacer;
import dev.phoenix616.updater.ContentType;
import dev.phoenix616.updater.PluginConfig;
import dev.phoenix616.updater.Updater;
import dev.phoenix616.updater.sources.SourceType;
import dev.phoenix616.updater.sources.UpdateSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class GitHubSource
extends UpdateSource {
    private static final List<String> REQUIRED_PARAMETERS = List.of("user");
    private static final String API_HEADER = "application/vnd.github.v3+json";
    private static final String RELEASES_URL = "https://api.github.com/repos/%user%/%repository%/releases";

    public GitHubSource(Updater updater) {
        super(updater, SourceType.GITHUB, REQUIRED_PARAMETERS);
    }

    @Override
    public String getLatestVersion(PluginConfig config) {
        try {
            Release release = this.getRelease(config);
            if (release != null) {
                return release.tagName();
            }
        }
        catch (MalformedURLException e) {
            this.updater.log(Level.SEVERE, "Invalid URL for getting latest version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
        }
        return null;
    }

    @Override
    public URL getUpdateUrl(PluginConfig config) throws MalformedURLException, FileNotFoundException {
        Release release = this.getRelease(config);
        if (release != null) {
            return new URL(release.downloadUrl());
        }
        throw new FileNotFoundException("Not found");
    }

    private Release getRelease(PluginConfig config) throws MalformedURLException {
        ArrayList<String> properties = new ArrayList<String>(Arrays.asList("Accept", API_HEADER));
        if (config.getParameters().containsKey("token")) {
            Collections.addAll(properties, "Authorization", "token " + config.getParameters().get("token"));
        } else if (config.getParameters().containsKey("username") && config.getParameters().containsKey("password")) {
            String userPass = config.getParameters().get("username") + ":" + config.getParameters().get("password");
            Collections.addAll(properties, "Authorization", "Basic " + Base64.getEncoder().encodeToString(userPass.getBytes()));
        }
        String channel = config.getParameters().get("channel");
        if (channel != null && !"release".equals(channel) && !"prerelease".equals(channel)) {
            this.updater.log(Level.SEVERE, "Invalid channel '" + channel + " for " + config.getName() + " from source " + this.getName() + "! Must be 'release' or 'prerelease'.", new Throwable[0]);
            return null;
        }
        String s = this.updater.query(new URL(new Replacer().replace(config.getParameters("repository")).replaceIn(RELEASES_URL)), properties.toArray(new String[0]));
        if (s != null) {
            try {
                JsonElement json = new JsonParser().parse(s);
                if (json.isJsonArray() && ((JsonArray)json).size() > 0) {
                    String draft = config.getParameters().get("draft");
                    String author = config.getParameters().get("author");
                    for (JsonElement release : (JsonArray)json) {
                        String authorName;
                        boolean isDraft;
                        if (!release.isJsonObject() || !((JsonObject)release).has("tag_name") || !((JsonObject)release).has("assets") || !((JsonObject)release).get("assets").isJsonArray()) continue;
                        boolean isPrerelease = ((JsonObject)release).has("prerelease") && ((JsonObject)release).get("prerelease").getAsBoolean();
                        boolean bl = isDraft = ((JsonObject)release).has("draft") && ((JsonObject)release).get("draft").getAsBoolean();
                        if (isDraft && !"true".equalsIgnoreCase(draft) || "release".equalsIgnoreCase(channel) && isPrerelease || "prerelease".equalsIgnoreCase(channel) && !isPrerelease || author != null && !author.isEmpty() && ((JsonObject)release).has("author") && !author.equalsIgnoreCase(authorName = ((JsonObject)release).get("author").getAsJsonObject().get("login").getAsString())) continue;
                        for (JsonElement asset : ((JsonObject)release).getAsJsonArray("assets")) {
                            if (!this.matches(config, asset)) continue;
                            return new Release(((JsonObject)release).get("tag_name").getAsString(), ((JsonObject)asset).get("name").getAsString(), ((JsonObject)asset).get("url").getAsString(), ((JsonObject)asset).get("browser_download_url").getAsString());
                        }
                    }
                }
                this.updater.log(Level.WARNING, "Json did not contain release entry for " + config.getName() + " from source " + this.getName() + ": " + String.valueOf(json), new Throwable[0]);
            }
            catch (JsonParseException e) {
                this.updater.log(Level.SEVERE, "Invalid Json returned when getting latest version for " + config.getName() + " from source " + this.getName() + ": " + s + ". Error: " + e.getMessage(), new Throwable[0]);
            }
        } else {
            this.updater.log(Level.WARNING, "Query didn't return anything for " + config.getName() + " from source " + this.getName() + "!", new Throwable[0]);
        }
        return null;
    }

    private boolean matches(PluginConfig config, JsonElement asset) {
        String contentType;
        if (asset.isJsonObject() && ((JsonObject)asset).has("url") && ((JsonObject)asset).has("browser_download_url") && ((JsonObject)asset).has("content_type") && ((JsonObject)asset).has("name") && (ContentType.JAR.matches(contentType = ((JsonObject)asset).get("content_type").getAsString()) || ContentType.ZIP.matches(contentType))) {
            String filePatternString = config.getParameters().get("file-pattern");
            if (filePatternString == null) {
                return true;
            }
            try {
                Pattern filePattern = Pattern.compile(filePatternString);
                String name = ((JsonObject)asset).get("name").getAsString();
                return filePattern.matcher(name).matches();
            }
            catch (PatternSyntaxException ex) {
                this.updater.log(Level.SEVERE, "Could not compile file-pattern regex " + filePatternString + " for " + config.getName(), new Throwable[0]);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File downloadUpdate(PluginConfig config) {
        try {
            Release release = this.getRelease(config);
            if (release == null) return null;
            String name = release.assetName();
            String version = release.tagName();
            this.updater.log(Level.FINE, "Downloading update file for " + config.getName() + " " + version + ": " + name, new Throwable[0]);
            File target = new File(this.updater.getTempFolder(), config.getName() + "-" + version + "-" + name);
            try {
                URL source = new URL(release.assetUrl());
                HttpURLConnection con = (HttpURLConnection)source.openConnection();
                con.setRequestProperty("User-Agent", this.updater.getUserAgent());
                con.addRequestProperty("Accept", "application/octet-stream");
                if (config.getParameters().containsKey("token")) {
                    con.addRequestProperty("Authorization", "token " + config.getParameters().get("token"));
                } else if (config.getParameters().containsKey("username") && config.getParameters().containsKey("password")) {
                    String userPass = config.getParameters().get("username") + ":" + config.getParameters().get("password");
                    con.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString(userPass.getBytes()));
                }
                con.setUseCaches(false);
                con.connect();
                try (InputStream in = con.getInputStream();){
                    if (Files.copy(in, target.toPath(), StandardCopyOption.REPLACE_EXISTING) <= 0L) return null;
                    File file = target;
                    return file;
                }
            }
            catch (IOException e) {
                this.updater.log(Level.SEVERE, "Error while trying to download update " + version + " for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
                this.updater.log(Level.INFO, "You can try to download the file manually from " + release.downloadUrl(), new Throwable[0]);
                return null;
            }
        }
        catch (MalformedURLException e) {
            this.updater.log(Level.SEVERE, "Invalid URL for getting latest version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
        }
        return null;
    }

    record Release(String tagName, String assetName, String assetUrl, String downloadUrl) {
    }
}

