/*
 * Decompiled with CFR 0.152.
 */
package dev.phoenix616.updater.sources;

import de.themoep.minedown.adventure.Replacer;
import dev.phoenix616.updater.PluginConfig;
import dev.phoenix616.updater.Updater;
import dev.phoenix616.updater.sources.SourceType;
import dev.phoenix616.updater.sources.UpdateSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;

public class FileSource
extends UpdateSource {
    private final String latestVersion;
    private final String download;

    public FileSource(String name, Updater updater, String latestVersion, String download, List<String> requiredParameters) {
        super(updater, SourceType.FILE, name, requiredParameters);
        this.latestVersion = latestVersion;
        this.download = download;
    }

    @Override
    public String getLatestVersion(PluginConfig config) {
        File file = new File(new Replacer().replace(config.getParameters()).replaceIn(this.latestVersion));
        if (Files.isSymbolicLink(file.toPath())) {
            try {
                Path linked = Files.readSymbolicLink(file.toPath());
                if (Files.isDirectory(linked, new LinkOption[0])) {
                    return linked.getFileName().toString();
                }
            }
            catch (IOException e) {
                this.updater.log(Level.SEVERE, "Error while trying to get latest version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
            }
        }
        if (file.isFile()) {
            try {
                List<String> lines = Files.readAllLines(file.toPath());
                if (!lines.isEmpty()) {
                    return lines.get(0);
                }
            }
            catch (IOException e) {
                this.updater.log(Level.SEVERE, "Error while trying to get latest version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
            }
        }
        return null;
    }

    @Override
    public URL getUpdateUrl(PluginConfig config) throws MalformedURLException, FileNotFoundException {
        File file = new File(new Replacer().replace(config.getParameters()).replaceIn(this.download));
        if (file.exists()) {
            return file.toURI().toURL();
        }
        throw new FileNotFoundException("Not found");
    }

    @Override
    public File downloadUpdate(PluginConfig config) {
        String version = this.getLatestVersion(config);
        if (version != null) {
            File source = new File(new Replacer().replace(config.getParameters()).replaceIn(this.download));
            File target = new File(this.updater.getTempFolder(), config.getFileName(version) + "-" + source.getName());
            try {
                return Files.copy(source.toPath(), target.toPath(), new CopyOption[0]).toFile();
            }
            catch (IOException e) {
                this.updater.log(Level.SEVERE, "Error while trying to copy update " + version + " for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
            }
        }
        return null;
    }
}

