/*
 * Decompiled with CFR 0.152.
 */
package dev.phoenix616.updater.sources;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Predicate;
import com.typesafe.config.Config;
import de.themoep.minedown.adventure.Replacer;
import dev.phoenix616.updater.PluginConfig;
import dev.phoenix616.updater.Updater;
import dev.phoenix616.updater.sources.SourceType;
import dev.phoenix616.updater.sources.UpdateSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DirectSource
extends UpdateSource {
    private final String latestVersion;
    private final String download;
    private final String versionPath;
    private final String versionRegex;
    private final String downloadPath;
    private final String downloadRegex;

    public DirectSource(String name, Updater updater, Config config) {
        super(updater, SourceType.DIRECT, name, config.hasPath("required-parameters") ? config.getStringList("required-parameters") : (config.hasPath("required-placeholders") ? config.getStringList("required-placeholders") : Collections.emptyList()));
        this.latestVersion = config.getString("latest-version");
        this.download = config.getString("download");
        this.versionPath = config.hasPath("version-json-path") ? config.getString("version-json-path") : null;
        this.versionRegex = config.hasPath("version-regex-pattern") ? config.getString("version-regex-pattern") : null;
        this.downloadPath = config.hasPath("download-json-path") ? config.getString("download-json-path") : null;
        this.downloadRegex = config.hasPath("download-regex-pattern") ? config.getString("download-regex-pattern") : null;
    }

    @Override
    public String getLatestVersion(PluginConfig config) {
        block6: {
            try {
                Replacer replacer = new Replacer().replace(config.getParameters());
                String r = this.updater.query(new URL(replacer.replaceIn(this.latestVersion)), new String[0]);
                if (r == null || r.isEmpty()) break block6;
                try {
                    return this.getParsedValue(config.getName(), r, this.versionPath, this.versionRegex, replacer);
                }
                catch (PatternSyntaxException e) {
                    this.updater.log(Level.SEVERE, "Invalid regex pattern for getting latest direct version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
                }
                catch (JsonPathException e) {
                    this.updater.log(Level.SEVERE, "Error while trying to use JSONPath " + this.versionPath + " in " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
                }
                catch (ClassCastException e) {
                    this.updater.log(Level.SEVERE, "Invalid json result to get latest version for " + config.getName() + " from source " + this.getName() + "! ('" + r + "') " + e.getMessage(), new Throwable[0]);
                }
            }
            catch (MalformedURLException e) {
                this.updater.log(Level.SEVERE, "Invalid URL for getting latest direct version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
            }
        }
        return null;
    }

    @Override
    public URL getUpdateUrl(PluginConfig config) throws MalformedURLException {
        String version = this.getLatestVersion(config);
        if (version != null) {
            String downloadUrl;
            Replacer replacer = new Replacer().replace(config.getParameters()).replace(new String[]{"version", version});
            if (this.downloadPath == null && this.downloadRegex == null) {
                return new URL(replacer.replaceIn(this.download));
            }
            String downloadQuery = this.updater.query(new URL(replacer.replaceIn(this.download)), new String[0]);
            if (downloadQuery != null && !downloadQuery.isEmpty() && (downloadUrl = this.getParsedValue(config.getName(), downloadQuery, this.downloadPath, this.downloadRegex, replacer)) != null) {
                return new URL(downloadUrl);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File downloadUpdate(PluginConfig config) {
        try {
            URL source = this.getUpdateUrl(config);
            if (source == null) {
                this.updater.log(Level.SEVERE, "No download URL found for " + config.getName() + " from source " + this.getName() + "!", new Throwable[0]);
                return null;
            }
            File target = new File(this.updater.getTempFolder(), config.getName() + "-" + source.getPath().substring(source.getPath().lastIndexOf(47) + 1));
            HttpURLConnection con = (HttpURLConnection)source.openConnection();
            con.setUseCaches(false);
            con.setRequestProperty("User-Agent", this.updater.getUserAgent());
            con.connect();
            try (InputStream in = con.getInputStream();){
                if (Files.copy(in, target.toPath(), StandardCopyOption.REPLACE_EXISTING) <= 0L) return null;
                File file = target;
                return file;
            }
        }
        catch (IOException e) {
            this.updater.log(Level.SEVERE, "Error while trying to download update for " + config.getName() + " from source " + this.getName() + "! (" + e.getMessage(), new Throwable[0]);
        }
        return null;
    }

    private String getParsedValue(String name, String value, String jsonPath, String regex, Replacer replacer) {
        block11: {
            if (value.startsWith("[") && value.endsWith("]") || value.startsWith("{") && value.endsWith("}")) {
                if (jsonPath != null) {
                    try {
                        Object rawValue = JsonPath.compile((String)replacer.replaceIn(jsonPath), (Predicate[])new Predicate[0]).read(value);
                        if (rawValue == null) {
                            this.updater.log(Level.SEVERE, "No value found for JSON path '" + jsonPath + "' for " + name + " from source " + this.getName() + " in json '" + value + "'!", new Throwable[0]);
                            return null;
                        }
                        value = rawValue.toString();
                    }
                    catch (JsonPathException e) {
                        this.updater.log(Level.SEVERE, "Error while trying to use JSONPath " + jsonPath + " in " + name + " from source " + this.getName() + " on '" + value + "'! " + e.getMessage(), new Throwable[0]);
                    }
                } else if (regex == null) {
                    this.updater.log(Level.SEVERE, "No regex nor JSON path specified for " + name + " from source " + this.getName() + "!", new Throwable[0]);
                    return null;
                }
            }
            if (regex != null) {
                try {
                    Matcher matcher = Pattern.compile(replacer.replaceIn(regex)).matcher(value);
                    if (matcher.matches()) {
                        value = matcher.groupCount() > 0 ? matcher.group(1) : matcher.group();
                        break block11;
                    }
                    this.updater.log(Level.SEVERE, "Return value '" + value + "' does not match regex pattern '" + regex + "' in " + name + " from source " + this.getName() + "!", new Throwable[0]);
                    return null;
                }
                catch (PatternSyntaxException e) {
                    this.updater.log(Level.SEVERE, "Invalid regex pattern '" + regex + "' in source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
                }
            }
        }
        return value;
    }
}

