/*
 * Decompiled with CFR 0.152.
 */
package dev.phoenix616.updater;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.config.ConfigValueType;
import dev.phoenix616.updater.ContentType;
import dev.phoenix616.updater.PluginConfig;
import dev.phoenix616.updater.sources.BukkitSource;
import dev.phoenix616.updater.sources.DirectSource;
import dev.phoenix616.updater.sources.FileSource;
import dev.phoenix616.updater.sources.GitHubSource;
import dev.phoenix616.updater.sources.GitLabSource;
import dev.phoenix616.updater.sources.HangarSource;
import dev.phoenix616.updater.sources.ModrinthSource;
import dev.phoenix616.updater.sources.SourceType;
import dev.phoenix616.updater.sources.SpigotSource;
import dev.phoenix616.updater.sources.TeamCitySource;
import dev.phoenix616.updater.sources.UpdateSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class Updater {
    public static final Pattern GITHUB_PATTERN = Pattern.compile(".*https?://(?:www\\.)?github\\.com/(?<user>[\\w\\-]+)/(?<repo>[\\w\\-]+)(?:[/#].*)?.*");
    public static final Pattern HANGAR_PATTERN = Pattern.compile(".*https?://hangar\\.papermc\\.io/(?<author>[\\w\\-]+)/(?<project>[\\w\\-]+)(?:[/#].*)?.*");
    public static final Pattern SPIGOT_PATTERN = Pattern.compile(".*https?://(?:www\\.)?spigotmc\\.org/resources/.*\\.(?<id>\\d+)(?:[/#].*)?.*");
    private final Map<String, UpdateSource> sources = new HashMap<String, UpdateSource>();
    private final Map<String, PluginConfig> plugins = new HashMap<String, PluginConfig>();
    private Config versions;
    private static final Config PLUGIN_DEFAULTS = ConfigFactory.empty().withValue("file-name-format", ConfigValueFactory.fromAnyRef((Object)"%name%.jar-%version%"));
    private final Cache<URL, String> queryCache = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    private File targetFolder;
    private Level logLevel = Level.INFO;

    public Updater(File targetFolder) {
        this.targetFolder = targetFolder;
    }

    private void loadConfig() {
        Config sourcesConfig = this.getConfig("sources");
        this.sources.clear();
        this.addSource(new BukkitSource(this));
        this.addSource(new GitHubSource(this));
        this.addSource(new GitLabSource(this));
        this.addSource(new HangarSource(this));
        this.addSource(new ModrinthSource(this));
        this.addSource(new SpigotSource(this));
        for (String sourceName : sourcesConfig.root().keySet()) {
            try {
                Config sourceConfig = sourcesConfig.getConfig(sourceName);
                SourceType type = SourceType.valueOf(sourceConfig.getString("type").toUpperCase(Locale.ROOT));
                switch (type) {
                    case FILE: {
                        this.addSource(new FileSource(sourceName, this, sourceConfig.getString("latest-version"), sourceConfig.getString("download"), sourceConfig.hasPath("required-parameters") ? sourceConfig.getStringList("required-parameters") : (sourceConfig.hasPath("required-placeholders") ? sourceConfig.getStringList("required-placeholders") : Collections.emptyList())));
                        if (!sourceConfig.hasPath("required-placeholders")) break;
                        this.log(Level.WARNING, "File-source " + sourceName + " uses deprecated 'required-placeholders' config option! Please use 'required-parameters' instead as this will be removed in a future version!", new Throwable[0]);
                        break;
                    }
                    case DIRECT: {
                        this.addSource(new DirectSource(sourceName, this, sourceConfig));
                        if (!sourceConfig.hasPath("required-placeholders")) break;
                        this.log(Level.WARNING, "Direct-source " + sourceName + " uses deprecated 'required-placeholders' config option! Please use 'required-parameters' instead as this will be removed in a future version!", new Throwable[0]);
                        break;
                    }
                    case TEAMCITY: {
                        this.addSource(new TeamCitySource(sourceName, this, sourceConfig.getString("url"), sourceConfig.hasPath("token") ? sourceConfig.getString("token") : null));
                    }
                }
            }
            catch (ConfigException | IllegalArgumentException e) {
                this.log(Level.SEVERE, "Error while loading source " + sourceName + " config!", e);
            }
        }
        Config pluginsConfig = this.getConfig("plugins");
        for (String pluginName : pluginsConfig.root().keySet()) {
            try {
                Config pluginConfig = pluginsConfig.getConfig(pluginName).withFallback((ConfigMergeable)PLUGIN_DEFAULTS);
                UpdateSource source = this.getSource(pluginConfig.getString("source"));
                if (source == null) {
                    throw new IllegalArgumentException("No source by the name " + pluginConfig.getString("source") + " found.");
                }
                this.addPlugin(new PluginConfig(pluginName, source, pluginConfig.getString("file-name-format"), pluginConfig.hasPath("parameters") ? this.toMap(pluginConfig.getConfig("parameters")) : (pluginConfig.hasPath("placeholders") ? this.toMap(pluginConfig.getConfig("placeholders")) : Collections.emptyMap())));
            }
            catch (ConfigException | IllegalArgumentException e) {
                this.log(Level.SEVERE, "Error while loading plugin " + pluginName + " config!", e);
            }
        }
    }

    public boolean run(String[] args) {
        boolean r;
        String pluginName = null;
        boolean searchExistingJars = true;
        boolean checkOnly = false;
        boolean dontLink = this.getDontLink();
        String par = "";
        for (int i = 0; i < args.length; ++i) {
            String value;
            int start = 0;
            if (args[i].startsWith("--")) {
                start = 2;
            } else if (args[i].startsWith("-")) {
                start = 1;
            } else if (par.isEmpty()) {
                this.log(Level.WARNING, "Wrong parameter " + args[i] + "!", new Throwable[0]);
                return false;
            }
            par = args[i].substring(start);
            if ("c".equals(par) || "check-only".equalsIgnoreCase(par)) {
                checkOnly = true;
                continue;
            }
            if ("d".equals(par) || "dont-link".equalsIgnoreCase(par)) {
                dontLink = true;
                continue;
            }
            if ("dont-search-existing-jars".equalsIgnoreCase(par)) {
                searchExistingJars = false;
                continue;
            }
            if (i + 1 >= args.length) continue;
            if ((value = args[++i]).startsWith("\"")) {
                boolean endFound = false;
                StringBuilder sb = new StringBuilder(value);
                for (int j = i + 1; j < args.length; ++j) {
                    sb.append(" ").append(args[j]);
                    if (!args[j].endsWith("\"")) continue;
                    endFound = true;
                    i = j;
                    break;
                }
                if (endFound) {
                    value = sb.toString();
                    value = value.substring(1, value.length() - 1);
                }
            }
            if (this.targetFolder == null && ("t".equals(par) || "target-folder".equalsIgnoreCase(par))) {
                this.targetFolder = new File(value);
                continue;
            }
            if ("p".equals(par) || "plugin".equalsIgnoreCase(par)) {
                pluginName = value;
                continue;
            }
            if (!"l".equals(par) && !"log-level".equalsIgnoreCase(par)) continue;
            try {
                this.logLevel = Level.parse(value);
                continue;
            }
            catch (IllegalArgumentException e) {
                this.log(Level.WARNING, "Invalid parameter '" + par + "'! " + e.getMessage(), new Throwable[0]);
                return true;
            }
        }
        this.loadConfig();
        PluginConfig plugin = null;
        if (pluginName != null && (plugin = this.getPlugin(pluginName)) == null) {
            this.log(Level.WARNING, "No Plugin found with name " + pluginName, new Throwable[0]);
            return true;
        }
        if (this.targetFolder == null) {
            this.log(Level.WARNING, "Target folder not specified!", new Throwable[0]);
            return false;
        }
        if (!this.targetFolder.exists()) {
            this.log(Level.WARNING, "Target folder does not exist! " + String.valueOf(this.targetFolder), new Throwable[0]);
            return true;
        }
        this.versions = this.getConfig(new File(this.targetFolder, "versions.conf"));
        if (plugin != null) {
            r = this.check(plugin, !checkOnly, dontLink);
        } else {
            if (searchExistingJars) {
                this.searchExistingJars();
            }
            r = this.check(!checkOnly, dontLink);
        }
        if (r && !checkOnly) {
            try {
                this.saveInstalledVersions();
            }
            catch (IOException e) {
                this.log(Level.SEVERE, "Failed to save versions file!", e);
            }
        }
        return true;
    }

    private void searchExistingJars() {
        for (File file : Objects.requireNonNull(this.getTargetFolder().listFiles((dir, name) -> name.toLowerCase(Locale.ROOT).endsWith(".jar")))) {
            String pluginName = file.getName().substring(0, file.getName().length() - 4);
            if (this.getPlugin(pluginName) != null) continue;
            try {
                ZipFile jar = new ZipFile(file);
                ZipEntry pluginDescription = jar.getEntry("plugin.yml");
                if (pluginDescription == null) {
                    pluginDescription = jar.getEntry("bungee.yml");
                }
                if (pluginDescription == null) continue;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(jar.getInputStream(pluginDescription)));){
                    String line;
                    while ((line = in.readLine()) != null) {
                        Matcher ghMatcher;
                        Matcher spigotMatcher;
                        Matcher hangarMatcher = HANGAR_PATTERN.matcher(line);
                        if (hangarMatcher.matches()) {
                            String hangarAuthor = hangarMatcher.group("author");
                            String hangarProject = hangarMatcher.group("project");
                            this.log(Level.INFO, "Found link to a Hanger project page in " + file.getName() + "! If you want to update from there add the following to your plugins config:\n\n" + pluginName + " {\n  source = hangar\n  parameters {\n    author = " + hangarAuthor + "\n    project = " + hangarProject + "\n  }\n}\n", new Throwable[0]);
                        }
                        if ((spigotMatcher = SPIGOT_PATTERN.matcher(line)).matches()) {
                            String id = spigotMatcher.group("id");
                            this.log(Level.INFO, "Found link to SpigotMC resource page in " + file.getName() + "! If you want to update from there add the following to your plugins config:\n\n" + pluginName + " {\n  source = spigot\n  parameters {\n    resourceid = " + id + "\n  }\n}\n", new Throwable[0]);
                        }
                        if (!(ghMatcher = GITHUB_PATTERN.matcher(line)).matches()) continue;
                        String ghUser = ghMatcher.group("user");
                        String ghRepository = ghMatcher.group("repo");
                        this.log(Level.INFO, "Found link to GitHub repository in " + file.getName() + "! If you want to update from there add the following to your plugins config:\n\n" + pluginName + " {\n  source = github\n  parameters {\n    user = " + ghUser + "\n    repository = " + ghRepository + "\n  }\n}\n", new Throwable[0]);
                    }
                }
            }
            catch (IOException e) {
                this.log(Level.SEVERE, "Error while trying to check content of " + file.getName() + "!", e);
            }
        }
    }

    private boolean check(boolean update, boolean dontLink) {
        boolean r = false;
        for (PluginConfig plugin : this.plugins.values()) {
            r |= this.check(plugin, update, dontLink);
        }
        return r;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean check(PluginConfig plugin, boolean update, boolean dontLink) {
        String latestVersion = plugin.getSource().getLatestVersion(plugin);
        if (latestVersion != null && this.isNewVersion(plugin, latestVersion)) {
            this.log(Level.INFO, "Found new version of " + plugin.getName() + " on " + plugin.getSource().getName() + ": " + latestVersion, new Throwable[0]);
            if (update) {
                File downloadedFile;
                block23: {
                    this.log(Level.INFO, "Downloading " + plugin.getName() + " " + latestVersion + "...", new Throwable[0]);
                    downloadedFile = plugin.getSource().downloadUpdate(plugin);
                    if (downloadedFile == null) return false;
                    this.log(Level.INFO, "Done!", new Throwable[0]);
                    try {
                        String contentType = Files.probeContentType(downloadedFile.toPath());
                        if (ContentType.JAR.matches(contentType)) {
                            this.log(Level.INFO, "Successfully downloaded plugin jar file!", new Throwable[0]);
                            break block23;
                        }
                        if (ContentType.ZIP.matches(contentType)) {
                            this.log(Level.INFO, "Downloaded a zip archive. Trying to unpack it...", new Throwable[0]);
                            ZipFile zip = new ZipFile(downloadedFile);
                            String zipEntryPatternString = plugin.getParameters().get("zip-entry-pattern");
                            Pattern zipEntryPattern = null;
                            if (zipEntryPatternString != null) {
                                try {
                                    zipEntryPattern = Pattern.compile(zipEntryPatternString);
                                }
                                catch (PatternSyntaxException ex) {
                                    this.log(Level.SEVERE, "Could not compile zip-entry-pattern regex " + zipEntryPatternString + " for " + plugin.getName(), new Throwable[0]);
                                }
                            }
                            Pattern finalZipEntryPattern = zipEntryPattern;
                            Optional<ZipEntry> entry = zip.stream().filter(e -> finalZipEntryPattern != null ? finalZipEntryPattern.matcher(e.getName()).matches() : e.getName().endsWith(".jar")).filter(e -> !e.getName().endsWith("-sources.jar") && !e.getName().endsWith("-javadoc.jar")).max((o1, o2) -> Long.compare(o2.getSize(), o1.getSize()));
                            if (entry.isPresent()) {
                                downloadedFile = new File(this.getTempFolder(), entry.get().getName().contains("/") ? entry.get().getName().substring(entry.get().getName().lastIndexOf(47)) : entry.get().getName());
                                try {
                                    Files.copy(zip.getInputStream(entry.get()), downloadedFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                    break block23;
                                }
                                catch (IOException e2) {
                                    this.log(Level.SEVERE, "Error while trying to unpack file " + entry.get().getName() + " from " + zip.getName() + ". Aborting!", e2);
                                    return false;
                                }
                            }
                            this.log(Level.SEVERE, "Unable to find jar file in zip archive. Aborting!", new Throwable[0]);
                            return false;
                        }
                        if (contentType != null) {
                            this.log(Level.INFO, "Downloaded a " + contentType + " file which isn't supported. Trying to link it anyways...", new Throwable[0]);
                        } else {
                            this.log(Level.INFO, "Unable to detect file content type... hoping for the best :S", new Throwable[0]);
                        }
                    }
                    catch (IOException e3) {
                        this.log(Level.SEVERE, "Error while trying to get type of downloaded file!", e3);
                    }
                }
                File versionedFile = new File(this.getTargetFolder(), plugin.getFileName(latestVersion));
                try {
                    Files.move(downloadedFile.toPath(), versionedFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    if (dontLink) return true;
                    File pluginFile = new File(this.getTargetFolder(), plugin.getName() + ".jar");
                    if (pluginFile.exists()) {
                        pluginFile.delete();
                    }
                    try {
                        Files.createSymbolicLink(pluginFile.toPath(), this.getTargetFolder().toPath().relativize(versionedFile.toPath()), new FileAttribute[0]);
                        this.log(Level.INFO, "Linked " + String.valueOf(pluginFile) + " to " + String.valueOf(versionedFile), new Throwable[0]);
                        this.setInstalledVersion(plugin, latestVersion);
                        return true;
                    }
                    catch (IOException e4) {
                        this.log(Level.WARNING, "Failed to create symbolic link from " + String.valueOf(pluginFile) + " to " + String.valueOf(versionedFile) + "! (" + e4.getMessage() + ") Creating hard link.", new Throwable[0]);
                        try {
                            Files.createLink(this.getTargetFolder().toPath(), versionedFile.toPath());
                            this.log(Level.INFO, "Linked " + String.valueOf(pluginFile) + " to " + String.valueOf(versionedFile), new Throwable[0]);
                            return true;
                        }
                        catch (IOException e1) {
                            this.log(Level.SEVERE, "Error while linking!", e1);
                            return false;
                        }
                    }
                }
                catch (IOException e5) {
                    this.log(Level.SEVERE, "Failed to move temporary file to versioned " + String.valueOf(downloadedFile) + " to " + String.valueOf(versionedFile) + "! (" + e5.getMessage() + ")", new Throwable[0]);
                }
                return true;
            }
            try {
                this.log(Level.FINE, "Get update from " + String.valueOf(plugin.getSource().getUpdateUrl(plugin)), new Throwable[0]);
                return true;
            }
            catch (FileNotFoundException | MalformedURLException e6) {
                this.log(Level.SEVERE, "Error while trying to get download URL: " + e6.getMessage(), new Throwable[0]);
            }
            return true;
        }
        this.log(Level.FINE, "No new version for " + plugin.getName() + " found from " + String.valueOf((Object)plugin.getSource().getType()) + " source " + plugin.getSource().getName() + " (got " + latestVersion + ")", new Throwable[0]);
        return false;
    }

    private boolean isNewVersion(PluginConfig plugin, String latestVersion) {
        block7: {
            String installedVersion = this.getInstalledVersion(plugin);
            if (installedVersion != null) {
                installedVersion = Updater.sanitize(installedVersion);
                latestVersion = Updater.sanitize(latestVersion);
                try {
                    int installedBuild = Integer.parseInt(installedVersion);
                    try {
                        int latestBuild = Integer.parseInt(latestVersion);
                        return installedBuild < latestBuild;
                    }
                    catch (NumberFormatException e) {
                        return true;
                    }
                }
                catch (NumberFormatException installedBuild) {
                    if (installedVersion.indexOf(46) <= 0 || latestVersion.indexOf(46) <= 0) break block7;
                    try {
                        int[] installedSemVer = this.parseSemVer(installedVersion);
                        int[] latestSemVer = this.parseSemVer(latestVersion);
                        return this.compareTo(latestSemVer, installedSemVer) > 0;
                    }
                    catch (NumberFormatException e) {
                        return true;
                    }
                }
            }
        }
        return true;
    }

    private int compareTo(int[] latestSemVer, int[] installedSemVer) {
        for (int i = 0; i < installedSemVer.length && i < latestSemVer.length; ++i) {
            int latestVersionInt = latestSemVer[i];
            int installedVersionInt = installedSemVer[i];
            if (latestVersionInt > installedVersionInt) {
                return 1;
            }
            if (latestVersionInt >= installedVersionInt) continue;
            return -1;
        }
        if (installedSemVer.length < latestSemVer.length) {
            return 1;
        }
        if (installedSemVer.length > latestSemVer.length) {
            return -1;
        }
        return 0;
    }

    public static String sanitize(String version) {
        return version.split("[\\s(\\-#\\[{]", 2)[0];
    }

    private int[] parseSemVer(String version) throws NumberFormatException {
        String[] split = version.split("\\.");
        int[] semVer = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            semVer[i] = Integer.parseInt(split[i]);
        }
        return semVer;
    }

    private Map<String, String> toMap(Config config) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map.Entry entry : config.entrySet()) {
            if (((ConfigValue)entry.getValue()).valueType() == ConfigValueType.STRING) {
                map.put((String)entry.getKey(), (String)((ConfigValue)entry.getValue()).unwrapped());
                continue;
            }
            map.put((String)entry.getKey(), String.valueOf(((ConfigValue)entry.getValue()).unwrapped()));
        }
        return map;
    }

    public UpdateSource getSource(String source) {
        return this.sources.get(source.toUpperCase(Locale.ROOT));
    }

    private void addSource(UpdateSource source) {
        if (this.sources.putIfAbsent(source.getName().toUpperCase(Locale.ROOT), source) != null) {
            throw new IllegalStateException("There is already a source with the name " + source.getName() + " registered!");
        }
        this.log(Level.FINE, "Added " + String.valueOf((Object)source.getType()) + " source " + source.getName(), new Throwable[0]);
    }

    private PluginConfig getPlugin(String plugin) {
        return this.plugins.get(plugin.toUpperCase(Locale.ROOT));
    }

    private String getInstalledVersion(PluginConfig plugin) {
        ConfigValue value;
        String pluginKey = plugin.getName().toLowerCase(Locale.ROOT);
        if (this.versions.hasPath("plugins." + pluginKey) && (value = this.versions.getValue("plugins." + pluginKey)).valueType() == ConfigValueType.STRING) {
            return (String)value.unwrapped();
        }
        return null;
    }

    private void setInstalledVersion(PluginConfig plugin, String version) {
        this.versions = this.versions.withValue("plugins." + plugin.getName().toLowerCase(Locale.ROOT), ConfigValueFactory.fromAnyRef((Object)version));
    }

    private void saveInstalledVersions() throws IOException {
        File versionsFile = new File(this.getTargetFolder(), "versions.conf");
        if (!versionsFile.exists()) {
            versionsFile.createNewFile();
        }
        try (FileWriter writer = new FileWriter(versionsFile);){
            writer.write(this.versions.resolve().root().render(ConfigRenderOptions.defaults().setOriginComments(false)));
        }
    }

    private boolean addPlugin(PluginConfig plugin) {
        ArrayList<String> requiredParameters = new ArrayList<String>();
        for (String requiredParameter : plugin.getSource().getRequiredParameters()) {
            if (plugin.getParameters().containsKey(requiredParameter)) continue;
            requiredParameters.add(requiredParameter);
        }
        if (!requiredParameters.isEmpty()) {
            this.log(Level.SEVERE, "Plugin " + plugin.getName() + " does not specify all parameters that are required by " + String.valueOf((Object)plugin.getSource().getType()) + " source " + plugin.getSource().getName() + "! The following parameters are missing: " + String.join((CharSequence)", ", requiredParameters), new Throwable[0]);
            return false;
        }
        if (plugin.getSource().getType() == SourceType.SPIGOT) {
            this.log(Level.WARNING, "Automatic downloading from SpigotMC.org will most likely fail due to Cloudflare. If the plugin has a GitHub release it will be used though.", new Throwable[0]);
        }
        this.plugins.put(plugin.getName().toUpperCase(Locale.ROOT), plugin);
        this.log(Level.FINE, "Added plugin " + plugin.getName() + " from " + String.valueOf((Object)plugin.getSource().getType()) + " source " + plugin.getSource().getName(), new Throwable[0]);
        return true;
    }

    private Config getConfig(String name) {
        return this.getConfig(new File(name + ".conf"));
    }

    private Config getConfig(File file) {
        this.saveResource(file);
        try {
            return ConfigFactory.parseFile((File)file);
        }
        catch (ConfigException e) {
            this.log(Level.SEVERE, "Error while loading " + file.getPath() + " config!", e);
            return ConfigFactory.empty((String)"Empty config due to error loading file!");
        }
    }

    private void saveResource(File file) {
        InputStream inputStream = this.getClass().getResourceAsStream("/" + file.getName());
        if (inputStream != null) {
            if (!file.exists()) {
                try {
                    Files.copy(inputStream, file.toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.log(Level.WARNING, "No resource " + file.getName() + " found!", new Throwable[0]);
        }
    }

    private File getTargetFolder() {
        return this.targetFolder;
    }

    protected Level getLogLevel() {
        return this.logLevel;
    }

    public abstract void log(Level var1, String var2, Throwable ... var3);

    public abstract File getTempFolder();

    protected abstract boolean getDontLink();

    public abstract String getName();

    public abstract String getVersion();

    public String query(URL url, String ... properties) {
        return (String)this.queryCache.get((Object)url, u -> {
            try {
                HttpURLConnection con = (HttpURLConnection)u.openConnection();
                con.setRequestProperty("User-Agent", this.getUserAgent());
                int i = 0;
                while (i + 1 < properties.length) {
                    con.addRequestProperty(properties[i], properties[i + 1]);
                    i += 2;
                }
                StringBuilder msg = new StringBuilder();
                con.setUseCaches(false);
                con.connect();
                if (con.getResponseCode() == 200) {
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                        String line;
                        while ((line = in.readLine()) != null) {
                            if (msg.length() != 0) {
                                msg.append("\n");
                            }
                            msg.append(line);
                        }
                    }
                    return msg.toString();
                }
                this.log(Level.WARNING, con.getResponseCode() + "/" + con.getResponseMessage() + " while trying to query url " + url.toString(), new Throwable[0]);
            }
            catch (IOException e) {
                this.log(Level.SEVERE, "Error while trying to query url " + url.toString() + ".", e);
            }
            return null;
        });
    }

    public String getUserAgent() {
        return this.getName() + "/" + this.getVersion();
    }
}

