/*
 * Decompiled with CFR 0.152.
 */
package dev.phoenix616.updater;

import de.themoep.minedown.adventure.Replacer;
import dev.phoenix616.updater.Updater;
import dev.phoenix616.updater.sources.UpdateSource;
import java.util.LinkedHashMap;
import java.util.Map;

public class PluginConfig {
    private String name;
    private UpdateSource source;
    private String fileNameFormat;
    private Map<String, String> parameters;

    public PluginConfig(String name, UpdateSource source, String fileNameFormat, Map<String, String> parameters) {
        this.name = name;
        this.source = source;
        this.fileNameFormat = fileNameFormat;
        this.parameters = new LinkedHashMap<String, String>(parameters);
        this.parameters.putIfAbsent("name", name);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Deprecated
    public Map<String, String> getPlaceholders() {
        return this.getParameters();
    }

    public Map<String, String> getParameters(String nameFallback) {
        if (this.getParameters().containsKey(nameFallback)) {
            return this.getParameters();
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(this.getParameters());
        parameters.put(nameFallback, this.getName());
        return parameters;
    }

    public String getFileName(String version) {
        return Replacer.replaceIn((String)this.fileNameFormat, (String[])new String[]{"name", this.name, "version", Updater.sanitize(version), "rawversion", version});
    }

    public String getName() {
        return this.name;
    }

    public UpdateSource getSource() {
        return this.source;
    }
}

