/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import com.destroystokyo.paper.SkinParts;
import net.kyori.adventure.translation.Translatable;
import net.kyori.adventure.util.Index;
import org.bukkit.inventory.MainHand;
import org.jetbrains.annotations.NotNull;

public final class ClientOption<T> {
    public static final ClientOption<SkinParts> SKIN_PARTS = new ClientOption<SkinParts>(SkinParts.class);
    public static final ClientOption<Boolean> CHAT_COLORS_ENABLED = new ClientOption<Boolean>(Boolean.class);
    public static final ClientOption<ChatVisibility> CHAT_VISIBILITY = new ClientOption<ChatVisibility>(ChatVisibility.class);
    public static final ClientOption<String> LOCALE = new ClientOption<String>(String.class);
    public static final ClientOption<MainHand> MAIN_HAND = new ClientOption<MainHand>(MainHand.class);
    public static final ClientOption<Integer> VIEW_DISTANCE = new ClientOption<Integer>(Integer.class);
    public static final ClientOption<Boolean> ALLOW_SERVER_LISTINGS = new ClientOption<Boolean>(Boolean.class);
    public static final ClientOption<Boolean> TEXT_FILTERING_ENABLED = new ClientOption<Boolean>(Boolean.class);
    private final Class<T> type;

    private ClientOption(@NotNull Class<T> type) {
        this.type = type;
    }

    @NotNull
    public Class<T> getType() {
        return this.type;
    }

    public static enum ChatVisibility implements Translatable
    {
        FULL("full"),
        SYSTEM("system"),
        HIDDEN("hidden"),
        UNKNOWN("unknown");

        public static Index<String, ChatVisibility> NAMES;
        private final String name;

        private ChatVisibility(String name) {
            this.name = name;
        }

        @NotNull
        public String translationKey() {
            if (this == UNKNOWN) {
                throw new UnsupportedOperationException(this.name + " doesn't have a translation key");
            }
            return "options.chat.visibility." + this.name;
        }

        static {
            NAMES = Index.create(ChatVisibility.class, chatVisibility -> chatVisibility.name);
        }
    }
}

