/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.utils.lang.sponge;

import com.google.common.reflect.TypeToken;
import de.themoep.utils.lang.LanguageConfig;
import de.themoep.utils.lang.sponge.Languaged;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ValueType;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.yaml.YAMLConfigurationLoader;
import org.spongepowered.api.text.format.TextColors;

public class SpongeLanguageConfig
extends LanguageConfig<ConfigurationNode> {
    private static final Pattern KEY_PATTERN = Pattern.compile("\\.");
    private final Languaged plugin;

    public SpongeLanguageConfig(Languaged plugin, String resourceFolder, File configFile, String locale) {
        this(plugin, resourceFolder, configFile, locale, true);
    }

    public SpongeLanguageConfig(Languaged plugin, String resourceFolder, File configFile, String locale, boolean saveFile) {
        super(resourceFolder, configFile, locale, saveFile);
        this.plugin = plugin;
        this.saveConfigResource();
        this.loadConfig();
    }

    public void loadConfig() {
        if (this.configFile != null && this.configFile.exists()) {
            try {
                this.config = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setIndent(2).setPath(this.configFile.toPath())).build().load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean saveConfigResource() {
        block15: {
            try (InputStream in = this.plugin.getResourceAsStream(this.resourcePath);){
                if (in == null) {
                    if (Boolean.getBoolean("de.themoep.lang.debug")) {
                        this.plugin.getLangLogger().log(Level.WARNING, "No default config '" + this.resourcePath + "' found in " + this.plugin.getName() + "!");
                    }
                    boolean bl = false;
                    return bl;
                }
                this.defaultConfig = this.config = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setIndent(2).setSource(() -> new BufferedReader(new InputStreamReader(in)))).build().load();
                if (!this.saveFile || this.configFile.exists()) break block15;
                File parent = this.configFile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                try {
                    Files.copy(in, this.configFile.toPath(), new CopyOption[0]);
                    boolean bl = true;
                    return bl;
                }
                catch (IOException ex) {
                    this.plugin.getLangLogger().log(Level.SEVERE, "Could not save " + this.configFile.getName() + " to " + this.configFile, (Throwable)ex);
                }
            }
            catch (IOException ex) {
                this.plugin.getLangLogger().log(Level.SEVERE, "Could not load default config from " + this.resourcePath, (Throwable)ex);
            }
        }
        return false;
    }

    public boolean contains(String key) {
        return this.contains(key, false);
    }

    public boolean contains(String key, boolean checkDefault) {
        return !((ConfigurationNode)this.config).getNode(SpongeLanguageConfig.splitKey(key)).isVirtual() || checkDefault && this.defaultConfig != null && !((ConfigurationNode)this.defaultConfig).getNode(SpongeLanguageConfig.splitKey(key)).isVirtual();
    }

    public String get(String key) {
        ConfigurationNode o = ((ConfigurationNode)this.config).getNode(SpongeLanguageConfig.splitKey(key));
        if (o.isVirtual() && this.defaultConfig != null) {
            o = ((ConfigurationNode)this.defaultConfig).getNode(SpongeLanguageConfig.splitKey(key));
        }
        String string = null;
        if (o.getValueType() == ValueType.LIST) {
            try {
                List stringList = o.getList(TypeToken.of(String.class));
                string = String.join((CharSequence)"\n", stringList);
            }
            catch (ObjectMappingException e) {
                e.printStackTrace();
            }
        } else {
            string = o.getString();
        }
        if (string == null) {
            return TextColors.RED + "Missing language key " + TextColors.YELLOW + key + TextColors.RED + " for locale " + TextColors.YELLOW + this.getLocale();
        }
        return string;
    }

    public ConfigurationNode getRawConfig() {
        return (ConfigurationNode)this.config;
    }

    private static Object[] splitKey(String key) {
        return KEY_PATTERN.split(key);
    }
}

