/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.utils.lang.sponge;

import de.themoep.utils.lang.LanguageConfig;
import de.themoep.utils.lang.LanguageManagerCore;
import de.themoep.utils.lang.sponge.Languaged;
import de.themoep.utils.lang.sponge.SpongeLanguageConfig;
import java.io.File;
import ninja.leaping.configurate.ConfigurationNode;
import org.spongepowered.api.command.CommandSource;

public class LanguageManager
extends LanguageManagerCore<CommandSource, ConfigurationNode> {
    private final Languaged plugin;

    public LanguageManager(Languaged plugin, String defaultLocale, SpongeLanguageConfig ... configs) {
        this(plugin, "languages", defaultLocale, configs);
    }

    public LanguageManager(Languaged plugin, String defaultLocale, boolean saveFiles, SpongeLanguageConfig ... configs) {
        this(plugin, "languages", "languages", defaultLocale, saveFiles, configs);
    }

    public LanguageManager(Languaged plugin, String folder, String defaultLocale, SpongeLanguageConfig ... configs) {
        this(plugin, folder, folder, defaultLocale, configs);
    }

    public LanguageManager(Languaged plugin, String resourceFolder, String folder, String defaultLocale, SpongeLanguageConfig ... configs) {
        this(plugin, resourceFolder, folder, defaultLocale, true, configs);
    }

    public LanguageManager(Languaged plugin, String resourceFolder, String folder, String defaultLocale, boolean saveFiles, SpongeLanguageConfig ... configs) {
        super(defaultLocale, resourceFolder, new File(plugin.getDataFolder(), folder), sender -> sender.getLocale().getLanguage().replace('-', '_'), "lang.", ".yml", saveFiles, (LanguageConfig[])configs);
        this.plugin = plugin;
        this.loadConfigs();
    }

    public void loadConfigs() {
        this.loadConfigs(this.plugin.getClass(), this.plugin.getLangLogger(), locale -> new SpongeLanguageConfig(this.plugin, this.getResourceFolder(), new File(this.getFolder(), this.filePrefix + locale + this.fileSuffix), (String)locale, this.saveFiles));
    }
}

