/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.specialitems.listeners;

import de.themoep.specialitems.SpecialItem;
import de.themoep.specialitems.SpecialItems;
import de.themoep.specialitems.actions.TargetedTrigger;
import de.themoep.specialitems.actions.Trigger;
import de.themoep.specialitems.actions.TriggerType;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ActionTriggerListener
implements Listener {
    private final SpecialItems plugin;

    public ActionTriggerListener(SpecialItems plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Material clicked;
        Material mainHand;
        if (!event.hasItem()) {
            return;
        }
        TriggerType triggerType = TriggerType.UNSUPPORTED;
        switch (event.getAction()) {
            case RIGHT_CLICK_AIR: {
                triggerType = TriggerType.RIGHT_CLICK_AIR;
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                triggerType = TriggerType.RIGHT_CLICK_BLOCK;
                break;
            }
            case LEFT_CLICK_AIR: {
                triggerType = TriggerType.LEFT_CLICK_AIR;
                break;
            }
            case LEFT_CLICK_BLOCK: {
                triggerType = TriggerType.LEFT_CLICK_BLOCK;
            }
        }
        if (triggerType == TriggerType.UNSUPPORTED) {
            return;
        }
        if (event.getHand() == EquipmentSlot.OFF_HAND ? (mainHand = event.getPlayer().getInventory().getItemInMainHand().getType()) == Material.CROSSBOW : event.getHand() == EquipmentSlot.HAND && event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock() != null && (clicked = event.getClickedBlock().getType()).isInteractable() && !event.getPlayer().isSneaking()) {
            return;
        }
        Trigger trigger = triggerType.isChildOf(TriggerType.CLICK_BLOCK) ? new TargetedTrigger((Event)event, event.getPlayer(), event.getClickedBlock(), event.getItem(), triggerType) : new Trigger((Event)event, event.getPlayer(), event.getItem(), triggerType);
        this.plugin.getItemManager().executeActions(trigger);
        if (trigger.shouldRemoveItem() && event.getHand() != null) {
            ItemStack item = this.removeOne(trigger.getItem());
            switch (event.getHand()) {
                case HAND: {
                    event.getPlayer().getInventory().setItem(event.getPlayer().getInventory().getHeldItemSlot(), item);
                    break;
                }
                case OFF_HAND: {
                    event.getPlayer().getInventory().setItemInOffHand(item);
                    break;
                }
                case HEAD: {
                    event.getPlayer().getInventory().setHelmet(item);
                    break;
                }
                case CHEST: {
                    event.getPlayer().getInventory().setChestplate(item);
                    break;
                }
                case LEGS: {
                    event.getPlayer().getInventory().setLeggings(item);
                    break;
                }
                case FEET: {
                    event.getPlayer().getInventory().setBoots(item);
                }
            }
            event.getPlayer().updateInventory();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInventoryClick(InventoryClickEvent event) {
        if (event.getCurrentItem() == null || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        TriggerType triggerType = TriggerType.UNSUPPORTED;
        switch (event.getClick()) {
            case LEFT: {
                triggerType = TriggerType.LEFT_CLICK_INV;
                break;
            }
            case SHIFT_LEFT: {
                triggerType = TriggerType.SHIFT_LEFT_CLICK_INV;
                break;
            }
            case RIGHT: {
                triggerType = TriggerType.RIGHT_CLICK_INV;
                break;
            }
            case SHIFT_RIGHT: {
                triggerType = TriggerType.SHIFT_RIGHT_CLICK_INV;
                break;
            }
            case MIDDLE: {
                triggerType = TriggerType.MIDDLE_CLICK_INV;
                break;
            }
            case DOUBLE_CLICK: {
                triggerType = TriggerType.DOUBLE_CLICK_INV;
                break;
            }
            case DROP: {
                triggerType = TriggerType.DROP_INV;
                break;
            }
            case CONTROL_DROP: {
                triggerType = TriggerType.CONTROL_DROP_INV;
                break;
            }
            case WINDOW_BORDER_LEFT: {
                triggerType = TriggerType.LEFT_BORDER_INV;
                break;
            }
            case WINDOW_BORDER_RIGHT: {
                triggerType = TriggerType.RIGHT_BORDER_INV;
                break;
            }
            case NUMBER_KEY: {
                triggerType = TriggerType.valueOf("NUMBER_KEY_" + (event.getHotbarButton() + 1) + "_INV");
            }
        }
        if (triggerType == TriggerType.UNSUPPORTED) {
            return;
        }
        Trigger trigger = new Trigger((Event)event, (Player)event.getWhoClicked(), event.getCurrentItem(), triggerType);
        this.plugin.getItemManager().executeActions(trigger);
        if (trigger.shouldRemoveItem()) {
            event.setCurrentItem(this.removeOne(trigger.getItem()));
            ((Player)event.getWhoClicked()).updateInventory();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemDrop(PlayerDropItemEvent event) {
        Trigger trigger = new Trigger((Event)event, event.getPlayer(), event.getItemDrop().getItemStack(), TriggerType.DROP);
        this.plugin.getItemManager().executeActions(trigger);
        if (trigger.shouldRemoveItem()) {
            event.getItemDrop().remove();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemConsume(PlayerItemConsumeEvent event) {
        Trigger trigger = new Trigger((Event)event, event.getPlayer(), event.getItem(), TriggerType.CONSUME);
        this.plugin.getItemManager().executeActions(trigger);
        if (trigger.shouldRemoveItem()) {
            event.getPlayer().getInventory().setItemInMainHand(this.removeOne(trigger.getItem()));
            event.getPlayer().updateInventory();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemCraft(CraftItemEvent event) {
        Trigger trigger = new Trigger((Event)event, (Player)event.getWhoClicked(), event.getRecipe().getResult(), TriggerType.CRAFT);
        this.plugin.getItemManager().executeActions(trigger);
        if (trigger.shouldRemoveItem()) {
            event.setCurrentItem(this.removeOne(trigger.getItem()));
            ((Player)event.getWhoClicked()).updateInventory();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onArrowShoot(ProjectileLaunchEvent event) {
        if (event.getEntity().getShooter() instanceof Player) {
            Player player = (Player)event.getEntity().getShooter();
            Trigger trigger = new Trigger((Event)event, player, player.getInventory().getItemInMainHand(), TriggerType.SHOOT_PROJECTILE);
            this.plugin.getItemManager().executeActions(trigger);
            if (trigger.hasSpecialItem()) {
                event.getEntity().setMetadata("SpecialItemsShooter", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)trigger.getSpecialItem().getId()));
            }
            if (trigger.shouldRemoveItem()) {
                player.getInventory().setItemInMainHand(this.removeOne(trigger.getItem()));
                player.updateInventory();
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onArrowHit(ProjectileHitEvent event) {
        if (event.getEntity().getShooter() instanceof Player) {
            SpecialItem item = null;
            if (event.getEntity().hasMetadata("SpecialItemsShooter")) {
                for (MetadataValue value : event.getEntity().getMetadata("SpecialItemsShooter")) {
                    SpecialItem shotItem = this.plugin.getItemManager().getSpecialItem(value.asString());
                    if (shotItem == null) continue;
                    item = shotItem;
                    break;
                }
            }
            if (item != null) {
                Player player = (Player)event.getEntity().getShooter();
                TargetedTrigger trigger = new TargetedTrigger((Event)event, player, (Entity)event.getEntity(), item, TriggerType.PROJECTILE_HIT_BLOCK);
                this.plugin.getItemManager().executeActions(trigger);
                if (trigger.shouldRemoveItem()) {
                    item.removeFromInv((Inventory)player.getInventory(), 1);
                    player.updateInventory();
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerAttackEntity(EntityDamageByEntityEvent event) {
        Player player = null;
        TriggerType triggerType = TriggerType.UNSUPPORTED;
        SpecialItem item = null;
        if (event.getDamager() instanceof Player) {
            player = (Player)event.getDamager();
            triggerType = event.getEntity() instanceof Player ? TriggerType.ATTACK_PLAYER : TriggerType.ATTACK_ENTITY;
            try {
                item = this.plugin.getItemManager().getSpecialItem(player.getInventory().getItemInMainHand());
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().log(Level.WARNING, player.getName() + " has an invalid SpecialItem?", e);
            }
        } else if (event.getDamager() instanceof Projectile && ((Projectile)event.getDamager()).getShooter() instanceof Player) {
            player = (Player)((Projectile)event.getDamager()).getShooter();
            TriggerType triggerType2 = triggerType = event.getEntity() instanceof Player ? TriggerType.PROJECTILE_HIT_PLAYER : TriggerType.PROJECTILE_HIT_ENTITY;
            if (event.getEntity().hasMetadata("SpecialItemsShooter")) {
                for (MetadataValue value : event.getEntity().getMetadata("SpecialItemsShooter")) {
                    SpecialItem shotItem = this.plugin.getItemManager().getSpecialItem(value.asString());
                    if (shotItem == null) continue;
                    item = shotItem;
                    break;
                }
            }
        }
        if (item != null) {
            TargetedTrigger trigger = new TargetedTrigger((Event)event, player, event.getEntity(), item, triggerType);
            this.plugin.getItemManager().executeActions(trigger);
            if (trigger.shouldRemoveItem()) {
                item.removeFromInv((Inventory)player.getInventory(), 1);
                player.updateInventory();
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteractWithEntity(PlayerInteractEntityEvent event) {
        TriggerType triggerType = event.getRightClicked() instanceof Player ? TriggerType.RIGHT_CLICK_PLAYER : TriggerType.RIGHT_CLICK_ENTITY;
        TargetedTrigger trigger = new TargetedTrigger((Event)event, event.getPlayer(), event.getRightClicked(), event.getPlayer().getInventory().getItemInMainHand(), triggerType);
        this.plugin.getItemManager().executeActions(trigger);
        if (trigger.shouldRemoveItem() && event.getHand() != null) {
            switch (event.getHand()) {
                case HAND: {
                    event.getPlayer().getInventory().setItem(event.getPlayer().getInventory().getHeldItemSlot(), this.removeOne(event.getPlayer().getInventory().getItemInMainHand()));
                    break;
                }
                case OFF_HAND: {
                    event.getPlayer().getInventory().setItemInOffHand(this.removeOne(event.getPlayer().getInventory().getItemInOffHand()));
                    break;
                }
                case HEAD: {
                    event.getPlayer().getInventory().setHelmet(this.removeOne(event.getPlayer().getInventory().getHelmet()));
                    break;
                }
                case CHEST: {
                    event.getPlayer().getInventory().setChestplate(this.removeOne(event.getPlayer().getInventory().getChestplate()));
                    break;
                }
                case LEGS: {
                    event.getPlayer().getInventory().setLeggings(this.removeOne(event.getPlayer().getInventory().getLeggings()));
                    break;
                }
                case FEET: {
                    event.getPlayer().getInventory().setBoots(this.removeOne(event.getPlayer().getInventory().getBoots()));
                }
            }
            event.getPlayer().updateInventory();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Trigger trigger = new Trigger((Event)event, event.getPlayer(), event.getItemInHand(), TriggerType.BLOCK_PLACE);
        this.plugin.getItemManager().executeActions(trigger);
        if (trigger.wasExecuted()) {
            if (trigger.shouldRemoveItem()) {
                event.getPlayer().getInventory().setItemInMainHand(this.removeOne(event.getPlayer().getInventory().getItemInMainHand()));
                event.getPlayer().updateInventory();
            }
        } else if (trigger.getSpecialItem() != null) {
            event.setCancelled(true);
        }
    }

    private ItemStack removeOne(ItemStack item) {
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        } else {
            item = null;
        }
        return item;
    }
}

