/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.specialitems.actions;

import de.themoep.specialitems.SpecialItem;
import de.themoep.specialitems.actions.Trigger;
import de.themoep.specialitems.actions.TriggerType;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class TargetedTrigger
extends Trigger {
    private TriggerTarget target;

    public TargetedTrigger(Event event, Player player, Entity target, ItemStack item, TriggerType type) {
        super(event, player, item, type);
        this.target = new TriggerTarget(target);
    }

    public TargetedTrigger(Event event, Player player, Entity target, SpecialItem item, TriggerType type) {
        super(event, player, item, type);
        this.target = new TriggerTarget(target);
    }

    public TargetedTrigger(Event event, Player player, Block target, ItemStack item, TriggerType type) {
        super(event, player, item, type);
        this.target = new TriggerTarget(target);
    }

    public TriggerTarget getTarget() {
        return this.target;
    }

    public class TriggerTarget {
        private String name;
        private Location location;
        private Location eyeLocation;

        public TriggerTarget(Entity target) {
            this.name = target.getType() == EntityType.PLAYER ? target.getName() : target.getType() + ":" + target.getName();
            this.location = target.getLocation();
            this.eyeLocation = target instanceof LivingEntity ? ((LivingEntity)target).getEyeLocation() : this.location;
        }

        public TriggerTarget(Block target) {
            this.name = "BLOCK:" + target.getType().toString();
            this.eyeLocation = this.location = target.getLocation();
        }

        public String getName() {
            return this.name;
        }

        public Location getLocation() {
            return this.location;
        }

        public Location getEyeLocation() {
            return this.eyeLocation;
        }
    }
}

