/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.specialitems.actions;

import de.themoep.specialitems.SpecialItems;
import de.themoep.specialitems.actions.ItemActionType;
import de.themoep.specialitems.actions.TargetedTrigger;
import de.themoep.specialitems.actions.Trigger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class ItemAction {
    private final ItemActionType type;
    private final String value;

    public ItemAction(ItemActionType type) throws IllegalArgumentException {
        this(type, "");
    }

    public ItemAction(ItemActionType type, String value) throws IllegalArgumentException {
        this.type = type;
        this.value = value;
        if (this.getType().requiresValue() && !this.hasValue()) {
            throw new IllegalArgumentException("ActionType " + (Object)((Object)this.getType()) + " requires an additional value! (Add it with a space after the type in the config)");
        }
        String[] values = this.getValue().split(" ");
        if (this.getType() == ItemActionType.LAUNCH_PROJECTILE) {
            try {
                Class<?> clazz = Class.forName("org.bukkit.entity." + values[0]);
                if (!Projectile.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException("Error while loading action with type " + (Object)((Object)this.getType()) + "! The string " + values[0] + " is not a valid projectile class name! (Value: " + this.getValue() + ")");
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Error while loading action with type " + (Object)((Object)this.getType()) + "! The string " + values[0] + " is not a valid projectile class name! (Value: " + this.getValue() + ")");
            }
            if (values.length > 1) {
                try {
                    Double.parseDouble(values[1]);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Error while loading action with type " + (Object)((Object)this.getType()) + "! The string " + values[1] + " is not a valid double! (Value: " + this.getValue() + ")");
                }
            }
        } else if (this.getType() == ItemActionType.EFFECT) {
            int i = 0;
            if (values.length < 2) {
                throw new IllegalArgumentException("Error while loading action with type " + (Object)((Object)this.getType()) + "! The not enough value parts! " + values.length + ", needs at least 2 (Value: " + this.getValue() + ")");
            }
            PotionEffectType potionType = PotionEffectType.getByName((String)values[i]);
            if (potionType == null) {
                potionType = PotionEffectType.getByName((String)values[++i]);
            }
            if (potionType == null) {
                throw new IllegalArgumentException("Error while loading action with type " + (Object)((Object)this.getType()) + "! Neither " + values[0] + " nor " + values[1] + " are potion effects! (Value: " + this.getValue() + ")");
            }
            if (values.length > i + 1) {
                try {
                    Integer.parseInt(values[i + 1]);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Error while loading action with type " + (Object)((Object)this.getType()) + "!" + values[i + 1] + " is not a valid duration integer! (Value: " + this.getValue() + ")");
                }
            }
            if (values.length > i + 2) {
                try {
                    Integer.parseInt(values[i + 2]);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Error while loading action with type " + (Object)((Object)this.getType()) + "!" + values[i + 2] + " is not a valid amplifier integer! (Value: " + this.getValue() + ")");
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ItemAction fromString(String string) {
        String[] splitArgs = string.split(" ");
        ItemActionType actionType = ItemActionType.valueOf(splitArgs[0].toUpperCase());
        if (!actionType.requiresValue()) return new ItemAction(actionType);
        if (splitArgs.length <= 1) throw new IllegalArgumentException("ActionType " + (Object)((Object)actionType) + " requires an additional value! (Add it with a space after the type in the config)");
        StringBuilder value = new StringBuilder(splitArgs[1]);
        int i = 2;
        while (i < splitArgs.length) {
            value.append(" ").append(splitArgs[i]);
            ++i;
        }
        return new ItemAction(actionType, value.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getType().toString());
        if (this.hasValue()) {
            sb.append(' ').append(this.getValue());
        }
        return sb.toString();
    }

    public ItemActionType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(Trigger trigger) {
        Location targetLocation;
        String value = this.getValue();
        if (value.indexOf(37) == -1) {
            return value;
        }
        Player player = trigger.getPlayer();
        ArrayList<String> repl = new ArrayList<String>(Arrays.asList("trigger", trigger.getType().toString(), "player", player.getName(), "world", player.getLocation().getWorld().getName(), "x", String.valueOf(player.getLocation().getBlockX()), "y", String.valueOf(player.getLocation().getBlockY()), "z", String.valueOf(player.getLocation().getBlockZ()), "x.exact", String.valueOf(player.getLocation().getX()), "y.exact", String.valueOf(player.getLocation().getY()), "z.exact", String.valueOf(player.getLocation().getZ()), "eye.x", String.valueOf(player.getEyeLocation().getBlockX()), "eye.y", String.valueOf(player.getEyeLocation().getBlockY()), "eye.z", String.valueOf(player.getEyeLocation().getBlockZ()), "eye.x.exact", String.valueOf(player.getEyeLocation().getX()), "eye.y.exact", String.valueOf(player.getEyeLocation().getY()), "eye.z.exact", String.valueOf(player.getEyeLocation().getZ()), "pitch", String.valueOf(player.getEyeLocation().getPitch()), "yaw", String.valueOf(player.getEyeLocation().getYaw())));
        if (trigger instanceof TargetedTrigger) {
            TargetedTrigger targetedTrigger = (TargetedTrigger)trigger;
            targetLocation = targetedTrigger.getTarget().getLocation();
            Location targetEyeLocation = targetedTrigger.getTarget().getEyeLocation();
            repl.addAll(Arrays.asList("target.name", targetedTrigger.getTarget().getName(), "target.world", targetedTrigger.getTarget().getLocation().getWorld().getName(), "target.x", String.valueOf(targetLocation.getBlockX()), "target.y", String.valueOf(targetLocation.getBlockY()), "target.z", String.valueOf(targetLocation.getBlockZ()), "target.x.exact", String.valueOf(targetLocation.getX()), "target.y.exact", String.valueOf(targetLocation.getY()), "target.z.exact", String.valueOf(targetLocation.getZ()), "target.eye.x", String.valueOf(targetEyeLocation.getBlockX()), "target.eye.y", String.valueOf(targetEyeLocation.getBlockY()), "target.eye.z", String.valueOf(targetEyeLocation.getBlockZ()), "target.eye.x.exact", String.valueOf(targetEyeLocation.getX()), "target.eye.y.exact", String.valueOf(targetEyeLocation.getY()), "target.eye.z.exact", String.valueOf(targetEyeLocation.getZ()), "target.pitch", String.valueOf(targetEyeLocation.getPitch()), "target.yaw", String.valueOf(targetEyeLocation.getYaw())));
        } else if (value.contains("%target.")) {
            Entity target = null;
            targetLocation = null;
            String targetName = "BLOCK";
            int checkDistance = 64;
            double nearest = checkDistance * checkDistance;
            double directest = 0.0;
            for (Entity e : player.getNearbyEntities((double)checkDistance, (double)checkDistance, (double)checkDistance)) {
                double distance;
                Vector toEntity = e.getLocation().toVector().subtract(player.getEyeLocation().toVector());
                double dot = toEntity.normalize().dot(player.getEyeLocation().getDirection());
                if (!(dot > directest) || !((distance = player.getLocation().distanceSquared(e.getLocation())) <= nearest) && !(dot - 0.1 > directest) || !player.hasLineOfSight(e)) continue;
                nearest = distance;
                directest = dot;
                target = e;
            }
            if (target != null) {
                targetLocation = target.getLocation();
                targetName = target instanceof Player ? target.getName() : target.getType() + ":" + target.getName();
            } else {
                Block block = player.getTargetBlock((Set)null, checkDistance);
                if (block != null && block.getType() != Material.AIR) {
                    targetLocation = block.getLocation();
                    targetName = "BLOCK:" + block.getType();
                }
            }
            if (targetLocation != null) {
                repl.addAll(Arrays.asList("target.name", targetName, "target.world", targetLocation.getWorld().getName(), "target.x", String.valueOf(targetLocation.getBlockX()), "target.y", String.valueOf(targetLocation.getBlockY()), "target.z", String.valueOf(targetLocation.getBlockZ()), "target.x.exact", String.valueOf(targetLocation.getX()), "target.y.exact", String.valueOf(targetLocation.getY()), "target.z.exact", String.valueOf(targetLocation.getZ()), "target.pitch", String.valueOf(targetLocation.getPitch()), "target.yaw", String.valueOf(targetLocation.getYaw())));
            }
        }
        int i = 0;
        while (i + 1 < repl.size()) {
            value = value.replace("%" + (String)repl.get(i) + "%", (CharSequence)repl.get(i + 1));
            i += 2;
        }
        return value;
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger execute(Trigger trigger) throws IllegalArgumentException {
        trigger.setExecuted(true);
        Player player = trigger.getPlayer();
        trigger.setCancel(true);
        String[] values = new String[]{};
        if (this.hasValue()) {
            values = this.getValue(trigger).split(" ");
        }
        switch (this.getType()) {
            case OPEN_CRAFTING: {
                player.closeInventory();
                player.openWorkbench(null, true);
                break;
            }
            case OPEN_ENDERCHEST: {
                player.closeInventory();
                player.openInventory(player.getEnderChest());
                break;
            }
            case OPEN_ENCHANTING: {
                player.closeInventory();
                player.openEnchanting(null, true);
                break;
            }
            case OPEN_ANVIL: {
                player.closeInventory();
                player.openInventory(player.getServer().createInventory(null, InventoryType.ANVIL));
                break;
            }
            case CLOSE_INV: {
                player.closeInventory();
                break;
            }
            case CLEAR_EFFECTS: {
                for (PotionEffect effect : player.getActivePotionEffects()) {
                    player.removePotionEffect(effect.getType());
                }
                break;
            }
            case EFFECT: {
                int i = 0;
                if (values.length < 2) {
                    trigger.getPlayer().sendMessage(ChatColor.RED + "The item's effect is misconfigured! (" + values.length + ", needs to be at least 2)Please contact an administrator!");
                    break;
                }
                PotionEffectType potionType = PotionEffectType.getByName((String)values[i]);
                if (potionType == null) {
                    player = trigger.getPlayer().getServer().getPlayer(values[i]);
                    if (player == null) {
                        trigger.getPlayer().sendMessage(ChatColor.RED + "No target found! (" + values[i] + ")");
                        break;
                    }
                    potionType = PotionEffectType.getByName((String)values[++i]);
                }
                if (potionType == null) {
                    trigger.getPlayer().sendMessage(ChatColor.RED + "The item's effect is misconfigured! Neiter " + values[0] + " nor " + values[1] + " are potion effects! Please contact an administrator!");
                    break;
                }
                int duration = 30;
                if (values.length > i + 1) {
                    try {
                        duration = Integer.parseInt(values[i + 1]);
                    }
                    catch (NumberFormatException e) {
                        trigger.getPlayer().sendMessage(ChatColor.RED + "The item's effect is misconfigured! " + values[i + 1] + " is not a valid duration integer! Please contact an administrator!");
                        break;
                    }
                }
                int amplifier = 0;
                if (values.length > i + 2) {
                    try {
                        amplifier = Integer.parseInt(values[i + 2]);
                    }
                    catch (NumberFormatException e) {
                        trigger.getPlayer().sendMessage(ChatColor.RED + "The item's effect is misconfigured! " + values[i + 1] + " is not a valid amplifier integer! Please contact an administrator!");
                        break;
                    }
                }
                boolean ambient = false;
                if (values.length > i + 3) {
                    ambient = Boolean.parseBoolean(values[i + 3]);
                }
                boolean particles = true;
                if (values.length > i + 4) {
                    particles = Boolean.parseBoolean(values[i + 4]);
                }
                player.addPotionEffect(new PotionEffect(potionType, duration * 20, amplifier, ambient, particles));
                break;
            }
            case LAUNCH_PROJECTILE: {
                try {
                    Class<?> projectile = Class.forName("org.bukkit.entity." + values[0]);
                    Vector dir = player.getEyeLocation().getDirection();
                    if (values.length > 1) {
                        dir.multiply(Double.parseDouble(values[1]));
                    }
                    player.launchProjectile(projectile, dir);
                }
                catch (ClassNotFoundException e) {
                    player.sendMessage(ChatColor.RED + "Internal error while trying to launch projectile due to wrong projectile class name! Please contact an administrator!");
                    e.printStackTrace();
                }
                break;
            }
            case RUN_COMMAND: {
                player.performCommand(this.getValue(trigger));
                break;
            }
            case SUDO_COMMAND: {
                PermissionAttachment permAtt = player.addAttachment((Plugin)SpecialItems.getProvidingPlugin(SpecialItems.class), "*", true);
                boolean isOp = player.isOp();
                if (!isOp) {
                    player.setOp(true);
                }
                try {
                    player.performCommand(this.getValue(trigger));
                    break;
                }
                finally {
                    if (!isOp) {
                        player.setOp(false);
                    }
                    permAtt.remove();
                }
            }
            case CONSOLE_COMMAND: {
                player.getServer().dispatchCommand((CommandSender)player.getServer().getConsoleSender(), this.getValue(trigger));
                break;
            }
            case MESSAGE: {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getValue(trigger)));
                break;
            }
            case REMOVE_ITEM: {
                trigger.setRemoveItem(true);
                break;
            }
            default: {
                trigger.setCancel(false);
            }
        }
        return trigger;
    }
}

