/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.specialitems.actions;

import de.themoep.specialitems.actions.ItemAction;
import de.themoep.specialitems.actions.Trigger;
import de.themoep.specialitems.actions.TriggerType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Cancellable;

public class ActionSet {
    private Map<TriggerType, List<ItemAction>> actionMap = new HashMap<TriggerType, List<ItemAction>>();

    public ActionSet(ConfigurationSection actionSection) throws IllegalArgumentException {
        for (String key : actionSection.getKeys(false)) {
            TriggerType triggerType = TriggerType.valueOf(key.toUpperCase());
            ArrayList<ItemAction> actionList = new ArrayList<ItemAction>();
            for (String actionString : actionSection.getStringList(key)) {
                actionList.add(ItemAction.fromString(actionString));
            }
            this.actionMap.put(triggerType, actionList);
        }
    }

    public ActionSet(String string) {
        for (String actionEntry : string.split("/")) {
            String[] actionEntryParts = actionEntry.split(":");
            if (actionEntryParts.length != 2) {
                throw new IllegalArgumentException("The string " + actionEntry + " does not represent a valid action set string of the format <trigger>:<type>[ <value...>][,<type...]!");
            }
            TriggerType triggerType = TriggerType.valueOf(actionEntryParts[0].toUpperCase());
            ArrayList<ItemAction> actionList = new ArrayList<ItemAction>();
            for (String actionString : actionEntryParts[1].split(",")) {
                actionList.add(ItemAction.fromString(actionString));
            }
            this.actionMap.put(triggerType, actionList);
        }
    }

    public List<ItemAction> getActions(TriggerType trigger) {
        List<ItemAction> actions = this.actionMap.get((Object)trigger);
        List<ItemAction> list = actions = actions != null ? actions : new ArrayList<ItemAction>();
        if (actions.size() == 0) {
            for (int i = 0; i < trigger.getParents().length && actions.size() == 0; ++i) {
                actions = this.getActions(trigger.getParents()[i]);
            }
        }
        return actions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<TriggerType, List<ItemAction>> entry : this.actionMap.entrySet()) {
            sb.append((Object)entry.getKey()).append(':');
            for (ItemAction action : entry.getValue()) {
                sb.append(action.toString()).append(',');
            }
            sb.append('/');
        }
        return sb.toString();
    }

    public Trigger execute(Trigger trigger) {
        for (ItemAction action : this.getActions(trigger.getType())) {
            action.execute(trigger);
        }
        if (trigger.shouldCancel() && trigger.getEvent() instanceof Cancellable) {
            ((Cancellable)trigger.getEvent()).setCancelled(true);
        }
        return trigger;
    }

    public int size() {
        return this.actionMap.size();
    }

    public Set<Map.Entry<TriggerType, List<ItemAction>>> entrySet() {
        return this.actionMap.entrySet();
    }
}

