/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.specialitems;

import de.themoep.specialitems.ItemGui;
import de.themoep.specialitems.ItemManager;
import de.themoep.specialitems.SpecialItemCommand;
import de.themoep.specialitems.listeners.ActionTriggerListener;
import de.themoep.specialitems.listeners.ItemCraftListener;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpecialItems
extends JavaPlugin {
    public static NamespacedKey KEY;
    private ItemManager itemManager;
    private ItemGui gui = null;

    public void onEnable() {
        KEY = new NamespacedKey((Plugin)this, "item");
        this.loadConfig();
        this.gui = new ItemGui(this);
        this.getCommand("specialitems").setExecutor((CommandExecutor)new SpecialItemCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new ItemCraftListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ActionTriggerListener(this), (Plugin)this);
    }

    protected void loadConfig() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.itemManager = new ItemManager(this);
        if (this.gui != null) {
            this.gui.destroy();
        }
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public String getLang(String key, String ... repl) {
        String msg = this.getConfig().getString("lang." + key);
        if (msg == null) {
            return this.getTag() + ChatColor.RED + ": Unknown language key " + ChatColor.GOLD + key;
        }
        int i = 0;
        while (i + 1 < repl.length) {
            msg = msg.replace("%" + repl[i] + "%", repl[i + 1]);
            i += 2;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }

    public String getTag() {
        return ChatColor.YELLOW + "[" + ChatColor.RED + this.getName() + ChatColor.YELLOW + "]" + ChatColor.RESET;
    }

    public boolean checkPerm(CommandSender sender, String permission) {
        return this.checkPerm(sender, permission, "general");
    }

    public boolean checkPerm(CommandSender sender, String permission, String type) {
        if (sender.hasPermission(permission)) {
            return true;
        }
        sender.sendMessage(this.getLang("nopermission." + type, "perm", permission));
        return false;
    }

    public ItemGui getGui() {
        return this.gui;
    }
}

