/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.specialitems;

import de.themoep.specialitems.SpecialItem;
import de.themoep.specialitems.SpecialItems;
import de.themoep.specialitems.actions.ItemAction;
import de.themoep.specialitems.actions.TriggerType;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SpecialItemCommand
implements CommandExecutor {
    private final SpecialItems plugin;

    public SpecialItemCommand(SpecialItems plugin) {
        this.plugin = plugin;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length <= 0) return false;
        if ("reload".equalsIgnoreCase(args[0])) {
            if (!this.plugin.checkPerm(sender, "specialitems.command.reload")) return true;
            this.plugin.loadConfig();
            sender.sendMessage(this.plugin.getTag() + ChatColor.YELLOW + " Config reloaded!");
            return true;
        }
        if ("list".equalsIgnoreCase(args[0])) {
            if (!this.plugin.checkPerm(sender, "specialitems.command.list")) return true;
            sender.sendMessage(ChatColor.YELLOW + "Available special items:");
            if (this.plugin.getItemManager().getSpecialItems().size() == 0) {
                sender.sendMessage(ChatColor.RED + "None");
                return true;
            }
            Iterator<SpecialItem> iterator = this.plugin.getItemManager().getSpecialItems().iterator();
            while (iterator.hasNext()) {
                SpecialItem specialItem = iterator.next();
                sender.sendMessage(ChatColor.YELLOW + "Name: " + ChatColor.RESET + specialItem.getId() + ChatColor.YELLOW + " - Displayname: " + ChatColor.RESET + ChatColor.translateAlternateColorCodes((char)'&', (String)specialItem.getName()));
            }
            return true;
        }
        if ("gui".equalsIgnoreCase(args[0])) {
            if (!this.plugin.checkPerm(sender, "specialitems.command.gui")) return true;
            Player player = null;
            if (args.length > 2) {
                if (!this.plugin.checkPerm(sender, "specialitems.command.gui.others")) return true;
                player = this.plugin.getServer().getPlayer(args[2]);
                if (player == null || !player.isOnline()) {
                    sender.sendMessage(this.plugin.getTag() + ChatColor.RED + " No player with the name " + ChatColor.YELLOW + args[2] + ChatColor.RED + " found!");
                    return true;
                }
            } else {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(ChatColor.RED + " Use /" + label + " gui <playername> to open the GUI for a player from the console!");
                    return true;
                }
                player = (Player)sender;
            }
            if (sender != player) {
                sender.sendMessage(ChatColor.YELLOW + "Opened gui for " + player.getName());
            }
            this.plugin.getGui().show(player);
            return true;
        }
        if ("get".equalsIgnoreCase(args[0])) {
            void var6_14;
            if (!this.plugin.checkPerm(sender, "specialitems.command.get")) return true;
            if (args.length <= 1) {
                sender.sendMessage(this.plugin.getTag() + ChatColor.RED + " Usage: /" + label + " get <itemname>");
                return true;
            }
            SpecialItem item = this.plugin.getItemManager().getSpecialItem(args[1]);
            if (item == null) {
                sender.sendMessage(this.plugin.getTag() + ChatColor.RED + " No item for the name " + ChatColor.YELLOW + args[1] + ChatColor.YELLOW + " configured!");
                return true;
            }
            Object var6_11 = null;
            if (args.length > 2) {
                if (!this.plugin.checkPerm(sender, "specialitems.command.give.others")) return true;
                Player player = this.plugin.getServer().getPlayer(args[2]);
                if (player == null || !player.isOnline()) {
                    sender.sendMessage(this.plugin.getTag() + ChatColor.RED + " No player with the name " + ChatColor.YELLOW + args[2] + ChatColor.RED + " found!");
                    return true;
                }
            } else {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(ChatColor.RED + " Use /" + label + " get <itemname> <playername> to give a special item to a player from the console!");
                    return true;
                }
                Player player = (Player)sender;
            }
            if (var6_14.getInventory().addItem(new ItemStack[]{item.getItem()}).size() > 0) {
                sender.sendMessage(this.plugin.getTag() + ChatColor.RED + " Could not give item as you don't have any space iny our inventory!");
                return true;
            }
            sender.sendMessage(this.plugin.getTag() + ChatColor.YELLOW + " Gave " + ChatColor.RESET + item.getItem().getItemMeta().getDisplayName() + ChatColor.YELLOW + " to " + ChatColor.RESET + var6_14.getName());
            return true;
        }
        if ("set".equals(args[0])) {
            if (!this.plugin.checkPerm(sender, "specialitems.command.set")) return true;
            if (args.length > 2) {
                void var6_19;
                SpecialItem item = this.plugin.getItemManager().getSpecialItem(args[1]);
                if (item == null) {
                    sender.sendMessage(this.plugin.getTag() + ChatColor.RED + " No item with the name " + ChatColor.YELLOW + args[1] + ChatColor.YELLOW + " found!");
                    return true;
                }
                Object var6_15 = null;
                if ("item".equalsIgnoreCase(args[2])) {
                    if (args.length > 3) {
                        try {
                            ItemStack itemStack = new ItemStack(Material.valueOf((String)args[3].toUpperCase()));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            sender.sendMessage(this.plugin.getTag() + ChatColor.RED + " No material with the name " + ChatColor.YELLOW + args[3] + ChatColor.YELLOW + " found!");
                        }
                    } else {
                        if (!(sender instanceof Player)) {
                            sender.sendMessage(this.plugin.getTag() + ChatColor.RED + " Use /" + label + " set <itemname> item <material> to set the item from the console!");
                            return true;
                        }
                        ItemStack itemStack = ((Player)sender).getInventory().getItemInHand();
                    }
                } else if ("name".equalsIgnoreCase(args[2]) || "displayname".equalsIgnoreCase(args[2])) {
                    if (args.length <= 3) {
                        sender.sendMessage(this.plugin.getTag() + ChatColor.RED + " Use /" + label + " set <itemname> displayname <name> to set the displayname!");
                        return true;
                    }
                    StringBuilder stringBuilder = new StringBuilder(args[3]);
                    for (int i = 4; i < args.length; ++i) {
                        stringBuilder.append(" ").append(args[i]);
                    }
                    String string = stringBuilder.toString();
                }
                if (var6_19 != null) {
                    this.plugin.getItemManager().setValue(item.getId(), args[2], var6_19);
                    sender.sendMessage(this.plugin.getTag() + ChatColor.YELLOW + " Set " + ChatColor.RESET + args[2] + ChatColor.YELLOW + " for " + ChatColor.RESET + item.getId() + ChatColor.YELLOW + "!");
                    return true;
                }
            }
            sender.sendMessage(this.plugin.getTag() + ChatColor.RED + " Usage: /" + label + " set <id> [name <name> | item [<material>] | <configpath> <value>]");
            return true;
        }
        if (!"info".equals(args[0])) return false;
        if (!this.plugin.checkPerm(sender, "specialitems.command.info")) return true;
        if (args.length <= 1) {
            sender.sendMessage(this.plugin.getTag() + ChatColor.RED + " Usage: /" + label + " info <itemname>");
            return true;
        }
        SpecialItem item = this.plugin.getItemManager().getSpecialItem(args[1]);
        if (item == null) {
            sender.sendMessage(this.plugin.getTag() + ChatColor.RED + " No item with the name " + ChatColor.YELLOW + args[1] + ChatColor.YELLOW + " found!");
            return true;
        }
        sender.sendMessage(new String[]{ChatColor.YELLOW + "Info for " + ChatColor.RESET + args[1] + ChatColor.YELLOW + ":", ChatColor.YELLOW + " Type: " + ChatColor.RESET + item.getItem().getType(), ChatColor.YELLOW + " Displayname: " + ChatColor.RESET + item.getName()});
        if (item.getLore().size() > 0) {
            sender.sendMessage(ChatColor.YELLOW + " Lore: ");
        }
        for (String string : item.getLore()) {
            sender.sendMessage(" - " + string);
        }
        if (item.getActionSet().size() > 0) {
            sender.sendMessage(ChatColor.YELLOW + " Actions:");
        }
        Iterator<Map.Entry<TriggerType, List<ItemAction>>> iterator = item.getActionSet().entrySet().iterator();
        block5: while (iterator.hasNext()) {
            Map.Entry<TriggerType, List<ItemAction>> entry = iterator.next();
            sender.sendMessage(" - " + (Object)((Object)entry.getKey()) + ":");
            Iterator<ItemAction> iterator2 = entry.getValue().iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block5;
                ItemAction action = iterator2.next();
                sender.sendMessage(ChatColor.GRAY + "    > " + action);
            }
            break;
        }
        return true;
    }
}

