/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.specialitems;

import de.themoep.specialitems.SpecialItems;
import de.themoep.specialitems.actions.ActionSet;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.inventory.meta.tags.ItemTagType;

public class SpecialItem {
    private String id;
    private String name;
    private ItemStack item;
    private ActionSet actions;
    private List<String> lore;

    public SpecialItem(String id, String name, ItemStack item, ActionSet actions, List<String> lore) {
        this.id = id.toLowerCase();
        this.name = name;
        this.actions = actions;
        this.lore = lore;
        this.item = this.buildItemStack(item);
    }

    public SpecialItem(SpecialItem item) {
        this(item.getId(), item.getName(), item.getItem(), item.getActionSet(), item.getLore());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public ActionSet getActionSet() {
        return this.actions;
    }

    private ItemStack buildItemStack(ItemStack item) {
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (this.getName() != null && !this.getName().isEmpty()) {
            meta.setDisplayName(ChatColor.RESET + ChatColor.translateAlternateColorCodes((char)'&', (String)this.getName()));
        }
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : this.getLore()) {
            lore.add(ChatColor.GRAY + ChatColor.translateAlternateColorCodes((char)'&', (String)line));
        }
        lore.add(ChatColor.BLUE + "" + ChatColor.ITALIC + "SpecialItems");
        meta.setLore(lore);
        CustomItemTagContainer tags = meta.getCustomTagContainer();
        tags.setCustomTag(SpecialItems.KEY, ItemTagType.STRING, (Object)this.getId());
        item.setItemMeta(meta);
        return item;
    }

    public static String getId(ItemStack item) {
        if (item != null && item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            CustomItemTagContainer tags = meta.getCustomTagContainer();
            if (tags.hasCustomTag(SpecialItems.KEY, ItemTagType.STRING)) {
                return (String)tags.getCustomTag(SpecialItems.KEY, ItemTagType.STRING);
            }
            if (meta.hasLore() && ((String)meta.getLore().get(meta.getLore().size() - 1)).contains("SpecialItems")) {
                String hidden = SpecialItem.getHiddenString(item);
                if (hidden == null) {
                    throw new IllegalArgumentException("Item should be a special item but no hidden id string was found?");
                }
                return hidden;
            }
        }
        return null;
    }

    @Deprecated
    public static String hideString(String hidden, String string) {
        for (int i = string.length() - 1; i >= 0 && string.length() - i <= 2; --i) {
            if (string.charAt(i) != '\u00a7') continue;
            string = string.substring(0, i);
        }
        char[] chars = new char[hidden.length() * 2];
        for (int i = 0; i < hidden.length(); ++i) {
            chars[i * 2] = 167;
            chars[i * 2 + 1] = hidden.charAt(i);
        }
        return string + new String(chars);
    }

    public static String getHiddenString(ItemStack item) {
        StringBuilder builder = new StringBuilder();
        if (!item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return null;
        }
        char[] chars = ((String)item.getItemMeta().getLore().get(item.getItemMeta().getLore().size() - 1)).toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\u00a7') continue;
            if (i + 1 < chars.length) {
                if (chars[i + 1] == '\u00a7' && i > 1 && chars[i - 1] == '\u00a7') {
                    builder.append(c);
                    continue;
                }
                if (builder.length() <= 0) continue;
                builder = new StringBuilder();
                continue;
            }
            if (i <= 0 || chars[i - 1] != '\u00a7') continue;
            builder.append(c);
        }
        if (builder.length() == 0) {
            return null;
        }
        return builder.toString();
    }

    public boolean isInInv(Inventory inventory) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (!this.id.equals(SpecialItem.getId(item))) continue;
            return true;
        }
        return false;
    }

    public int countInInv(Inventory inventory) {
        int amount = 0;
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (!this.id.equals(SpecialItem.getId(item))) continue;
            amount += item.getAmount();
        }
        return amount;
    }

    public boolean removeFromInv(Inventory inventory, int amount) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (!this.id.equals(SpecialItem.getId(item))) continue;
            if (item.getAmount() > amount) {
                item.setAmount(item.getAmount() - amount);
            } else {
                item = null;
            }
            inventory.setItem(i, item);
            return true;
        }
        return false;
    }
}

