/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.specialitems;

import de.themoep.specialitems.SpecialItem;
import de.themoep.specialitems.SpecialItems;
import de.themoep.specialitems.actions.ActionSet;
import de.themoep.specialitems.actions.Trigger;
import de.themoep.specialitems.actions.TriggerType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;

public class ItemManager {
    private final SpecialItems plugin;
    private Map<String, SpecialItem> itemMap;

    public ItemManager(SpecialItems plugin) {
        this.plugin = plugin;
        int itemsLoaded = this.loadItems();
        plugin.getLogger().log(Level.INFO, itemsLoaded + " special items loaded!");
    }

    private int loadItems() {
        this.itemMap = new HashMap<String, SpecialItem>();
        Iterator recipes = this.plugin.getServer().recipeIterator();
        while (recipes.hasNext()) {
            Recipe recipe = (Recipe)recipes.next();
            if (SpecialItem.getId(recipe.getResult()) == null) continue;
            recipes.remove();
        }
        ConfigurationSection items = this.plugin.getConfig().getConfigurationSection("items");
        if (items == null || items.getKeys(false).size() == 0) {
            this.plugin.getLogger().log(Level.WARNING, "No special items configured?");
            return 0;
        }
        ArrayList<String> failedRecipes = new ArrayList<String>();
        for (String id : items.getKeys(false)) {
            try {
                ConfigurationSection itemSection = items.getConfigurationSection(id);
                SpecialItem item = new SpecialItem(id, itemSection.getString("displayname"), itemSection.getItemStack("item"), new ActionSet(itemSection.getConfigurationSection("actions")), itemSection.getStringList("lore"));
                this.itemMap.put(item.getId(), item);
                ConfigurationSection recipeSection = itemSection.getConfigurationSection("recipe");
                if (recipeSection != null && item.getItem() != null) {
                    ShapelessRecipe recipe;
                    block31: {
                        recipe = null;
                        try {
                            String recipeType = recipeSection.getString("type");
                            if ("shapeless".equalsIgnoreCase(recipeType)) {
                                recipe = new ShapelessRecipe(new NamespacedKey((Plugin)this.plugin, item.getId()), item.getItem());
                                for (String matStr : recipeSection.getConfigurationSection("materials").getKeys(false)) {
                                    Material mat = Material.valueOf((String)matStr.toUpperCase());
                                    recipe.addIngredient(recipeSection.getInt("materials." + matStr), mat);
                                }
                                break block31;
                            }
                            if ("shaped".equalsIgnoreCase(recipeType)) {
                                recipe = new ShapedRecipe(new NamespacedKey((Plugin)this.plugin, item.getId()), item.getItem());
                                List shape = recipeSection.getStringList("shape");
                                ((ShapedRecipe)recipe).shape(shape.toArray(new String[shape.size()]));
                                for (String rKey : recipeSection.getConfigurationSection("keys").getKeys(false)) {
                                    if (rKey.length() > 1) {
                                        throw new IllegalArgumentException("Shaped craft key " + rKey + " has to be a char and only be 1 long!");
                                    }
                                    Material mat = Material.valueOf((String)recipeSection.getString("keys." + rKey).toUpperCase());
                                    ((ShapedRecipe)recipe).setIngredient(rKey.toCharArray()[0], mat);
                                }
                                break block31;
                            }
                            if ("furnace".equalsIgnoreCase(recipeType)) {
                                recipe = new FurnaceRecipe(new NamespacedKey((Plugin)this.plugin, item.getId()), item.getItem(), Material.valueOf((String)recipeSection.getString("input")), (float)recipeSection.getDouble("experience", 0.0), recipeSection.getInt("time", 200));
                                ((FurnaceRecipe)recipe).setExperience((float)recipeSection.getDouble("exp"));
                                break block31;
                            }
                            throw new IllegalArgumentException(recipeType + " is not a supported or valid recipe type!");
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.getLogger().log(Level.SEVERE, "Could not load recipe for " + id + "!", e);
                        }
                    }
                    if (recipe != null) {
                        try {
                            if (!this.plugin.getServer().addRecipe((Recipe)recipe)) {
                                failedRecipes.add(id);
                            }
                        }
                        catch (IllegalStateException e) {
                            failedRecipes.add(id);
                        }
                    }
                }
                if (this.plugin.getConfig().getBoolean("permissions.use")) {
                    Permission usePerm = new Permission("specialitems.item." + id.toLowerCase() + ".use");
                    try {
                        this.plugin.getServer().getPluginManager().addPermission(usePerm);
                    }
                    catch (IllegalArgumentException e) {
                        usePerm = this.plugin.getServer().getPluginManager().getPermission(usePerm.getName());
                    }
                    if (this.plugin.getConfig().getBoolean("permissions.usepertrigger")) {
                        for (TriggerType trigger : TriggerType.values()) {
                            Permission triggerPerm = new Permission("specialitems.item." + id.toLowerCase() + ".use." + trigger.toString().toLowerCase());
                            triggerPerm.addParent(usePerm, true);
                            try {
                                this.plugin.getServer().getPluginManager().addPermission(usePerm);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (this.plugin.getConfig().getBoolean("permissions.craft")) {
                    Permission craftPerm = new Permission("specialitems.item." + id.toLowerCase() + ".craft");
                    try {
                        this.plugin.getServer().getPluginManager().addPermission(craftPerm);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (!this.plugin.getConfig().getBoolean("permissions.drop")) continue;
                Permission dropPerm = new Permission("specialitems.item." + id.toLowerCase() + ".drop");
                try {
                    this.plugin.getServer().getPluginManager().addPermission(dropPerm);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Error while loading item " + id + "!", e);
            }
        }
        if (!failedRecipes.isEmpty()) {
            this.plugin.getLogger().log(Level.WARNING, "Unable to add recipe for items " + failedRecipes + ". If this is a reload and you edited the config then existing recipes will not be edited due to limitations in the server!");
        }
        return this.itemMap.size();
    }

    public Collection<SpecialItem> getSpecialItems() {
        return this.itemMap.values();
    }

    public SpecialItem getSpecialItem(String id) {
        return this.itemMap.get(id.toLowerCase());
    }

    public SpecialItem getSpecialItem(ItemStack item) throws IllegalArgumentException {
        String id = SpecialItem.getId(item);
        if (id == null) {
            return null;
        }
        return this.getSpecialItem(id);
    }

    public Trigger executeActions(Trigger trigger) {
        try {
            SpecialItem item;
            SpecialItem specialItem = item = trigger.hasSpecialItem() ? trigger.getSpecialItem() : this.getSpecialItem(trigger.getItem());
            if (item != null) {
                trigger.setSpecialItem(item);
                boolean hasPermission = true;
                if (this.plugin.getConfig().getBoolean("permissions.usepertrigger")) {
                    hasPermission = this.plugin.checkPerm((CommandSender)trigger.getPlayer(), "specialitems.item." + item.getId() + ".use." + trigger.toString().toLowerCase(), "use");
                } else if (this.plugin.getConfig().getBoolean("permissions.use")) {
                    hasPermission = this.plugin.checkPerm((CommandSender)trigger.getPlayer(), "specialitems.item." + item.getId() + ".use", "use");
                }
                if (hasPermission) {
                    return item.getActionSet().execute(trigger);
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().log(Level.WARNING, trigger.getPlayer().getName() + " has an invalid item! " + e.getMessage());
        }
        return trigger;
    }

    public void setValue(String id, String key, Object object) {
        SpecialItem item = this.itemMap.get(id.toLowerCase());
        if (item != null) {
            this.plugin.getConfig().set("items." + item.getId() + "." + key.toLowerCase(), object);
            ConfigurationSection itemSection = this.plugin.getConfig().getConfigurationSection("items." + item.getId());
            item = new SpecialItem(item.getId(), itemSection.getString("displayname"), itemSection.getItemStack("item"), new ActionSet(itemSection.getConfigurationSection("actions")), itemSection.getStringList("lore"));
            this.itemMap.put(item.getId(), item);
            this.plugin.saveConfig();
        }
    }
}

