/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.specialitems;

import de.themoep.specialitems.SpecialItem;
import de.themoep.specialitems.SpecialItems;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ItemGui
implements Listener {
    private final SpecialItems plugin;
    private Set<UUID> viewers = new HashSet<UUID>();

    public ItemGui(SpecialItems plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void show(Player player) {
        player.closeInventory();
        this.viewers.add(player.getUniqueId());
        int invSize = this.plugin.getItemManager().getSpecialItems().size();
        invSize = invSize + 9 - invSize % 9;
        Inventory inv = this.plugin.getServer().createInventory(null, invSize, this.plugin.getName());
        for (SpecialItem item : this.plugin.getItemManager().getSpecialItems()) {
            inv.addItem(new ItemStack[]{item.getItem()});
        }
        player.openInventory(inv);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (this.viewers.contains(event.getWhoClicked().getUniqueId())) {
            event.setCancelled(true);
            if (event.isLeftClick() && event.getClickedInventory() == event.getView().getTopInventory() && this.plugin.checkPerm((CommandSender)event.getWhoClicked(), "specialitems.gui.take", "gui.take")) {
                if (event.getWhoClicked().getInventory().addItem(new ItemStack[]{event.getCurrentItem()}).size() == 0) {
                    if (event.getWhoClicked() instanceof Player) {
                        ((Player)event.getWhoClicked()).updateInventory();
                    }
                } else {
                    event.getWhoClicked().sendMessage(this.plugin.getTag() + ChatColor.RED + " You need an empty slot in your inventory!");
                }
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (event.getWhoClicked().getOpenInventory() == event.getView().getTopInventory() && this.viewers.contains(event.getWhoClicked().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (this.viewers.contains(event.getPlayer().getUniqueId())) {
            this.viewers.remove(event.getPlayer().getUniqueId());
        }
    }

    @EventHandler
    public void onLogout(PlayerQuitEvent event) {
        if (this.viewers.contains(event.getPlayer().getUniqueId())) {
            this.viewers.remove(event.getPlayer().getUniqueId());
        }
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        if (this.viewers.contains(event.getPlayer().getUniqueId())) {
            event.getPlayer().closeInventory();
            this.viewers.remove(event.getPlayer().getUniqueId());
        }
    }

    public void destroy() {
        for (UUID id : this.viewers) {
            Player player = this.plugin.getServer().getPlayer(id);
            if (player == null || !player.isOnline()) continue;
            player.closeInventory();
        }
        this.viewers.clear();
    }
}

