/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.ShowItem.api.data;

import de.themoep.ShowItem.api.data.InvData;
import de.themoep.ShowItem.api.data.LiveData;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class LiveInvData
implements InvData,
LiveData {
    private final UUID playerId;
    private String playerName;
    private WeakReference<Player> playerReference;
    private Set<UUID> viewers = new HashSet<UUID>();

    public LiveInvData(Player player) {
        this.playerId = player.getUniqueId();
        this.playerName = player.getName();
        this.playerReference = new WeakReference<Player>(player);
    }

    @Override
    public UUID getPlayerId() {
        return this.playerId;
    }

    @Override
    public String getPlayerName() {
        return this.playerName;
    }

    @Override
    public ItemStack getHelmet() {
        if (this.isValid()) {
            return ((Player)this.playerReference.get()).getInventory().getHelmet();
        }
        return null;
    }

    @Override
    public ItemStack getChestplate() {
        if (this.isValid()) {
            return ((Player)this.playerReference.get()).getInventory().getChestplate();
        }
        return null;
    }

    @Override
    public ItemStack getLeggings() {
        if (this.isValid()) {
            return ((Player)this.playerReference.get()).getInventory().getLeggings();
        }
        return null;
    }

    @Override
    public ItemStack getBoots() {
        if (this.isValid()) {
            return ((Player)this.playerReference.get()).getInventory().getBoots();
        }
        return null;
    }

    @Override
    public ItemStack getItemInOffHand() {
        if (this.isValid()) {
            try {
                return ((Player)this.playerReference.get()).getInventory().getItemInOffHand();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public ItemStack[] getStorageContents() {
        if (this.isValid()) {
            try {
                return ((Player)this.playerReference.get()).getInventory().getStorageContents();
            }
            catch (NoSuchMethodError e) {
                return ((Player)this.playerReference.get()).getInventory().getContents();
            }
        }
        return new ItemStack[36];
    }

    @Override
    public boolean isValid() {
        if (this.playerReference.get() == null) {
            Player player = Bukkit.getPlayer((UUID)this.playerId);
            if (player == null) {
                return false;
            }
            this.playerReference = new WeakReference<Player>(player);
            this.playerName = player.getName();
        }
        return true;
    }

    @Override
    public Set<UUID> getViewers() {
        return this.viewers;
    }
}

