/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.java.JavaPlugin;

public class ReflectionUtils {
    private String serverVersion;
    private final Map<String, Class<?>> classes = new HashMap();
    private final Map<String, Method> methods = new HashMap<String, Method>();
    private final Map<String, Field> fields = new HashMap<String, Field>();

    public ReflectionUtils(JavaPlugin plugin) {
        String packageName = plugin.getServer().getClass().getPackage().getName();
        this.serverVersion = packageName.substring(packageName.lastIndexOf(46) + 1);
        if (!this.serverVersion.startsWith("v")) {
            this.serverVersion = null;
        }
    }

    public Class<?> getClass(String className) throws ClassNotFoundException {
        if (!this.classes.containsKey(className)) {
            throw new ClassNotFoundException("No class with the name " + className + " registered!");
        }
        return this.classes.get(className);
    }

    public Method getMethod(String name) throws NoSuchMethodException {
        if (!this.methods.containsKey(name)) {
            throw new NoSuchMethodException("No method with the name " + name + " registered!");
        }
        return this.methods.get(name);
    }

    public Field getField(String name) throws NoSuchFieldException {
        if (!this.fields.containsKey(name)) {
            throw new NoSuchFieldException("No field with the name " + name + " registered!");
        }
        return this.fields.get(name);
    }

    public Object invoke(String name, Object object, Object ... args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method m = this.getMethod(name);
        Object r = m.invoke(object, args);
        if (!m.getReturnType().equals(Void.TYPE)) {
            return r;
        }
        return null;
    }

    public Class<?> registerClass(String path) throws ClassNotFoundException {
        return this.registerClass(path, path.substring(path.lastIndexOf(46) + 1));
    }

    public Class<?> registerClass(String path, String className) throws ClassNotFoundException {
        Class<?> c = Class.forName(path.replace(".%VERSION%", this.serverVersion != null ? "." + this.serverVersion : ""));
        this.classes.put(className, c);
        return c;
    }

    public Method registerMethod(String className, String methodName, Class<?> returnType, Class<?> ... parameters) throws ClassNotFoundException, NoSuchMethodException, WrongTypeException {
        Class<?> c = this.getClass(className);
        Method m = ReflectionUtils.getMethod(c, methodName, returnType, parameters);
        this.methods.put(className + "." + methodName, m);
        return m;
    }

    public Method registerObfuscatedMethod(String className, String methodName, Class<?> returnType, Class<?> ... parameters) throws ClassNotFoundException, NoSuchMethodException {
        return this.registerObfuscatedMethod(className, methodName, "a", returnType, parameters);
    }

    public Method registerObfuscatedMethod(String className, String methodName, String obf, Class<?> returnType, Class<?> ... parameters) throws ClassNotFoundException, NoSuchMethodException {
        Method foundMethod = this.getClass(className).getDeclaredMethod(obf, parameters);
        if (foundMethod == null) {
            foundMethod = this.getClass(className).getDeclaredMethod(methodName, parameters);
        }
        if (foundMethod == null) {
            for (Method m : this.getClass(className).getDeclaredMethods()) {
                if (m.getReturnType() != returnType || m.getParameterTypes() != parameters) continue;
                foundMethod = m;
                break;
            }
        }
        if (foundMethod != null) {
            foundMethod.setAccessible(true);
            this.methods.put(className + "." + methodName, foundMethod);
            return foundMethod;
        }
        StringBuilder stringParam = new StringBuilder("[");
        if (parameters.length > 0) {
            stringParam.append(parameters[0].getSimpleName());
            for (int i = 1; i < parameters.length; ++i) {
                stringParam.append(", ").append(parameters[i].getSimpleName());
            }
        }
        stringParam.append("]");
        throw new NoSuchMethodException("No method with the return type " + returnType.getName() + " and parameters " + stringParam.toString() + " found in " + className + "!");
    }

    public Field registerField(String className, String name, Class<?> fieldType) throws ClassNotFoundException, NoSuchFieldException, WrongTypeException {
        Field f = this.getClass(className).getField(name);
        if (fieldType != null && f.getType() != fieldType) {
            throw new WrongTypeException("Field " + name + " in class " + className + " is not of type " + fieldType.getName());
        }
        this.fields.put(className + "." + name, f);
        return f;
    }

    public Field registerObfuscatedField(String className, String fieldName, Class<?> fieldType) throws ClassNotFoundException, NoSuchFieldException {
        return this.registerObfuscatedField(className, fieldName, "a", fieldType);
    }

    public Field registerObfuscatedField(String className, String fieldName, String obf, Class<?> fieldType) throws ClassNotFoundException, NoSuchFieldException {
        Field foundField = this.getClass(className).getDeclaredField(obf);
        if (foundField == null || foundField.getType() != fieldType) {
            for (Field f : this.getClass(className).getDeclaredFields()) {
                if (f.getType() != fieldType) continue;
                foundField = f;
                break;
            }
        }
        if (foundField != null && foundField.getType() == fieldType) {
            foundField.setAccessible(true);
            this.fields.put(className + "." + fieldName, foundField);
            return foundField;
        }
        throw new NoSuchFieldException("No field with the type " + fieldType.getName() + " found in " + className + "!");
    }

    public static Method getMethod(Class<?> c, String name, Class<?> returnType, Class<?> ... args) throws NoSuchMethodException, WrongTypeException {
        Method m = c.getMethod(name, args);
        if (returnType != null && m.getReturnType() != returnType) {
            throw new WrongTypeException("Method " + name + " in class " + c.getName() + " does not return " + returnType.getName());
        }
        return m;
    }

    public static class WrongTypeException
    extends Exception {
        public WrongTypeException(String msg) {
            super(msg);
        }
    }
}

