/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.utils;

import org.bukkit.ChatColor;
import org.bukkit.Color;

public class ColorUtils {
    static Color[] colors = new Color[]{Color.fromRGB((int)0, (int)0, (int)0), Color.fromRGB((int)0, (int)0, (int)170), Color.fromRGB((int)0, (int)170, (int)0), Color.fromRGB((int)0, (int)170, (int)170), Color.fromRGB((int)170, (int)0, (int)0), Color.fromRGB((int)170, (int)0, (int)170), Color.fromRGB((int)255, (int)170, (int)0), Color.fromRGB((int)170, (int)170, (int)170), Color.fromRGB((int)85, (int)85, (int)85), Color.fromRGB((int)85, (int)85, (int)255), Color.fromRGB((int)85, (int)255, (int)85), Color.fromRGB((int)85, (int)255, (int)255), Color.fromRGB((int)255, (int)85, (int)85), Color.fromRGB((int)255, (int)85, (int)255), Color.fromRGB((int)255, (int)255, (int)85), Color.fromRGB((int)255, (int)255, (int)255)};

    private static double getDistance(Color colorA, Color colorB) {
        double mean = (double)(colorA.getRed() + colorB.getRed()) / 2.0;
        double r = colorA.getRed() - colorB.getRed();
        double g = colorA.getGreen() - colorB.getGreen();
        int b = colorA.getBlue() - colorB.getBlue();
        double weightR = 2.0 + mean / 256.0;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - mean) / 256.0;
        return weightR * r * r + weightG * g * g + weightB * (double)b * (double)b;
    }

    public static ChatColor getNearestChatColor(Color color) {
        int index = 0;
        int best = -1;
        for (int i = 0; i < colors.length; ++i) {
            double distance = ColorUtils.getDistance(color, colors[i]);
            if (!(distance < (double)best) && best != -1) continue;
            best = (int)distance;
            index = i;
        }
        return ChatColor.values()[index];
    }
}

