/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.rewards.plugin.triggers;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.themoep.rewards.api.trigger.Trigger;
import de.themoep.rewards.api.trigger.TriggerData;
import de.themoep.rewards.api.trigger.TriggerInfo;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;

@TriggerInfo(args={"type", "data", "height"})
public class BlockBreakTrigger
extends Trigger
implements Listener {
    private Cache<String, Material> placeCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(60L, TimeUnit.MINUTES).build();

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void blockBroken(BlockBreakEvent event) {
        Material placed = (Material)this.placeCache.getIfPresent((Object)this.toCacheKey(event.getBlock().getLocation()));
        if (placed == null || placed != event.getBlock().getType()) {
            this.trigger(event.getPlayer(), new TriggerData("type", event.getBlock().getType().toString(), "data", event.getBlock().getBlockData().getAsString(), "height", String.valueOf(event.getBlock().getLocation().getBlockY())));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        this.placeCache.put((Object)this.toCacheKey(event.getBlock().getLocation()), (Object)event.getBlock().getType());
    }

    private String toCacheKey(Location loc) {
        return loc.getWorld().getName() + "/" + loc.getBlockX() + "/" + loc.getBlockY() + "/" + loc.getBlockZ();
    }
}

