/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.rewards.plugin.storage;

import de.themoep.rewards.api.user.TrackData;
import de.themoep.rewards.api.user.UserData;
import de.themoep.rewards.api.user.UserStorage;
import de.themoep.rewards.api.user.VoteData;
import de.themoep.rewards.api.utils.ConfigAccessor;
import de.themoep.rewards.plugin.Rewards;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class YamlStorage
implements UserStorage {
    private final Rewards plugin;
    private final ConfigAccessor config;
    private final ConfigAccessor votesConfig;

    public YamlStorage(Rewards plugin) {
        this.plugin = plugin;
        this.config = new ConfigAccessor((Plugin)plugin, "users.yml");
        this.votesConfig = new ConfigAccessor((Plugin)plugin, "offline-votes.yml");
    }

    @Override
    public UserData getData(Player player) {
        return this.getData(player.getUniqueId(), player.getName());
    }

    @Override
    public UserData getData(UUID playerId, String playerName) {
        if (this.config.getConfig().contains(playerId.toString(), true)) {
            HashMap<String, TrackData> trackData = new HashMap<String, TrackData>();
            ConfigurationSection data = this.config.getConfig().getConfigurationSection(playerId.toString());
            ConfigurationSection tracks = data.getConfigurationSection("tracks");
            if (tracks != null) {
                for (String track : tracks.getKeys(false)) {
                    HashMap<String, Long> lastTriggered = new HashMap<String, Long>();
                    ConfigurationSection lastTriggeredSection = tracks.getConfigurationSection(track + ".last-triggered");
                    if (lastTriggeredSection != null) {
                        for (String triggerId : lastTriggeredSection.getKeys(false)) {
                            lastTriggered.put(triggerId, lastTriggeredSection.getLong(triggerId));
                        }
                    }
                    trackData.put(track, new TrackData(tracks.getInt(track + ".points", 0), new LinkedHashSet<String>(tracks.getStringList(track + ".unlocked")), lastTriggered));
                }
            }
            return new UserData(playerId, playerName != null ? playerName : data.getString("name"), trackData);
        }
        return new UserData(playerId, playerName, new HashMap<String, TrackData>());
    }

    @Override
    public void save(UserData userData) {
        ConfigurationSection data = this.config.getConfig().createSection(userData.getUserId().toString());
        data.set("name", (Object)userData.getUserName());
        for (Map.Entry<String, TrackData> entry : userData.getTrackData().entrySet()) {
            data.set("tracks." + entry.getKey() + ".points", (Object)entry.getValue().getPoints());
            data.set("tracks." + entry.getKey() + ".unlocked", new ArrayList<String>(entry.getValue().getUnlocked()));
            data.createSection("tracks." + entry.getKey() + ".last-triggered", entry.getValue().getLastTriggered());
        }
        this.config.saveConfig();
    }

    @Override
    public void addVoteData(VoteData voteData) {
        List voteList = this.votesConfig.getConfig().getMapList(voteData.getUsername().toLowerCase(Locale.ROOT));
        LinkedHashMap<String, Object> voteMap = new LinkedHashMap<String, Object>();
        voteMap.put("username", voteData.getUsername());
        voteMap.put("site", voteData.getServiceName());
        voteMap.put("address", voteData.getAddress());
        voteMap.put("timestamp", voteData.getTimeStamp());
        voteMap.put("local-timestamp", voteData.getLocalTimestamp());
        voteList.add(voteMap);
        this.votesConfig.getConfig().set(voteData.getUsername().toLowerCase(Locale.ROOT), (Object)voteList);
        this.votesConfig.saveConfig();
    }

    @Override
    public List<VoteData> getVoteData(String playerName) {
        ArrayList<VoteData> voteList = new ArrayList<VoteData>();
        for (Map voteConfig : this.votesConfig.getConfig().getMapList(playerName.toLowerCase(Locale.ROOT))) {
            try {
                VoteData vote = new VoteData(String.valueOf(voteConfig.get("site")), String.valueOf(voteConfig.get("username")), String.valueOf(voteConfig.get("address")), String.valueOf(voteConfig.get("timestamp")), voteConfig.get("local-timestamp") instanceof Long ? (Long)voteConfig.get("local-timestamp") : Long.parseLong(String.valueOf(voteConfig.get("local-timestamp"))));
                voteList.add(vote);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Unable to load vote from config! " + voteConfig + ". " + e.getMessage());
            }
        }
        return voteList;
    }

    @Override
    public List<VoteData> getAndRemoveVoteData(String playerName) {
        List<VoteData> voteList = this.getVoteData(playerName);
        this.removeVoteData(playerName);
        return voteList;
    }

    @Override
    public void removeVoteData(String playerName) {
        this.votesConfig.getConfig().set(playerName.toLowerCase(Locale.ROOT), null);
        this.votesConfig.saveConfig();
    }
}

