/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.rewards.plugin.storage;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.themoep.rewards.api.user.TrackData;
import de.themoep.rewards.api.user.UserData;
import de.themoep.rewards.api.user.UserStorage;
import de.themoep.rewards.api.user.VoteData;
import de.themoep.rewards.plugin.Rewards;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.entity.Player;

public class StorageCache
implements UserStorage {
    private final Rewards plugin;
    private final Cache<UUID, UserData> userCache;
    private final Cache<String, List<VoteData>> voteCache;
    private UserStorage storage;

    public StorageCache(Rewards plugin, UserStorage storage) {
        long cacheDuration = plugin.getConfig().getLong("user-cache-duration");
        if (cacheDuration == -1L) {
            cacheDuration = Long.MAX_VALUE;
        }
        this.userCache = CacheBuilder.newBuilder().expireAfterAccess(cacheDuration, TimeUnit.SECONDS).build();
        long voteCacheDuration = plugin.getConfig().getLong("vote-cache-duration");
        if (voteCacheDuration == -1L) {
            voteCacheDuration = Long.MAX_VALUE;
        }
        this.voteCache = CacheBuilder.newBuilder().expireAfterAccess(voteCacheDuration, TimeUnit.SECONDS).build();
        this.plugin = plugin;
        this.storage = storage;
    }

    @Override
    public UserData getData(Player player) {
        return this.getData(player.getUniqueId(), player.getName());
    }

    @Override
    public UserData getData(UUID playerId, String playerName) {
        try {
            return (UserData)this.userCache.get((Object)playerId, () -> this.storage.getData(playerId, playerName));
        }
        catch (ExecutionException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load user data of " + playerName, e);
            return new UserData(playerId, playerName, new HashMap<String, TrackData>());
        }
    }

    @Override
    public void save(UserData userData) {
        this.storage.save(userData);
    }

    @Override
    public void addVoteData(VoteData voteData) {
        List<VoteData> votes = this.getVoteData(voteData.getUsername());
        votes.add(voteData);
        this.storage.addVoteData(voteData);
    }

    @Override
    public List<VoteData> getVoteData(String playerName) {
        try {
            return (List)this.voteCache.get((Object)playerName.toLowerCase(Locale.ROOT), () -> this.storage.getVoteData(playerName));
        }
        catch (ExecutionException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load vote data of " + playerName, e);
            return new ArrayList<VoteData>();
        }
    }

    @Override
    public List<VoteData> getAndRemoveVoteData(String playerName) {
        List<VoteData> votes = this.getVoteData(playerName);
        this.removeVoteData(playerName);
        return votes;
    }

    @Override
    public void removeVoteData(String playerName) {
        this.storage.removeVoteData(playerName);
        this.voteCache.invalidate((Object)playerName.toLowerCase(Locale.ROOT));
    }

    public void invalidate(Player player) {
        this.userCache.invalidate((Object)player.getUniqueId());
        this.voteCache.invalidate((Object)player.getName().toLowerCase(Locale.ROOT));
    }
}

