/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.rewards.plugin.managers;

import de.themoep.rewards.api.RewardsPlugin;
import de.themoep.rewards.api.track.Track;
import de.themoep.rewards.api.trigger.Trigger;
import de.themoep.rewards.api.trigger.TriggerData;
import de.themoep.rewards.api.user.TrackData;
import de.themoep.rewards.api.user.UserData;
import de.themoep.rewards.api.utils.DateTimeUtils;
import de.themoep.rewards.plugin.Rewards;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TriggerManager {
    private final Rewards plugin;
    private final Map<String, TriggerInfo> triggers = new HashMap<String, TriggerInfo>();

    public TriggerManager(Rewards plugin) {
        this.plugin = plugin;
    }

    public void registerTrigger(Trigger trigger) throws IllegalArgumentException {
        de.themoep.rewards.api.trigger.TriggerInfo info = trigger.getClass().getAnnotation(de.themoep.rewards.api.trigger.TriggerInfo.class);
        if (info == null) {
            throw new IllegalArgumentException("TriggerInfo annotation is missing from Trigger class!");
        }
        if (trigger instanceof Listener) {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)trigger, (Plugin)this.plugin);
        }
        this.triggers.put(trigger.getName().toLowerCase(), new TriggerInfo(trigger, info));
    }

    public Collection<Trigger> getTriggers() {
        return this.triggers.values().stream().map(TriggerInfo::getTrigger).collect(Collectors.toList());
    }

    public Trigger.Response trigger(Player player, String triggerId, TriggerData data) {
        TriggerInfo trigger = this.triggers.get(triggerId);
        if (trigger == null || trigger.getTracks().isEmpty()) {
            return null;
        }
        Trigger.Response response = null;
        for (String trackId : trigger.getTracks()) {
            Track track = this.plugin.getTrack(trackId);
            if (track == null || !track.canAccess((CommandSender)player) || !track.isTriggered(triggerId, data.asMap())) continue;
            if (response == null) {
                response = new Trigger.Response();
            }
            Track.TriggerConfig config = track.getTriggerConfig(triggerId);
            for (Map.Entry<String, String> entry : config.getResponses().entrySet()) {
                response.add(track, entry.getKey(), entry.getValue());
            }
            this.plugin.runAsync(() -> {
                UserData userData = this.plugin.getUserStorage().getData(player);
                TrackData trackData = userData.getTrackData(track);
                if (trackData == null) {
                    trackData = new TrackData();
                    userData.setTrackData(track, trackData);
                }
                if (!config.getFrequency().isEmpty() && trackData.getLastTriggered().containsKey(triggerId)) {
                    long delay = 0L;
                    try {
                        delay = TimeUnit.SECONDS.toMillis(Long.parseLong(config.getFrequency()));
                    }
                    catch (NumberFormatException e) {
                        switch (config.getFrequency()) {
                            case "hourly": {
                                delay = TimeUnit.HOURS.toMillis(1L);
                                break;
                            }
                            case "daily": {
                                delay = TimeUnit.DAYS.toMillis(1L);
                                break;
                            }
                            case "weekly": {
                                delay = TimeUnit.DAYS.toMillis(7L);
                                break;
                            }
                            case "monthly": {
                                delay = TimeUnit.DAYS.toMillis(30L);
                            }
                        }
                    }
                    this.plugin.logDebug(trackId + " for " + player.getName() + " with trigger " + triggerId + " has frequency " + config.getFrequency() + ".  (delay: " + delay + ", last: " + trackData.getLastTriggered().get(triggerId) + ")");
                    if (delay > 0L && trackData.getLastTriggered().get(triggerId) + delay > System.currentTimeMillis()) {
                        this.plugin.logDebug("Not triggering it");
                        return;
                    }
                }
                if (track.shouldReset() && !trackData.getLastTriggered().isEmpty() && track.getStart() != null && !track.getStart().isEmpty()) {
                    try {
                        LocalDate startDate = DateTimeUtils.parseDate(track.getStart());
                        boolean resetData = true;
                        for (Long lastTriggered : trackData.getLastTriggered().values()) {
                            if (lastTriggered < startDate.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli()) continue;
                            resetData = false;
                            break;
                        }
                        if (resetData) {
                            trackData = new TrackData();
                            userData.setTrackData(track, trackData);
                        }
                    }
                    catch (DateTimeParseException e) {
                        RewardsPlugin.getPlugin().getLogger().log(Level.SEVERE, "Start date is not a valid MonthDay in track " + track.getId() + "! Config: " + track.toString(), e);
                    }
                }
                trackData.getLastTriggered().put(triggerId, System.currentTimeMillis());
                this.plugin.trigger(player, userData, track, track.getPoints(triggerId, data));
            });
        }
        return response;
    }

    public void addToTrigger(String triggerId, String trackId) {
        if (this.triggers.containsKey(triggerId.toLowerCase())) {
            this.triggers.get(triggerId.toLowerCase()).addTrack(trackId);
        }
    }

    public static class TriggerInfo {
        private final Trigger trigger;
        private final List<String> args;
        private final List<String> tracks;

        public TriggerInfo(Trigger trigger, de.themoep.rewards.api.trigger.TriggerInfo info) {
            this.trigger = trigger;
            this.args = Arrays.asList(info.args());
            this.tracks = new ArrayList<String>();
        }

        public void addTrack(String trackId) {
            this.tracks.add(trackId);
        }

        public String getName() {
            return this.trigger.getName();
        }

        public Trigger getTrigger() {
            return this.trigger;
        }

        public List<String> getArgs() {
            return this.args;
        }

        public List<String> getTracks() {
            return this.tracks;
        }
    }
}

