/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.rewards.plugin.managers;

import de.themoep.rewards.api.events.PlayerAdvanceTrackEvent;
import de.themoep.rewards.api.events.PlayerMakeTrackPointsEvent;
import de.themoep.rewards.api.track.Reward;
import de.themoep.rewards.api.track.Track;
import de.themoep.rewards.api.track.TrackLevel;
import de.themoep.rewards.api.user.TrackData;
import de.themoep.rewards.api.user.UserData;
import de.themoep.rewards.api.utils.SoundInfo;
import de.themoep.rewards.plugin.Rewards;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.zip.ZipError;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TrackManager {
    private final Rewards plugin;
    private final Map<String, Track> tracks;

    public TrackManager(final Rewards plugin) {
        File trackFolder;
        block12: {
            this.tracks = new HashMap<String, Track>();
            this.plugin = plugin;
            trackFolder = new File(plugin.getDataFolder(), "tracks");
            if (!trackFolder.exists()) {
                trackFolder.mkdirs();
                try {
                    URL url = ((Object)((Object)plugin)).getClass().getResource("/tracks");
                    if (url == null) break block12;
                    URI uri = url.toURI();
                    try (FileSystem fileSystem = uri.getScheme().equals("jar") ? FileSystems.newFileSystem(uri, Collections.emptyMap()) : null;){
                        Files.walkFileTree(Paths.get(uri), EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                                String fileName = file.getFileName().toString();
                                if (fileName.endsWith(".yml")) {
                                    plugin.saveResource("tracks/" + fileName, false);
                                }
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                }
                catch (IOException | URISyntaxException | ZipError e) {
                    plugin.getLogger().log(Level.WARNING, "Error while trying to store example tracks from the jar!", e);
                }
            }
        }
        try {
            Files.walkFileTree(trackFolder.toPath(), EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String fileName = file.getFileName().toString();
                    if (fileName.endsWith(".yml")) {
                        String trackId = fileName.substring(0, fileName.length() - ".yml".length());
                        try {
                            YamlConfiguration trackConfig = YamlConfiguration.loadConfiguration((File)file.toFile());
                            Track track = new Track(trackId, (ConfigurationSection)trackConfig);
                            TrackManager.this.tracks.put(track.getId(), track);
                            for (String trigger : track.getTriggers().keySet()) {
                                plugin.getTriggerManager().addToTrigger(trigger, track.getId());
                            }
                            plugin.getLogger().log(Level.INFO, "Loaded " + track.getId());
                            plugin.logDebug(track.toString());
                        }
                        catch (IllegalArgumentException e) {
                            plugin.getLogger().log(Level.SEVERE, "Error while loading track '" + trackId + "' from the config: " + e.getMessage());
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.SEVERE, "Error loading tracks!", e);
        }
        if (this.tracks.isEmpty()) {
            plugin.getLogger().log(Level.SEVERE, "No tracks defined in tracks folder!");
        }
    }

    public Track getTrack(String trackId) {
        return this.tracks.get(trackId.toLowerCase());
    }

    public Collection<Track> getTracks() {
        return this.tracks.values();
    }

    public void trigger(Player player, UserData userData, Track track, int points) {
        UUID playerId = player.getUniqueId();
        this.plugin.runAsync(() -> {
            PlayerMakeTrackPointsEvent pointsEvent;
            TrackData trackData = userData.getTrackData(track);
            int currentPoints = 0;
            TrackLevel currentLevel = null;
            if (trackData != null) {
                currentLevel = track.getLevel(trackData.getPoints());
                currentPoints = trackData.getPoints();
            }
            if (!(pointsEvent = new PlayerMakeTrackPointsEvent(player, userData, track, currentPoints, points)).isCancelled()) {
                int newPoints = currentPoints + pointsEvent.getAmount();
                if (trackData == null) {
                    trackData = new TrackData();
                    userData.setTrackData(track, trackData);
                }
                trackData.setPoints(newPoints);
                TrackLevel newLevel = track.getLevel(newPoints);
                if (currentLevel != newLevel) {
                    PlayerAdvanceTrackEvent advanceEvent = new PlayerAdvanceTrackEvent(player, track, newLevel);
                    this.plugin.getServer().getPluginManager().callEvent((Event)advanceEvent);
                    if (!advanceEvent.isCancelled()) {
                        this.plugin.logDebug("Advancing track " + track.getId() + " for player " + player.getName());
                        this.plugin.sendMessage((CommandSender)player, "tracks." + track.getId() + "|default.received", "level", String.valueOf(newLevel.getId()), "track", this.plugin.getText((CommandSender)player, "tracks." + track.getId() + "|default.name", "id", track.getId()), "points", String.valueOf(newPoints), "reward-count", String.valueOf(newLevel.getRewards().size()), "rewards", this.plugin.getText((CommandSender)player, "tracks." + track.getId() + "|default.level" + newLevel.getId() + ".rewards", new String[0]));
                        SoundInfo sound = newLevel.getSound();
                        if (sound == null) {
                            sound = track.getSound();
                        }
                        if (sound != null) {
                            player.playSound(player.getLocation(), sound.getSound(), sound.getVolume(), sound.getPitch());
                        }
                        ArrayList<Reward> rewards = new ArrayList<Reward>();
                        for (Reward reward : newLevel.getRewards()) {
                            if (reward.getPermission() != null && !player.hasPermission(reward.getPermission()) || reward.getUnlock() != null && !userData.hasUnlocked(track, reward.getUnlock())) continue;
                            rewards.add(reward);
                        }
                        this.plugin.rewardPlayer(playerId, rewards);
                    }
                }
                this.plugin.getUserStorage().save(userData);
            }
        });
    }
}

