/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.rewards.plugin.gui;

import de.themoep.rewards.api.track.Track;
import de.themoep.rewards.api.track.TrackLevel;
import de.themoep.rewards.api.user.TrackData;
import de.themoep.rewards.api.user.UserData;
import de.themoep.rewards.api.utils.ItemUtils;
import de.themoep.rewards.lib.inventorygui.GuiElement;
import de.themoep.rewards.lib.inventorygui.GuiElementGroup;
import de.themoep.rewards.lib.inventorygui.StaticGuiElement;
import de.themoep.rewards.plugin.Rewards;
import de.themoep.rewards.plugin.gui.RewardsGui;
import de.themoep.rewards.plugin.gui.TrackGui;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TracksGui
extends RewardsGui {
    public TracksGui(Rewards plugin, Player player, UserData userData, List<Track> tracks) {
        super(plugin, player, "tracks", "amount", String.valueOf(tracks.size()));
        GuiElementGroup group = new GuiElementGroup('t', new GuiElement[0]);
        tracks.sort((t1, t2) -> plugin.getText((CommandSender)player, "tracks." + t1.getId() + ".name", new String[0]).compareToIgnoreCase(plugin.getText((CommandSender)player, "tracks." + t2.getId() + ".name", new String[0])));
        for (Track track : tracks) {
            TrackData trackData = userData.getTrackData(track);
            TrackLevel level = trackData != null ? track.getLevel(trackData.getPoints()) : null;
            ItemStack icon = track.getIcon();
            if (level != null && track.getLevels().size() == level.getId()) {
                icon = ItemUtils.glow(icon.clone());
            }
            String[] stringArray = new String[1];
            String[] stringArray2 = new String[12];
            stringArray2[0] = "name";
            stringArray2[1] = plugin.getText((CommandSender)player, "tracks." + track.getId() + ".name", new String[0]);
            stringArray2[2] = "description";
            stringArray2[3] = plugin.getText((CommandSender)player, "tracks." + track.getId() + ".description", new String[0]);
            stringArray2[4] = "points";
            stringArray2[5] = trackData != null ? String.valueOf(trackData.getPoints()) : "0";
            stringArray2[6] = "level";
            stringArray2[7] = level != null ? String.valueOf(level.getId()) : "0";
            stringArray2[8] = "next-level";
            stringArray2[9] = level != null ? (track.getLevels().size() < level.getId() ? String.valueOf(level.getId() + 1) : "-") : "1";
            stringArray2[10] = "next-level-points";
            stringArray2[11] = level != null ? (track.getLevels().size() < level.getId() ? String.valueOf(track.getLevels().get(level.getId()).getRequired()) : "-") : String.valueOf(track.getLevels().get(0).getRequired());
            stringArray[0] = this.getText(player, "track-entry", stringArray2);
            group.addElement(new StaticGuiElement('t', icon, click -> {
                new TrackGui(plugin, (Player)click.getWhoClicked(), userData, track);
                return true;
            }, stringArray));
        }
        this.gui.addElement(group);
        this.gui.show((HumanEntity)player);
    }
}

