/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.rewards.plugin.gui;

import de.themoep.rewards.api.utils.ItemUtils;
import de.themoep.rewards.lib.inventorygui.GuiElement;
import de.themoep.rewards.lib.inventorygui.GuiPageElement;
import de.themoep.rewards.lib.inventorygui.InventoryGui;
import de.themoep.rewards.plugin.Rewards;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class RewardsGui {
    private static final Map<String, ItemStack> ITEM_CACHE = new HashMap<String, ItemStack>();
    private final Function<String, ItemStack> itemLoader;
    protected final Rewards plugin;
    protected final Player player;
    protected final String id;
    protected final InventoryGui gui;

    protected RewardsGui(Rewards plugin, Player player, String id, String ... replacements) {
        this.plugin = plugin;
        this.player = player;
        this.id = id;
        this.gui = new InventoryGui((JavaPlugin)plugin, this.getText(player, "title", replacements), plugin.getConfig().isString("gui." + id + ".setup") ? plugin.getConfig().getString("gui." + id + ".setup").split("\\n") : plugin.getConfig().getStringList("gui." + id + ".setup").toArray(new String[0]), new GuiElement[0]);
        this.itemLoader = key -> {
            try {
                return ItemUtils.buildItem(this.plugin.getConfig().get("gui." + this.id + "." + key));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().log(Level.WARNING, "Unable to build item found for " + key + " of gui " + this.id + ": " + e.getMessage());
                return new ItemStack(Material.BARRIER);
            }
        };
        this.gui.setFiller(this.getItem("filler"));
        this.gui.addElement(new GuiPageElement('p', this.getItem("previous"), GuiPageElement.PageAction.PREVIOUS, this.getText(player, "previous", new String[0])));
        this.gui.addElement(new GuiPageElement('n', this.getItem("next"), GuiPageElement.PageAction.NEXT, this.getText(player, "next", new String[0])));
    }

    protected ItemStack getItem(String key) {
        return ITEM_CACHE.computeIfAbsent(key, this.itemLoader);
    }

    protected String getText(Player player, String key, String ... replacements) {
        return this.plugin.getText((CommandSender)player, "gui." + this.id + "." + key, replacements);
    }
}

